/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.tasklist.javaparser;

import javax.swing.text.*;
import javax.swing.event.*;
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import org.openide.ErrorManager;
import org.openide.explorer.view.*;
import org.openide.nodes.*;
import org.netbeans.modules.java.*;

import org.openide.loaders.DataObject;
import org.openide.text.Line;

import org.netbeans.editor.ext.java.*;
import org.netbeans.modules.editor.java.*;

import org.netbeans.modules.tasklist.core.ConfPanel;
import org.netbeans.modules.tasklist.core.TLUtils;
import org.netbeans.modules.tasklist.client.Suggestion;
import org.netbeans.modules.tasklist.client.SuggestionPerformer;


/**
 * This class performs casting to a required type
 * <p>
 * @todo I have both the class name, and the fully qualified class name.
 * If I use the FQCN the source code gets pretty ugly (especially
 * in the presense of long package paths, e.g.
 * SuggestionImpl s = (org.netbeans.modules.tasklist.suggestions.SuggestionImpl)it.next();
 * So for now, I'm just casting to the class name (SuggestionImpl) above.
 * But should I add an import statement too?
 *
 * @author Tor Norbye
 */
class CastPerformer implements SuggestionPerformer {
    
    private int column;
    private Line line;
    private DataObject dobj;
    private Document doc;
    private String reqType;
    private String reqClass;
    private String beforeDesc;

    CastPerformer(int column, Line line, DataObject dobj,
                  Document doc,
                  String reqType,
                  String reqClass,
                  String beforeDesc) {
        this.column = column;
        this.line = line;
        this.dobj = dobj;
        this.doc = doc;
        this.reqType = reqType;
        this.reqClass = reqClass;
        this.beforeDesc = beforeDesc;
    }

    public boolean hasConfirmation() {
        return true;
    }
    
    public Object getConfirmation(Suggestion s) {
        String filename =
            dobj.getPrimaryFile().getNameExt();
        StringBuffer sb = new StringBuffer(200);
        Line l = line;
        String text = l.getText();
        
        // Underline differences
        sb.append("<html>"); // NOI18N
        TLUtils.appendSurroundingLine(sb, l, -1);
        TLUtils.appendHTMLString(sb, text.substring(0, column));
        sb.append("<b>("); // NOI18N
        sb.append(reqClass);
        sb.append(")</b>"); // NOI18N
        TLUtils.appendHTMLString(sb, text.substring(column));
        //sb.append("<br>");
        TLUtils.appendSurroundingLine(sb, l, +1);
        sb.append("</html>"); // NOI18N
        String beforeContents = sb.toString();
        int lineno = line.getLineNumber();
        return new ConfPanel(beforeDesc, beforeContents, null, 
                             null, filename, lineno, null);
    }
    
    public void perform(Suggestion s) {
        if (!(doc instanceof StyledDocument)) {
            return;
        }
        
        int lineno = line.getLineNumber();
        StyledDocument sdoc = (StyledDocument)doc;
        
        Element e = sdoc.getParagraphElement(0).getParentElement();
        if (e == null) {
            // try default root (should work for text/plain)
            e = sdoc.getDefaultRootElement();
        }
        Element elm = e.getElement(lineno);
        if (elm == null) {
            return;
        }
        int offset = elm.getStartOffset();
        
        try {
            int pos = offset + column;
            sdoc.insertString(pos, "(" + reqClass + ")", null);

            // MakeMethodPerformer has this issue; is this relevant
            // for incompatible types too?
            //    Interestingly, at least on OSX with jdk1.3, I may get
            //    a "wrong" column, e.g. it will point at "foo" in
            //    "foo".length
            //    ^
            //    So I've gotta start searching forward
        } catch (BadLocationException ex) {
            ErrorManager.getDefault().notify(ErrorManager.WARNING, ex);
        }
    }
}

