/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.tasklist.javaparser;

import javax.swing.text.*;
import javax.swing.event.*;
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import java.util.List;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import org.openide.ErrorManager;
import org.openide.cookies.SourceCookie;
import org.openide.explorer.view.*;
import org.openide.nodes.*;
import org.netbeans.modules.java.*;



import org.openide.src.Identifier;
import org.openide.src.Import;
import org.openide.src.SourceElement;
import org.openide.src.SourceException;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

import org.openide.cookies.LineCookie;
import org.openide.loaders.DataObject;
import org.openide.text.Line;
import org.openide.ErrorManager;

import java.util.TreeSet;
import java.lang.reflect.Modifier;
import org.netbeans.editor.ext.java.*;
import org.netbeans.modules.editor.java.*;

import org.netbeans.modules.tasklist.core.ConfPanel;
import org.netbeans.modules.tasklist.core.TLUtils;
import org.netbeans.modules.tasklist.client.Suggestion;
import org.netbeans.modules.tasklist.client.SuggestionPerformer;


/**
 * This class performs class import suggestions
 *
 * @author Tor Norbye
 */
class ImportPerformer implements SuggestionPerformer {
    
    private DataObject dobj;
    private Document doc;
    private String beforeDesc;
    private JCClass importClass;
    private int lineno;

    ImportPerformer(int lineno, DataObject dobj,
                    Document doc, JCClass importClass) {
        this.lineno = lineno;
        this.dobj = dobj;
        this.doc = doc;
        this.importClass = importClass;

    }

    // Yay - it's a casing-error
    public void perform(Suggestion s) {
        importClass(doc, importClass);
    }

     public boolean hasConfirmation() {
         return true;
     }
     
     public Object getConfirmation(Suggestion s) {
         String filename =
             dobj.getPrimaryFile().getNameExt();
         String beforeDesc =
             NbBundle.getMessage(ImportPerformer.class,
                                 "ImportClassConfirmation"); // NOI18N
         String beforeContents =
             "<html><b>import " + // NOI18N
             importClass.toString() +
             "</b></html>"; //NOI18N
         return new ConfPanel(beforeDesc,
                              beforeContents, null,
                              null,
                              filename, lineno,
                              null);
     }


    /** Import a particular class into the given document */
    static void importClass(Document doc, Object item) {
        if (item instanceof JCClass || item instanceof JCPackage) {
            Object o = doc.getProperty(Document.StreamDescriptionProperty);
            if (o instanceof DataObject) {
                DataObject dob = (DataObject)o;
                SourceCookie sc = (SourceCookie)dob.getCookie(SourceCookie.class);
                if (sc != null) {
                    SourceElement se = sc.getSource();
                    if (se != null) {
                        try {
                            if (item instanceof JCClass){
                                JCClass cls = (JCClass)item;
                                se.addImport(new Import(Identifier.create(cls.getFullName()), false));
                            }else if (item instanceof JCPackage){
                                JCPackage pkg = (JCPackage)item;
                                se.addImport(new Import(Identifier.create(pkg.getName()), true));
                            }
                        } catch (SourceException e) {
                        }
                    }
                }
            }
        }
    }
    

}

