/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.tasklist.javaparser;

import org.netbeans.modules.tasklist.core.TLUtils;

/**
 * Utility methods extracted from TLUtil because
 * non-javaparser usages exists.
 */
public class JPUtils {
    /** Replace the given symbol on the line with the new symbol - starting
        roughly at the given column (symbol should be at col or col+1)
        @param sb Buffer to write into
        @param text The text to be copied into the buffer, except for
            the substitution of symbol into newSymbol.
        @param pos Earliest possible starting position of the symbol
        @param symbol The symbol which may occur multiple times; we want
            each reference replaced (provided it's a java identifier - not
            a prefix or suffix of a larger identifier
        @param newSymbol The string to replace the old symbol
        @param bold If true, make the new symbol bold
        @param underlineBegin If -1, underline the newSymbol starting at
            this position, ending at underlineEnd.
        @param underlineEnd Only considererdd if underlineBegin != -1;
            ending position for underlining started at underlineBegin.
    */
    public static void replaceSymbol(StringBuffer sb, String text, int pos, String symbol,
                                     String newSymbol, boolean bold,
                                     int underlineBegin, int underlineEnd) {
        //System.out.println("replace('" + text + "', " + pos + ", '" + symbol + "', '" + newSymbol + "')");
        if (pos > 0) {
            // For some compilers, the position is off by 1 so make sure
            // we catch the earliest possible match
            pos--;
        }
        int from = 0;
        int symLen = symbol.length();
        int texLen = text.length();
        while (true) {
            int n = text.indexOf(symbol, pos);
            if (n == -1) {
                break;
            }
            if ((n+symLen < texLen-1) &&
                Character.isJavaIdentifierPart(text.charAt(n+symLen))) {
                pos = n+symLen;
                continue;
            }

            for (int i = from; i < n; i++) {
                TLUtils.appendHTMLChar(sb, text.charAt(i));
            }
            if (bold) {
                sb.append("<b>"); // NOI18N
            }
            if (underlineBegin != -1) {
                for (int i = 0; i < underlineBegin; i++) {
                    TLUtils.appendHTMLChar(sb, newSymbol.charAt(i));
                }
                sb.append("<u>"); // NOI18N
                for (int i = underlineBegin; i < underlineEnd; i++) {
                    TLUtils.appendHTMLChar(sb, newSymbol.charAt(i));
                }
                sb.append("</u>"); // NOI18N
                int nl = newSymbol.length();
                for (int i = underlineEnd; i < nl; i++) {
                    TLUtils.appendHTMLChar(sb, newSymbol.charAt(i));
                }
            } else {
                TLUtils.appendHTMLString(sb, newSymbol);
            }
            if (bold) {
                sb.append("</b>"); // NOI18N
            }
            pos = n+symLen;
            from = pos;
        }
        for (int i = from; i < texLen; i++) {
            TLUtils.appendHTMLChar(sb, text.charAt(i));
        }
    }
}
