/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.tasklist.usertasks.actions;

import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import javax.swing.KeyStroke;
import org.netbeans.modules.tasklist.usertasks.UTUtils;
import org.netbeans.modules.tasklist.usertasks.UserTaskViewRegistry;
import org.netbeans.modules.tasklist.usertasks.model.UserTask;
import org.netbeans.modules.tasklist.usertasks.UserTaskNode;
import org.netbeans.modules.tasklist.usertasks.model.UserTaskObjectList;
import org.netbeans.modules.tasklist.usertasks.UserTaskView;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.NodeAction;

/**
 * Moves a task down
 */
public class MoveDownAction extends NodeAction {
    /**
     * Creates a new instance
     */
    public MoveDownAction() {
        putValue(ACCELERATOR_KEY, KeyStroke.getKeyStroke(KeyEvent.VK_DOWN,
                InputEvent.CTRL_MASK));
    }
    
    protected void performAction(org.openide.nodes.Node[] activatedNodes) {
        UserTaskNode n = (UserTaskNode) activatedNodes[0];
        UserTask ut = n.getTask();
        UserTaskView utv = UserTaskViewRegistry.getInstance().getCurrent();
        Object es = utv.getTreeTable().getExpandedNodesAndSelection();
        ut.moveDown();
        utv.getTreeTable().setExpandedNodesAndSelection(es);
    }
    
    protected boolean enable(org.openide.nodes.Node[] activatedNodes) {
        if (activatedNodes.length != 1)
            return false;
        
        if (!(activatedNodes[0] instanceof UserTaskNode))
            return false;
        
        UTUtils.LOGGER.fine("checking the index"); // NOI18N
        UserTaskNode n = (UserTaskNode) activatedNodes[0];
        UserTask ut = n.getTask();
        
        if (ut.getList() == null)
            return false;
        
        UserTaskObjectList list;
        if (ut.getParent() == null)
            list = ut.getList().getSubtasks();
        else
            list = ut.getParent().getSubtasks();
        
        if (list.indexOf(ut) == list.size() - 1) 
            return false;
        
        return true;
    }
    
    protected String iconResource() {
        return "org/netbeans/modules/tasklist/usertasks/actions/moveDown.gif"; // NOI18N
    }
    
    public org.openide.util.HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }
    
    public String getName() {
        return NbBundle.getMessage(MoveUpAction.class, "MoveDown"); // NOI18N
    }    
    
    protected boolean asynchronous() {
        return false;
    }    
}
