/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.tasklist.usertasks.options;

import javax.swing.SpinnerNumberModel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.tasklist.usertasks.Settings;

/**
 * Panel with options.
 *
 * @author tl
 */
public class UTOptionsPanel extends javax.swing.JPanel {
    private SpinnerNumberModel hoursPerDayModel = 
        new SpinnerNumberModel(1, 1, 24, 1);
    private SpinnerNumberModel daysPerWeekModel = 
        new SpinnerNumberModel(1, 1, 7, 1);
    private boolean changed;
    
    /** 
     * Creates new form UTOptionsPanel.
     */
    public UTOptionsPanel() {
        initComponents();
        jTextFieldFile.getDocument().addDocumentListener(new DocumentListener() {
            public void changedUpdate(DocumentEvent e) {
                fileChanged();
            }
            public void insertUpdate(DocumentEvent e) {
                fileChanged();
            }
            public void removeUpdate(DocumentEvent e) {
                fileChanged();
            }
        });
    }

    /**
     * Component should update its content.
     */
    public void update() {
        Settings s = Settings.getDefault();
        jCheckBoxAppend.setSelected(s.getAppend());
        jCheckBoxCollectWorkPeriods.setSelected(s.getCollectWorkPeriods());
        jCheckBoxSaveBackups.setSelected(s.getBackups());
        jSpinnerHours.setValue(new Integer(s.getHoursPerDay()));
        jSpinnerDays.setValue(new Integer(s.getDaysPerWeek()));
        jTextFieldFile.setText(s.getFilename());
        jCheckBoxDetectInactivity.setSelected(s.getDetectInactivity());
        jCheckBoxAutoSwitchToComputed.setSelected(s.getAutoSwitchToComputed());
        changed = false;
    }

    /**
     * This method is called when Options Dialog "OK" button is pressed.
     */
    public void applyChanges() {
        if (!changed)
            return;
        
        Settings s = Settings.getDefault();
        s.setAppend(jCheckBoxAppend.isSelected());
        s.setCollectWorkPeriods(jCheckBoxCollectWorkPeriods.isSelected());
        s.setBackups(jCheckBoxSaveBackups.isSelected());
        s.setHoursPerDay(((Integer) jSpinnerHours.getValue()).intValue());
        s.setDaysPerWeek(((Integer) jSpinnerDays.getValue()).intValue());
        s.setFilename(jTextFieldFile.getText());
        s.setDetectInactivity(jCheckBoxDetectInactivity.isSelected());
        s.setAutoSwitchToComputed(jCheckBoxAutoSwitchToComputed.isSelected());
    }

    /**
     * This method is called when Options Dialog "Cancel" button is pressed.
     */
    public void cancel() {
        
    }
    
    /**
     * Will be called if the text in the default file text field has changed.
     */
    private void fileChanged() {
        changed = true;
    }
    
    /**
     * Was the data changed?
     *
     * @return true = changed
     */
    public boolean isChanged() {
        return changed;
    }
    
    /** 
     * This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        jCheckBoxAppend = new javax.swing.JCheckBox();
        jCheckBoxSaveBackups = new javax.swing.JCheckBox();
        jCheckBoxCollectWorkPeriods = new javax.swing.JCheckBox();
        jLabel1 = new javax.swing.JLabel();
        jSpinnerHours = new javax.swing.JSpinner();
        jLabel2 = new javax.swing.JLabel();
        jSpinnerDays = new javax.swing.JSpinner();
        jLabel3 = new javax.swing.JLabel();
        jTextFieldFile = new javax.swing.JTextField();
        jPanel1 = new javax.swing.JPanel();
        jCheckBoxDetectInactivity = new javax.swing.JCheckBox();
        jCheckBoxAutoSwitchToComputed = new javax.swing.JCheckBox();

        setLayout(new java.awt.GridBagLayout());

        org.openide.awt.Mnemonics.setLocalizedText(jCheckBoxAppend, org.openide.util.NbBundle.getMessage(UTOptionsPanel.class, "AppendVsPrepend"));
        jCheckBoxAppend.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
        jCheckBoxAppend.setMargin(new java.awt.Insets(0, 0, 0, 0));
        jCheckBoxAppend.setOpaque(false);
        jCheckBoxAppend.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jCheckBoxAppendActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 0, 11, 0);
        add(jCheckBoxAppend, gridBagConstraints);

        org.openide.awt.Mnemonics.setLocalizedText(jCheckBoxSaveBackups, org.openide.util.NbBundle.getMessage(UTOptionsPanel.class, "SaveBackups"));
        jCheckBoxSaveBackups.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
        jCheckBoxSaveBackups.setMargin(new java.awt.Insets(0, 0, 0, 0));
        jCheckBoxSaveBackups.setOpaque(false);
        jCheckBoxSaveBackups.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jCheckBoxSaveBackupsActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 0, 11, 0);
        add(jCheckBoxSaveBackups, gridBagConstraints);

        org.openide.awt.Mnemonics.setLocalizedText(jCheckBoxCollectWorkPeriods, org.openide.util.NbBundle.getMessage(UTOptionsPanel.class, "CollectWorkPeriods"));
        jCheckBoxCollectWorkPeriods.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
        jCheckBoxCollectWorkPeriods.setMargin(new java.awt.Insets(0, 0, 0, 0));
        jCheckBoxCollectWorkPeriods.setOpaque(false);
        jCheckBoxCollectWorkPeriods.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jCheckBoxCollectWorkPeriodsActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 0, 11, 0);
        add(jCheckBoxCollectWorkPeriods, gridBagConstraints);

        jLabel1.setLabelFor(jSpinnerHours);
        org.openide.awt.Mnemonics.setLocalizedText(jLabel1, org.openide.util.NbBundle.getMessage(UTOptionsPanel.class, "HoursPerDay"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 0, 11, 12);
        add(jLabel1, gridBagConstraints);

        jSpinnerHours.setModel(hoursPerDayModel);
        jSpinnerHours.setPreferredSize(new java.awt.Dimension(40, 20));
        jSpinnerHours.addChangeListener(new javax.swing.event.ChangeListener() {
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                jSpinnerHoursStateChanged(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 0, 11, 0);
        add(jSpinnerHours, gridBagConstraints);

        jLabel2.setLabelFor(jSpinnerDays);
        org.openide.awt.Mnemonics.setLocalizedText(jLabel2, org.openide.util.NbBundle.getMessage(UTOptionsPanel.class, "DaysPerWeek"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 0, 11, 12);
        add(jLabel2, gridBagConstraints);

        jSpinnerDays.setModel(daysPerWeekModel);
        jSpinnerDays.setPreferredSize(new java.awt.Dimension(40, 20));
        jSpinnerDays.addChangeListener(new javax.swing.event.ChangeListener() {
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                jSpinnerDaysStateChanged(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 0, 11, 0);
        add(jSpinnerDays, gridBagConstraints);

        jLabel3.setLabelFor(jTextFieldFile);
        org.openide.awt.Mnemonics.setLocalizedText(jLabel3, org.openide.util.NbBundle.getMessage(UTOptionsPanel.class, "DefaultUserTasksFile"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 0, 0, 12);
        add(jLabel3, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        add(jTextFieldFile, gridBagConstraints);

        jPanel1.setOpaque(false);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        add(jPanel1, gridBagConstraints);

        org.openide.awt.Mnemonics.setLocalizedText(jCheckBoxDetectInactivity, org.openide.util.NbBundle.getBundle(UTOptionsPanel.class).getString("DetectInactivity"));
        jCheckBoxDetectInactivity.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
        jCheckBoxDetectInactivity.setMargin(new java.awt.Insets(0, 0, 0, 0));
        jCheckBoxDetectInactivity.setOpaque(false);
        jCheckBoxDetectInactivity.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jCheckBoxDetectInactivityActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 0, 11, 0);
        add(jCheckBoxDetectInactivity, gridBagConstraints);

        org.openide.awt.Mnemonics.setLocalizedText(jCheckBoxAutoSwitchToComputed, org.openide.util.NbBundle.getBundle(UTOptionsPanel.class).getString("AutoSwithToComputed"));
        jCheckBoxAutoSwitchToComputed.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
        jCheckBoxAutoSwitchToComputed.setMargin(new java.awt.Insets(0, 0, 0, 0));
        jCheckBoxAutoSwitchToComputed.setOpaque(false);
        jCheckBoxAutoSwitchToComputed.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jCheckBoxAutoSwitchToComputedActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 0, 11, 0);
        add(jCheckBoxAutoSwitchToComputed, gridBagConstraints);

    }// </editor-fold>//GEN-END:initComponents

    private void jCheckBoxAutoSwitchToComputedActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jCheckBoxAutoSwitchToComputedActionPerformed
        changed = true;
    }//GEN-LAST:event_jCheckBoxAutoSwitchToComputedActionPerformed

    private void jCheckBoxDetectInactivityActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jCheckBoxDetectInactivityActionPerformed
        changed = true;
    }//GEN-LAST:event_jCheckBoxDetectInactivityActionPerformed

    private void jSpinnerDaysStateChanged(javax.swing.event.ChangeEvent evt) {//GEN-FIRST:event_jSpinnerDaysStateChanged
        changed = true;
    }//GEN-LAST:event_jSpinnerDaysStateChanged

    private void jSpinnerHoursStateChanged(javax.swing.event.ChangeEvent evt) {//GEN-FIRST:event_jSpinnerHoursStateChanged
        changed = true;
    }//GEN-LAST:event_jSpinnerHoursStateChanged

    private void jCheckBoxCollectWorkPeriodsActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jCheckBoxCollectWorkPeriodsActionPerformed
        changed = true;
    }//GEN-LAST:event_jCheckBoxCollectWorkPeriodsActionPerformed

    private void jCheckBoxSaveBackupsActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jCheckBoxSaveBackupsActionPerformed
        changed = true;
    }//GEN-LAST:event_jCheckBoxSaveBackupsActionPerformed

    private void jCheckBoxAppendActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jCheckBoxAppendActionPerformed
        changed = true;
    }//GEN-LAST:event_jCheckBoxAppendActionPerformed
        
    // Variables declaration - do not modify//GEN-BEGIN:variables
    public javax.swing.JCheckBox jCheckBoxAppend;
    public javax.swing.JCheckBox jCheckBoxAutoSwitchToComputed;
    public javax.swing.JCheckBox jCheckBoxCollectWorkPeriods;
    public javax.swing.JCheckBox jCheckBoxDetectInactivity;
    public javax.swing.JCheckBox jCheckBoxSaveBackups;
    public javax.swing.JLabel jLabel1;
    public javax.swing.JLabel jLabel2;
    public javax.swing.JLabel jLabel3;
    public javax.swing.JPanel jPanel1;
    public javax.swing.JSpinner jSpinnerDays;
    public javax.swing.JSpinner jSpinnerHours;
    public javax.swing.JTextField jTextFieldFile;
    // End of variables declaration//GEN-END:variables
}
