/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.tasklist.usertasks.renderers;

import java.awt.Component;
import org.netbeans.modules.tasklist.usertasks.UTUtils;
import org.netbeans.modules.tasklist.usertasks.UserTaskTreeTableNode;
import org.netbeans.modules.tasklist.usertasks.treetable.BooleanTableCellRenderer;
import org.netbeans.modules.tasklist.usertasks.treetable.TreeTableRenderer;

/**
 * Cell renderer for the "done" property.
 *
 * @author tl
 */
public class DoneTreeTableCellRenderer extends BooleanTableCellRenderer 
implements TreeTableRenderer {
    /** 
     * Creates a new instance of DoneTreeTableCellRenderer
     */
    public DoneTreeTableCellRenderer() {
    }

    public java.awt.Component getTreeTableCellRendererComponent(
            org.netbeans.modules.tasklist.usertasks.treetable.TreeTable table, 
            Object node, Object value, boolean isSelected, boolean hasFocus, 
            int row, int column) {
        Component cmp = super.getTableCellRendererComponent(
                table, value, isSelected, hasFocus, 
                row, column);
        if (value == null)
            return cmp;
        
        if (node instanceof UserTaskTreeTableNode) {
            boolean b = ((UserTaskTreeTableNode) node).getUserTask().
                    isProgressComputed();
            setEnabled(!b);
        }
        return this;
    }
}
