/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.tomcat5;

import org.netbeans.junit.NbTestCase;

/**
 *
 * @author Radim Kubacki
 */
public class TomcatFactory55Test extends NbTestCase {
    
    public static final String TOMCAT_URI = "tomcat55:home=$bundled_home:base=$bundled_base";
    
    public TomcatFactory55Test(String testName) {
        super(testName);
    }
    
    /** Test of getDeploymentManager method, of class org.netbeans.modules.tomcat5.TomcatFactory55. */
    public void testGetDeploymentManager() {
        System.out.println("testGetDeploymentManager");
        TomcatFactory55 tf = TomcatFactory55.create();
        try {
            assertNotNull("getDeploymentManager", tf.getDeploymentManager(TOMCAT_URI, null, null));
        } catch(Exception ex) {
            fail("getDeploymentManager threw an exception "+ex);
        }
    }
    
    /** Test of getDisconnectedDeploymentManager method, of class org.netbeans.modules.tomcat5.TomcatFactory55. */
    public void testGetDisconnectedDeploymentManager() {
        System.out.println("testGetDisconnectedDeploymentManager");
        TomcatFactory55 tf = TomcatFactory55.create();
        try {
            assertNotNull("getDisconnectedDeploymentManager", tf.getDisconnectedDeploymentManager(TOMCAT_URI));
        } catch(Exception ex) {
            fail("getDeploymentManager threw an exception "+ex);
        }
    }
    
    /** Test of getDisconnectedDeploymentManager method, of class org.netbeans.modules.tomcat5.TomcatFactory55. */
    public void testBundledDeploymentManager() {
        System.out.println("testBundledDeploymentManager");
        TomcatFactory55 tf = TomcatFactory55.create();
        try {
            TomcatManager tm =(TomcatManager)tf.getDisconnectedDeploymentManager(TOMCAT_URI);
            assertNotNull("getDisconnectedDeploymentManager", tm);
        } catch(Exception ex) {
            fail("getDeploymentManager threw an exception "+ex);
        }
    }
    
    /** Test of getDisplayName method, of class org.netbeans.modules.tomcat5.TomcatFactory55. */
    public void testGetDisplayName() {
        System.out.println("testGetDisplayName");
        assertNotNull("display name must not be null", TomcatFactory55.create().getDisplayName());
    }
    
    /** Test of getProductVersion method, of class org.netbeans.modules.tomcat5.TomcatFactory55. */
    public void testGetProductVersion() {
        System.out.println("testGetProductVersion");
        assertNotNull("product version must not be null", TomcatFactory55.create().getProductVersion());
    }
    
    /** Test of handlesURI method, of class org.netbeans.modules.tomcat5.TomcatFactory55. */
    public void testHandlesURI() {
        System.out.println("testHandlesURI");
        TomcatFactory55 tf = TomcatFactory55.create();
        
        assertFalse("handlesURI for null", tf.handlesURI(null));
        assertFalse("handlesURI for bad string", tf.handlesURI("arbitrary string"));
        assertFalse("handlesURI for bad version of Tomcat", tf.handlesURI("tomcat:home=$bundled_home:base=$bundled_base"));
        assertTrue("handlesURI for tomcat's URI", tf.handlesURI(TOMCAT_URI));
    }
}
