/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.tomcat5;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.enterprise.deploy.model.DDBean;
import javax.enterprise.deploy.model.DDBeanRoot;
import javax.enterprise.deploy.model.DeployableObject;
import javax.enterprise.deploy.model.XpathListener;
import javax.enterprise.deploy.model.exceptions.DDBeanCreateException;
import javax.enterprise.deploy.shared.ModuleType;
import org.netbeans.api.db.explorer.ConnectionManager;
import org.netbeans.api.db.explorer.DatabaseConnection;
import org.netbeans.api.db.explorer.JDBCDriver;
import org.netbeans.junit.NbTestCase;
import org.netbeans.modules.j2ee.deployment.common.api.DatasourceAlreadyExistsException;
import org.netbeans.modules.tomcat5.config.WebappConfiguration;
import org.netbeans.modules.tomcat5.config.gen.Context;
import org.netbeans.modules.tomcat5.config.gen.Parameter;
import org.netbeans.modules.tomcat5.config.gen.ResourceParams;

/**
 *
 * @author Radim Kubacki
 */
public class WebappConfigurationTest extends NbTestCase {
    
    final String DRIVER_NAME = "driverName";
    final String DRIVER_DISPLAY_NAME = "driverDisplayName";
    final String DRIVER_CLASS = "driverClass";
    final String USER = "user";
    final String PASSWORD = "password";
    final String DB_URL = "dburl";
    final String SCHEMA = "schema";
    
    public WebappConfigurationTest (java.lang.String testName) {
        super (testName);
    }
    
    protected void setUp() throws Exception {
        super.setUp();
        registerConnection();
    }
    
    private void registerConnection() throws Exception {
        JDBCDriver driver = JDBCDriver.create(DRIVER_NAME, DRIVER_DISPLAY_NAME, DRIVER_CLASS, new URL[]{});
        DatabaseConnection dbCon = DatabaseConnection.create(driver, DB_URL, USER, SCHEMA, PASSWORD, true);
        ConnectionManager.getDefault().addConnection(dbCon);
    }
    
    // work-around private access
    private void createJDBCReference(WebappConfiguration conf, String name, String url, 
            String username, String password, String driverClassName) throws Exception {
        Method addResReference = WebappConfiguration.class.getDeclaredMethod(
            "createJDBCReference", 
            new Class [] {
                String.class, String.class, String.class, String.class, String.class
            }
        );
        addResReference.setAccessible(true);
        addResReference.invoke(conf, new Object[]{name, url, username, password, driverClassName});
    }
    
    public void testAddResReference50() throws Exception {
        
        final String[][] res = {
            {"jdbc/myDatabase", "jdbc:derby://localhost:1527/sample", "app", "app", "org.apache.derby.jdbc.ClientDriver"},
            {"jdbc/myDatabase1", "jdbc:derby://localhost:1527/sample1", "app1", "app1", "org.apache.derby.jdbc.ClientDriver"},
        };
            
        DeployableObject depObj = new DeployableObjectImpl();
        WebappConfiguration conf = new WebappConfiguration(depObj, TomcatManager.TOMCAT_50);
        clearWorkDir();
        conf.init(new File(getWorkDir(), "context.xml"));
        
        String dbName = ConnectionManager.getDefault().getConnections()[0].getName();
        for (int i = 0; i < res.length; i++) {
            createJDBCReference(conf, res[i][0], res[i][1], res[i][2], res[i][3], res[i][4]);
        }
        
        Context ctx = conf.getContext();
        boolean[] resource = ctx.getResource();
        for (int i = 0; i < res.length; i++) {
            assertEquals("javax.sql.DataSource", ctx.getResourceType(i));
            assertEquals("Container", ctx.getResourceAuth(i));
            assertEquals(res[i][0], ctx.getResourceName(i));
            
            ResourceParams[] resourceParams = ctx.getResourceParams();
            assertEquals(res[i][0], resourceParams[i].getName());
            Map<String,String> paramMap = new HashMap<String,String>();
            for (Parameter param : resourceParams[i].getParameter()) {
                paramMap.put(param.getName(), param.getValue());
            }
            assertEquals(res[i][1], paramMap.get("url"));
            assertEquals(res[i][2], paramMap.get("username"));
            assertEquals(res[i][3], paramMap.get("password"));
            assertEquals(res[i][4], paramMap.get("driverClassName"));
        }
        
        // lets try to add an already defined resource now
        try {
            createJDBCReference(conf, res[0][0], res[0][1], res[0][2], res[0][3], res[0][4]);
            fail();
        } catch (InvocationTargetException e) {
            assertTrue(e.getCause() instanceof DatasourceAlreadyExistsException);
        }
    }
    
    public void testAddResReference55() throws Exception {
        
        final String[][] res = {
            {"jdbc/myDatabase", "jdbc:derby://localhost:1527/sample", "app", "app", "org.apache.derby.jdbc.ClientDriver"},
            {"jdbc/myDatabase1", "jdbc:derby://localhost:1527/sample1", "app1", "app1", "org.apache.derby.jdbc.ClientDriver"},
        };
            
        DeployableObject depObj = new DeployableObjectImpl();
        WebappConfiguration conf = new WebappConfiguration(depObj, TomcatManager.TOMCAT_55);
        clearWorkDir();
        conf.init(new File(getWorkDir(), "context.xml"));
        
        for (int i = 0; i < res.length; i++) {
            createJDBCReference(conf, res[i][0], res[i][1], res[i][2], res[i][3], res[i][4]);
        }
        
        Context ctx = conf.getContext();
        boolean[] resource = ctx.getResource();
        for (int i = 0; i < res.length; i++) {
            assertEquals("javax.sql.DataSource", ctx.getResourceType(i));
            assertEquals(res[i][0], ctx.getResourceName(i));
            assertEquals(res[i][1], ctx.getResourceUrl(i));
            assertEquals(res[i][2], ctx.getResourceUsername(i));
            assertEquals(res[i][3], ctx.getResourcePassword(i));
            assertEquals(res[i][4], ctx.getResourceDriverClassName(i));
        }
        
        // lets try to add an already defined resource now
        try {
            createJDBCReference(conf, res[0][0], res[0][1], res[0][2], res[0][3], res[0][4]);
            fail();
        } catch (InvocationTargetException e) {
            assertTrue(e.getCause() instanceof DatasourceAlreadyExistsException);
        }
    }
    
    
    public void testSetContextPath50() throws Exception {
        DeployableObject depObj = new DeployableObjectImpl();
        WebappConfiguration conf = new WebappConfiguration(depObj, TomcatManager.TOMCAT_50);
        clearWorkDir();
        conf.init(new File(getWorkDir(), "context.xml"));
        String[][] res = {
            {"/test", "test."},
            {"/test/test", "test_test."},
            {"", "ROOT."},
        };
        for (int i = 0; i < res.length; i++) {
            conf.setContextPath(res[i][0]);
            assertEquals(res[i][0], conf.getContextPath());
            assertEquals(res[i][1], conf.getContext().getLoggerPrefix());
        }
    }
    
    public void testSetContextPath55() throws Exception {
        DeployableObject depObj = new DeployableObjectImpl();
        WebappConfiguration conf = new WebappConfiguration(depObj, TomcatManager.TOMCAT_55);
        clearWorkDir();
        conf.init(new File(getWorkDir(), "context.xml"));
        String[] res = {
            "/test",
            "/test/test",
            "",
        };
        for (int i = 0; i < res.length; i++) {
            conf.setContextPath(res[i]);
            assertEquals(res[i], conf.getContextPath());
        }
    }
    
    private static class DeployableObjectImpl implements DeployableObject {
        public ModuleType getType() {
            return null;
        }

        public DDBeanRoot getDDBeanRoot() {
            return new DDBeanRootImpl();
        }

        public DDBean[] getChildBean(String string) {
            return null;
        }

        public String[] getText(String string) {
            return null;
        }

        public Class getClassFromScope(String string) {
            return null;
        }

        public String getModuleDTDVersion() {
            return null;
        }

        public DDBeanRoot getDDBeanRoot(String string) throws FileNotFoundException, DDBeanCreateException {
            return null;
        }

        public Enumeration entries() {
            return null;
        }

        public InputStream getEntry(String string) {
            return null;
        }

    };
    
    private static class DDBeanRootImpl implements DDBeanRoot {
        public ModuleType getType() {
            return null;
        }

        public DeployableObject getDeployableObject() {
            return null;
        }

        public String getModuleDTDVersion() {
            return null;
        }

        public String getDDBeanRootVersion() {
            return null;
        }

        public String getXpath() {
            return null;
        }

        public String getFilename() {
            return null;
        }

        public String getText() {
            return null;
        }

        public String getId() {
            return null;
        }

        public DDBeanRoot getRoot() {
            return null;
        }

        public DDBean[] getChildBean(String string) {
            return null;
        }

        public String[] getText(String string) {
            return null;
        }

        public void addXpathListener(String string, XpathListener xpathListener) {
        }

        public void removeXpathListener(String string, XpathListener xpathListener) {
        }

        public String[] getAttributeNames() {
            return null;
        }

        public String getAttributeValue(String string) {
            return null;
        }
    };
}
