/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.tomcat5.util;

import java.io.File;
import junit.textui.TestRunner;
import org.netbeans.junit.NbTestCase;
import org.netbeans.junit.NbTestSuite;
import org.netbeans.modules.tomcat5.TomcatFactory55;
import org.netbeans.modules.tomcat5.TomcatFactory55Test;
import org.netbeans.modules.tomcat5.TomcatManager;
import org.openide.util.Utilities;

/**
 *
 * @author herolds
 */
public class TomcatPropertiesTest extends NbTestCase {
    
    private TomcatManager tm;

    public TomcatPropertiesTest(String testName) {
        super(testName);
    }
    
    public static NbTestSuite suite() {
        NbTestSuite suite = new NbTestSuite();
        suite.addTest(new TomcatPropertiesTest("testGetServerXml"));
        suite.addTest(new TomcatPropertiesTest("testGetMonitor"));
        suite.addTest(new TomcatPropertiesTest("testGetShutdownPort"));
        suite.addTest(new TomcatPropertiesTest("testGetServerPort"));
        suite.addTest(new TomcatPropertiesTest("testGetCatalinaDir"));
        suite.addTest(new TomcatPropertiesTest("testGetHost"));
        suite.addTest(new TomcatPropertiesTest("testGetDebugType"));
        return suite;
    }
    
    public TomcatProperties getProperties() {
        tm.ensureCatalinaBaseReady(); // ensure that the base dir gets created
        return tm.getTomcatProperties();
    }
    
    protected void setUp() throws Exception {
        super.setUp ();
        tm = (TomcatManager)TomcatFactory55.create().getDeploymentManager(TomcatFactory55Test.TOMCAT_URI, null, null);
    }
    
    public void testGetMonitor() {
        assertTrue(getProperties().getMonitor());
    }
    
    public void testGetShutdownPort() {
        assertEquals(getProperties().getShutdownPort(), 8025);
    }
    
    public void testGetServerPort() {
        assertEquals(getProperties().getServerPort(), 8084);
    }
    
    public void testGetCatalinaDir() {
        TomcatProperties tp = getProperties();
        assertEquals(tp.getCatalinaDir(), tp.getCatalinaBase());
    }
    
    public void testGetHost() {
        assertEquals(getProperties().getHost(), "localhost");
    }
    
    public void testGetDebugType() {
        assertEquals(getProperties().getDebugType(), 
                     Utilities.isWindows() ? TomcatProperties.DEBUG_TYPE_SHARED 
                                           : TomcatProperties.DEBUG_TYPE_SOCKET);
    }
    
    public void testGetServerXml() {
        TomcatProperties tp = tm.getTomcatProperties();
        
        // make sure the base folder does not exist
        TestUtils.rm(tp.getCatalinaBase());
        
        // we should get server.xml from the catalina home dir
        assertEquals(new File(tp.getCatalinaHome(), "conf/server.xml"), tp.getServerXml());
        
        // generate the base dir
        tm.ensureCatalinaBaseReady();
        
        // now we should get server.xml from the catalina base dir
        assertEquals(new File(tp.getCatalinaBase(), "conf/server.xml"), tp.getServerXml());
    }
    
    public static void main(java.lang.String[] args) {
        // run whole suite
        TestRunner.run(suite());
    }
    
}
