/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.nbbuild;

import java.io.*;
import java.util.*;
import java.util.jar.*;
import java.util.zip.*;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.*;
import org.apache.tools.ant.types.*;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.BuildException;

/**
 * This task updates update tracking files for localized or branded build
 * @author  Rudolf Balada
 */
public class FixUpdateTracking extends Task {

    private File nbSourceZipFile = null;
    private File nbTargetZipFile = null;
    private Vector utFiles = null;
    private Vector allFiles = null;
    private ZipFile nbZip = null;
    private File tmpDir = null;
    private File nbBuildDir = null;
    private File nbUpdateDir = null;
    private File moduleTracking = null;
    private String moduleTrackingRel = null;
    private String locales = null;
    private String brands = null;
    
    private Vector additionalrecords = null;
    
    public class Record {
        private String file;
        private String cnb;
        
        public Record() {
            this.file=null;
            this.cnb=null;
        }
        
        public void setFile (String fn) {
            this.file = fn;
        }
        
        public void setCodeNameBase (String cnb) {
            this.cnb = cnb;
        }
        
        public String getFile () {
            return file;
        }
        
        public String getCodeNameBase () {
            return cnb;
        }
    }
    
    /** Creates a new instance of FixUpdateTracking */
    public FixUpdateTracking() {
        utFiles = new Vector();
        allFiles = new Vector();
        additionalrecords = new Vector();
    }

    public Record createRecord () {
        Record nrc = new Record ();
        additionalrecords.add(nrc);
        log("FixUpdateTracking.createRecord() has been called", Project.MSG_DEBUG);
        return nrc;
    }

    public void setTmpDir (String tmpd) throws BuildException {
        File testNbzf1 = new File(this.getProject().getBaseDir(), tmpd);
        File testNbzf2 = new File(tmpd);
        if ((testNbzf1.exists()) && (testNbzf1.isDirectory())) {
            this.tmpDir = testNbzf1;
        } else if ((testNbzf2.exists()) && (testNbzf2.isDirectory())) {
            this.tmpDir = testNbzf2;
        } else {
            if (testNbzf1.mkdir()) {
                this.tmpDir = testNbzf1;
            } else {
                throw new BuildException("Unable to find temporary directory "+tmpd+" for unzipping NetBeans build.", this.getLocation());
            }
        }
    }
    
    /** 
     * Set the source zipfile with NetBeans build to be checked
     */
    public void setSourceZipFile (String nbzf) throws BuildException {
        File testNbzf1 = new File(this.getProject().getBaseDir(), nbzf);
        File testNbzf2 = new File(nbzf);
        if ((testNbzf1.exists()) && (testNbzf1.isFile())) {
            this.nbSourceZipFile = testNbzf1;
        } else if ((testNbzf2.exists()) && (testNbzf2.isFile())) {
            this.nbSourceZipFile = testNbzf2;
        } else {
            throw new BuildException("Unable to find sourcezipfile with NetBeans build referred by \""+nbzf+"\" string.", this.getLocation());
        }
    }
    
    /** 
     * Set the target zipfile with NetBeans build to be produced while checking
     */
    public void setTargetZipFile (String nbzf) throws BuildException {
        File absolute = new File(nbzf);
        File relative = new File(this.getProject().getBaseDir(), nbzf);
        if( absolute.isAbsolute() )
            nbTargetZipFile = absolute;
        else
            nbTargetZipFile = relative;
    }
    
    private void unpackZipFile(File nbz, File tmpd) {
        Expand unzip = (Expand) getProject().createTask("unzip"); //NOI18N
        tmpd.mkdirs();
        unzip.setSrc(nbz);
        unzip.setDest(tmpd);
        unzip.execute();
    }
    
    private String getModuleTrackingModuleName (String utf) throws BuildException {
        File utfFix = new File(utf);
        utf = UpdateTracking.TRACKING_DIRECTORY+'/'+utfFix.getName();
        ModuleTracking mt = new ModuleTracking( moduleTracking.getParent() );
        Map/*<String,ModuleTracking.Module>*/ htModules = mt.getModules();
        Iterator enMods = htModules.values().iterator();
        while (enMods.hasNext()) {
            ModuleTracking.Module mod = (ModuleTracking.Module) enMods.next();
            List modFiles = mod.getFiles();
            if (modFiles.contains(utf)) {
                // found update tracking file in list of files
                return mod.getName();
            }
        }
        throw new BuildException("Unable to locate update tracking file name "+utf + " in module tracking file "+moduleTracking.getAbsolutePath(), this.getLocation());
    }
    
    private String[] checkAdditionalRecords(String cnb, String[] ef) {
        if (this.additionalrecords.isEmpty()) return ef;
        Enumeration ear = this.additionalrecords.elements();
        Vector arv = new Vector();
        while (ear.hasMoreElements()) {
            Record ar = (Record) ear.nextElement();
            if (ar.getCodeNameBase().equals(cnb)) {
                log("    Found file "+ar.getFile()+" to be added to list of files owned by code-name-base "+cnb, Project.MSG_VERBOSE);
                arv.add(ar);
            }
        }
        
        if (arv.isEmpty()) return ef;
        
        // join the file lists (original from update tracking and additional records requested individually)
        String[] ni = new String[arv.size()+ef.length];
        for (int k=0; k < ef.length; k++) {
            ni[k] = ef[k];
            log("    Added " + ni[k] + " (original englich include) to list of includes", Project.MSG_DEBUG);
        }
        for (int k=0; k < arv.size(); k++) {
            ni[ef.length+k] = ((Record) arv.get(k)).getFile();
            log("    Added " + ni[ef.length+k] + " to list of includes", Project.MSG_DEBUG);
        }
        return ni;
    }
    
    private void updateOneUpdateTracking(String utFileName) throws BuildException {
        //File utFile = new File(nbDir)
        int sepPos = utFileName.lastIndexOf('/');
        
        String filename;
        if (sepPos < 0) {
            filename = utFileName;
        } else {
            filename = utFileName.substring(sepPos+1);
        }
        
        int extPos = filename.lastIndexOf(".xml"); //NOI18N
        String fname;
        if (extPos < 0) {
            fname = filename;
        } else {
            fname = filename.substring(0, extPos);
        }
        
        String clusterDir = (new File((new File(utFileName)).getParent())).getParent();
        log("  clusterDir == "+clusterDir, Project.MSG_DEBUG); // NOI18N
        String cnb = fname.replace('-', '.'); // NOI18N
        log("  code name base == " + cnb, Project.MSG_DEBUG); // NOI18N
        UpdateTracking ut = new UpdateTracking(this.nbBuildDir.getAbsolutePath()+File.separator+clusterDir);
        String[] englishFiles = ut.getListOfNBM(cnb);
        log("englishFiles array size before additional records is " + englishFiles.length, Project.MSG_DEBUG);
        englishFiles = checkAdditionalRecords(cnb,englishFiles);
        log("englishFiles array size after additional records is " + englishFiles.length, Project.MSG_DEBUG);
        
        this.getProject().addTaskDefinition("genlist", MakeListOfNBM.class); //NOI18N
        MakeListOfNBM mlon = (MakeListOfNBM) this.getProject().createTask("genlist"); //NOI18N
        FileSet modFs = mlon.createFileSet();
        modFs.setDir(new File(this.nbBuildDir,clusterDir));
        String dirName, fext, newinc, codename;
        String moduleJar = null;
        boolean skipLocaleDir = false;
        for (int k=0; k < englishFiles.length; k++) {
            log("Examining file " + englishFiles[k], Project.MSG_DEBUG);
            codename = null;
            if ((englishFiles[k].endsWith(".jar")) && (moduleJar == null)) { //NOI18N
                java.util.jar.Attributes attr;
                JarFile jar = null;
                File module = new File( nbBuildDir.getAbsolutePath()+File.separator+clusterDir+File.separator+englishFiles[k].replace('/', File.separatorChar) );
                try {
                    jar = new JarFile(module);
                    java.util.jar.Manifest modMan = jar.getManifest();
                    if (modMan != null) {
                        attr = modMan.getMainAttributes();
                        if (attr != null)
                            codename = attr.getValue("OpenIDE-Module"); //NOI18N
                    }
                } catch (IOException ex) {
                    throw new BuildException("Can't get manifest attributes for jar file "+module.getAbsolutePath(), ex, getLocation());
                } catch (Exception e) {
                    throw new BuildException("Error when working with jar file "+module.getAbsolutePath(), e, getLocation());
                } finally {
                    try {
                        if (jar != null) jar.close();
                    } catch( IOException ex1 ) {}
                }
            }
            modFs.setIncludes(englishFiles[k]);
            if (codename != null) 
                moduleJar = englishFiles[k];
            sepPos = englishFiles[k].lastIndexOf('/');
            if (sepPos < 0) {
                dirName = ""; //NOI18N
                filename = englishFiles[k];
            } else {
                dirName = englishFiles[k].substring(0,sepPos);
                filename = englishFiles[k].substring(sepPos+1);
            }
            extPos = filename.lastIndexOf('.'); //NOI18N
            if (extPos < 0) {
                fname = filename;
                fext = ""; //NOI18N
            } else {
                fname = filename.substring(0, extPos);
                fext = filename.substring(extPos);
            }
            newinc = dirName + "/locale/" + fname + "_*" + fext; //NOI18N
            log("  adding include mask \""+newinc+"\"", Project.MSG_DEBUG);
            modFs.setIncludes( newinc );

            // check if we need also localized and branded files
            java.util.StringTokenizer tokenizer = null;
            String lmnl = this.getProject().getProperty("locmakenbm.locales"); // NOI18N
            String[] lmnLocales = null;
            if ((!(lmnl == null)) && (!(lmnl.trim().equals("")))) { // NOI18N
                // property locmakenbm.locales is set, let's update the included fileset for locales
                // defined in that property

                tokenizer = new StringTokenizer( lmnl, ", ") ; //NOI18N
                int cntTok = tokenizer.countTokens();
                lmnLocales = new String[cntTok];
                for (int j=0; j < cntTok; j++) {
                  String s = tokenizer.nextToken();
                  lmnLocales[j] = s;
                  log("  lmnLocales["+j+"] == "+lmnLocales[j], Project.MSG_DEBUG); // NOI18N
                }
            }

            String lmnb = this.getProject().getProperty("locmakenbm.brands"); // NOI18N
            // handle brandings   
            String[] lmnBrands = null;
            if ((!(lmnb == null)) && (!(lmnb.trim().equals("")))) { // NOI18N
                tokenizer = new StringTokenizer( lmnb, ", ") ; //NOI18N
                int cntTok = tokenizer.countTokens();
                lmnBrands = new String[cntTok];
                for (int j=0; j < cntTok; j++) {
                    String s = tokenizer.nextToken();
                    lmnBrands[j] = s;
                    log("  lmnBrands["+j+"] == "+lmnBrands[j], Project.MSG_DEBUG); // NOI18N
                }
            }
        
            // handle localized and/or branded stuff
            if (englishFiles[k].lastIndexOf("/locale/") >= 0) {  // NOI18N
                skipLocaleDir=true;
                log("  "+englishFiles[k]+" is in /locale/ subdirectory", Project.MSG_DEBUG);
            } else {
                skipLocaleDir=false;
                log("  "+englishFiles[k]+" is not in /locale/ subdirectory", Project.MSG_DEBUG);
            }
            
            if (!(lmnLocales == null)) {
                for (int j=0; j < lmnLocales.length; j++) {
                    // localized files
                    if (skipLocaleDir) {
                    	newinc = dirName + '/' + fname + "_"+lmnLocales[j]+"*" + fext; //NOI18N
                    } else {
                        newinc = dirName + "/locale/" + fname + "_"+lmnLocales[j]+"*" + fext; //NOI18N
                    }
                    log("  adding include mask \""+newinc+"\"", Project.MSG_DEBUG);
                    modFs.setIncludes( newinc );
                    // localized & branded files
                    if (!(lmnBrands == null)) {
                    	for (int i=0; i < lmnBrands.length; i++) {
                    	    if (skipLocaleDir) {
                    	        newinc = dirName + '/' + fname + "_"+lmnBrands[i]+"_"+lmnLocales[j]+"*" + fext; //NOI18N
                            } else {
                    	        newinc = dirName + "/locale/" + fname + "_"+lmnBrands[i]+"_"+lmnLocales[j]+"*" + fext; //NOI18N
                    	    }
                            log("  adding include mask \""+newinc+"\"", Project.MSG_DEBUG);
                            modFs.setIncludes( newinc );
                    	}
                    }
                }
            }
            
        }
        if (moduleJar == null) 
            throw new BuildException ("Module with update tracking file \"" + utFileName + "\" does not have module jar file (jar file with manifest tag OpenIDE-Module)", this.getLocation());
        DirectoryScanner ds = modFs.getDirectoryScanner(this.getProject());
        ds.scan();
        String[] newIncludedFiles = ds.getIncludedFiles();
        if (englishFiles.length == newIncludedFiles.length) {
            // include lists does not differ in number of included files
            // a bit risky assumption, but it's possible to tell, that
            // the lists of included files are the same -> no need to update zipfile
            log("  No localized/branded data found",Project.MSG_VERBOSE);
            return;
        }
        mlon.setModule(moduleJar);
        mlon.setOutputfiledir(new File (this.nbBuildDir, clusterDir));
        log("before MakeListOfNBM",Project.MSG_DEBUG);
        this.getProject().setProperty("cluster.dir",(new File (clusterDir)).getName()); //NOI18N
        this.getProject().setProperty("module.name", getModuleTrackingModuleName(new String(UpdateTracking.TRACKING_DIRECTORY+File.separator+utFileName.replace('/',File.separatorChar)))); //NOI18N
        
        mlon.execute();
        
        log("after MakeListOfNBM",Project.MSG_DEBUG);
        
        // copy updated tracking files to nbUpdateDir
        Copy copytask = (Copy) this.getProject().createTask("copy"); //NOI18N
        copytask.init();
        copytask.setTodir(nbUpdateDir);
        FileSet fs = new FileSet ();
        fs.setDir(nbBuildDir);
        fs.setIncludes(clusterDir+'/'+UpdateTracking.TRACKING_DIRECTORY+(new File(utFileName)).getName().replace(File.separatorChar,'/'));
        fs.setIncludes(clusterDir+'/'+UpdateTracking.TRACKING_DIRECTORY+'/'+utFileName.replace(File.separatorChar,'/'));
        fs.setIncludes("**" + '/' + UpdateTracking.TRACKING_DIRECTORY + '/' + utFileName.replace(File.separatorChar,'/')); //NOI18N
        fs.setIncludes("**" + '/' + UpdateTracking.TRACKING_DIRECTORY + '/' + (new File(utFileName)).getName().replace(File.separatorChar,'/')); //NOI18N
        fs.setIncludes(moduleTrackingRel.replace(File.separatorChar,'/'));
        copytask.addFileset(fs);
        copytask.execute();
    }
    
    public void execute() throws BuildException {
    	log(" start", Project.MSG_VERBOSE);
        if (this.nbSourceZipFile == null)
            throw new BuildException("Set attribute sourcezipfile to location of NetBeans build zipfile", this.getLocation());
        if (this.tmpDir == null) {
            try {
                tmpDir = java.io.File.createTempFile("tmpdir_", "_dir", getProject().getBaseDir()); //NOI18N
                tmpDir.mkdirs(); tmpDir.mkdir();
            } catch (java.io.IOException ioe) {
                throw new BuildException ("I/O Error while establishing temporary directory",ioe, this.getLocation());
            }
        } 
        if (tmpDir.exists() && tmpDir.isFile()) 
            tmpDir.delete();
        tmpDir.mkdirs();
        if ((!tmpDir.exists()) || (!tmpDir.isDirectory()))
            throw new BuildException("Failed to create temporary directory "+tmpDir.getAbsolutePath(), this.getLocation());
        this.nbBuildDir = new File(this.tmpDir, "nbwork"); //NOI18N
        this.nbBuildDir.mkdirs(); this.nbBuildDir.mkdir();
        if ((!nbBuildDir.exists()) || (!nbBuildDir.isDirectory()))
            throw new BuildException("Failed to create temporary directory "+nbBuildDir.getAbsolutePath(), this.getLocation());
        this.nbUpdateDir = new File(this.tmpDir, "nbupdate"); //NOI18N
        this.nbUpdateDir.mkdirs(); this.nbUpdateDir.mkdir();
        if ((!nbUpdateDir.exists()) || (!nbUpdateDir.isDirectory()))
            throw new BuildException("Failed to create temporary directory "+nbUpdateDir.getAbsolutePath(), this.getLocation());
    	log(" directories ready", Project.MSG_DEBUG);
        try {
            nbZip = new ZipFile(this.nbSourceZipFile);
        } catch (java.util.zip.ZipException zex) {
            throw new BuildException ("Zip-error during attempt to work with zipfile "+this.nbSourceZipFile.getAbsolutePath(), zex, this.getLocation());
        } catch (java.io.IOException ioe) {
            throw new BuildException ("I/O Error while accessing zipfile "+this.nbSourceZipFile.getAbsolutePath(),ioe, this.getLocation());
        }
        Enumeration zipEntries = nbZip.entries();
        String utf;
        // get vector of update tracking files
    	log(" populating vector of update tracking files", Project.MSG_DEBUG);
    	String zeName;
        while (zipEntries.hasMoreElements()) {
            ZipEntry ze = (ZipEntry) zipEntries.nextElement();
            zeName = ze.getName().replace(File.separatorChar,'/');
            if ((zeName.lastIndexOf('/'+UpdateTracking.TRACKING_DIRECTORY+'/') > 0) && (!ze.isDirectory())) {
                log(" adding '"+zeName+"' to list of tracking files", Project.MSG_DEBUG);
                utFiles.add(new String(zeName));
            } else if (!ze.isDirectory()) {
                log(" adding '"+zeName+"' to list of all files", Project.MSG_DEBUG);
                allFiles.add(new String(zeName));
            }
        }
        
    	log(" unpacking source zipfile '"+nbSourceZipFile.getAbsolutePath()+"' to working directory '"+nbBuildDir.getAbsolutePath()+"'", Project.MSG_DEBUG);
        unpackZipFile(nbSourceZipFile,nbBuildDir);
    	log(" unpacking done", Project.MSG_DEBUG);

    	log(" locating module_tracking.xml file", Project.MSG_DEBUG);
        // locate module_tracking.xml file
        FileSet fs = new FileSet();
        fs.setDir(nbBuildDir);
        fs.setIncludes("**/module_tracking.xml"); //NOI18N
        DirectoryScanner ds = fs.getDirectoryScanner(this.getProject());
        ds.scan();
        String[] mtx = ds.getIncludedFiles();
        if (mtx.length != 1) 
            throw new BuildException ("Found "+mtx.length+" locations of module_tracking.xml file. Correct number is 1.", this.getLocation());
    	log("  +- found '"+mtx[0]+"' (relative to '"+nbBuildDir.getAbsolutePath()+"')", Project.MSG_DEBUG);
        moduleTracking = new File(nbBuildDir,mtx[0]);
        moduleTrackingRel = mtx[0];
        
        zipEntries = utFiles.elements();
        while (zipEntries.hasMoreElements()) {
            utf = ((String) zipEntries.nextElement()).replace(File.separatorChar, '/');
            log("Examining update tracking file " + utf);
            updateOneUpdateTracking(utf);
            log(" return from updateOneUpdateTracking("+utf+")", Project.MSG_DEBUG);
        }
        
        log(" calling UpdateZipFile()", Project.MSG_DEBUG);
        updateZipFile();
        log(" return from UpdateZipFile()", Project.MSG_DEBUG);
 
        // remove temporary data
        Delete deltask = (Delete) this.getProject().createTask("delete");
        deltask.setDir(tmpDir);
        deltask.execute();

        // remove source zipfile using Ant task
        deltask = (Delete) this.getProject().createTask("delete");
        deltask.setFailOnError(false);
        deltask.setFile(nbSourceZipFile);
        deltask.execute();
        
        // remove source zipfile using java File I/O
	log("Deleting file: "+nbSourceZipFile.getAbsolutePath(), Project.MSG_VERBOSE);
        nbSourceZipFile.deleteOnExit();
        // dispose nbSourceZipFile for garbage collection
        nbSourceZipFile = null;
    	log(" end", Project.MSG_VERBOSE);
    }
        
    public void updateZipFile() {
        // tracking files updated, push them back to zipfile
        // prepare zipfile with fresh tracking files
        Zip ziptask = (Zip) this.getProject().createTask("zip"); //NOI18N
        File tmpZipFile = new File (nbSourceZipFile.getParent(), nbSourceZipFile.getName()+".tmp"); //NOI18N
        log("Building zip file "+tmpZipFile.getAbsolutePath(), Project.MSG_VERBOSE);
        ziptask.setDestFile(tmpZipFile);
        ziptask.setBasedir(this.nbUpdateDir);
        ziptask.setUpdate(true);
        Zip.Duplicate df = new Zip.Duplicate();
        df.setValue("preserve"); //NOI18N
        ziptask.setDuplicate(df);
        ziptask.execute();
        ziptask.reset();
        ziptask = null;

        // enhance zipfile, which already contains fresh tracking files with
        // localized build content
        ziptask = (Zip) this.getProject().createTask("zip"); //NOI18N
        log("Updating zip file "+tmpZipFile.getAbsolutePath(), Project.MSG_VERBOSE);
        ziptask.setDestFile(tmpZipFile);
        ZipFileSet zfs = new ZipFileSet();
        zfs.setSrc(nbSourceZipFile);
        df = new Zip.Duplicate();
        df.setValue("preserve"); //NOI18N
        ziptask.addZipfileset(zfs);
        ziptask.setDuplicate(df);
        ziptask.setUpdate(true);
        ziptask.execute();
        ziptask.reset();
        ziptask=null;

        // move new zipfile over the old one
        Move movetask = (Move) this.getProject().createTask("move"); //NOI18N
        movetask.setFile(tmpZipFile);
        movetask.setTofile(nbTargetZipFile);
        movetask.setVerbose(true);
        movetask.setOverwrite(true);
        movetask.setPreserveLastModified(false);
        movetask.init();
        movetask.execute();

    }
}
