/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 *
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.search.project;

import org.netbeans.api.project.Project;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;
import org.openide.util.lookup.Lookups;

/**
 * Extracted from <code>OpenProjectCLITest.java</code>.
 * 
 * @author  Jaroslav Tulach
 * @author  Marian Petras
 */
public final class MockProject implements Project {

    final FileObject p;

    public MockProject(FileObject p) {
        this.p = p;
    }

    public FileObject getProjectDirectory() {
        return p;
    }

    public Lookup getLookup() {
        return p.getName().equals(ProjectsSearchActionTest.PRJ_WITH_SEARCH_INFO)
               ? Lookups.fixed(new Object[] {this, new ProjectsSearchActionTest.MockSearchInfo()})
               : Lookups.singleton(this);
    }

}
