/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 2003-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.openfile;

import java.io.File;

import org.openide.filesystems.FileObject;


/**
 * Interface for Open File implementations.
 *
 * @author  Marian Petras
 */
public interface OpenFileImpl {

    /**
     * Tries to find a <code>FileObject</code> for the specified
     * <code>File</code>. This method may force a user interaction.
     *
     * @param  f  existing file
     * @return  <code>FileObject</code> matching the <code>File</code>;
     *          or <code>null</code> if the matching <code>FileObject</code>
     *          was not determined (possibly due to a user's interaction)
     */
    FileObject findFileObject(File f);
    
    /**
     * Opens the specified <code>FileObject</code>.
     *
     * @param  fileObject  file to open
     * @param  line    line number to try to open to (starting at zero),
     *                 or <code>-1</code> to ignore
     * @param waiter if not null, tell the waiter when the file is closed
     * @return true on success, false on failure
     */
    boolean open(FileObject fileObject, int line);

}
