/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */


package org.netbeans.modules.pdf;


import java.awt.Image;
import java.beans.BeanInfo;
import java.beans.BeanDescriptor;
import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.beans.SimpleBeanInfo;

import org.openide.ErrorManager;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;


/** BeanInfo for PDF viewer settings.
 *
 * @author Jesse Glick
 */
public class SettingsBeanInfo extends SimpleBeanInfo {

    /** Gets property descriptors. */
    public PropertyDescriptor[] getPropertyDescriptors () {
        try {
            PropertyDescriptor pdfviewer = new PropertyDescriptor ("PDFViewer", Settings.class);
            pdfviewer.setDisplayName (NbBundle.getMessage (SettingsBeanInfo.class, "PROP_pdfviewer"));
            pdfviewer.setShortDescription (NbBundle.getMessage (SettingsBeanInfo.class, "HINT_pdfviewer"));
            return new PropertyDescriptor[] { pdfviewer };
        } catch (IntrospectionException ie) {
            ErrorManager.getDefault().notify(ie);
            
            return null;
        }
    }
    
    /** Gets the bean descriptor, hiding it.
     * Users probably do not want to change this setting
     * except once, which is why they are prompted to set it
     * if their current setting does not work. 
     *
     * <em>Note:</em> The above is changed now due to bug #12015, 
     * maybe that's not the right way since there 
     * is a need to have less options than now.
     *
     * @return descriptor
     */    
    public BeanDescriptor getBeanDescriptor () {
        BeanDescriptor desc = new BeanDescriptor (Settings.class);

        return desc;
    }

    /** Gets icon. */
    public Image getIcon (int type) {
        return Utilities.loadImage("org/netbeans/modules/pdf/PDFDataIcon.png"); // NOI18N
    }

}
