/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */


package org.netbeans.modules.search;


import org.openide.nodes.Node;
import org.openide.util.actions.NodeAction;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;


/**
 * Action which removes <code>FoundNode</code> from search result.
 *
 * @author  Peter Zavadsky
 * @see ResultModel.FoundNode
 */
public class RemoveFromSearchAction extends NodeAction {

    /** Generated serial version UID. */
    static final long serialVersionUID = -7200719415283638136L;
    
    
    /** Gets help context for the action. Implements superclass abstract method.
     * @return the help context for this action */
    public HelpCtx getHelpCtx() {
        return new HelpCtx(RemoveFromSearchAction.class);
    }
    
    /** Gets display name for action. Implements superclass abstract method.
     * @return the name of the action */
    public String getName() {
        return NbBundle.getMessage(
                RemoveFromSearchAction.class,
                "TEXT_LABEL_RemoveFromSearchActionName");               //NOI18N
    }
    
    /** Enables action based on activated nodes. Implements superclass abstract method.
     * @return <code>true</code> if all activated nodes are instance of <code>FoundNode</code>
     * or <code>false</code> otherwise */
    protected boolean enable(Node[] activatedNodes) {
        if (activatedNodes == null || activatedNodes.length == 0) {
            return false;
        }
        
        for (int i = 0; i < activatedNodes.length; i++) {
            if (!(activatedNodes[i] instanceof ResultTreeChildren.FoundNode)) {
                return false;
            }
        }
        
        return true;
    }
    
    /** Performs the action based on the currently activated nodes. Implements superclass abstract method.
     * @param activatedNodes current activated nodes, may be empty but not <code>null</code> */
    protected void performAction(Node[] activatedNodes) {
        if (activatedNodes == null || activatedNodes.length == 0) {
            return;
        }
        
        for (int i = 0; i < activatedNodes.length; i++) {
            if (activatedNodes[i] instanceof ResultTreeChildren.FoundNode) {
                ((ResultTreeChildren.FoundNode) activatedNodes[i])
                .removeFromSearch();
            }
        }
    }
    
}
