/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.search.types;

import java.util.List;
import org.openide.util.*;
import org.openidex.search.SearchHistory;
import org.openidex.search.SearchPattern;
//import org.netbeans.modules.search.res.*;


/**
 *
 * @author  Petr Kuzel
 */
public class FullTextCustomizer extends TextCustomizer {

    /** Creates new FullTextCustomizer. */
    public FullTextCustomizer() {
        HelpCtx.setHelpIDString(this, org.netbeans.modules.search.types.FullTextType.class.toString());
    }

    /** Reuse text customizer. */
    protected String getBorderLabel() {
        return NbBundle.getBundle(FullTextType.class).getString("TEXT_LABEL_TEXT_CONTAINS"); // NOI18N
    }
    
    /** 
     * Returns an unmodifiable List of SearchPatterns. 
     * The list is obtained from the global list of search patterns through
     * openidex/search api.
     *
     * @return unmodifiable List of SearchPatterns 
     */
    protected List/*SearchPattern*/ getSearchPatterns() {
        return SearchHistory.getDefault().getSearchPatterns();
    }
    
    /** Adds SearchPattern to SearchHistory. Delegates to the global history
     * of search patterns through the openidex/search api.
     *  @param pattern the SearchPattern to add
     */
    protected void addSearchPattern(SearchPattern pattern) {
        SearchHistory.getDefault().add(pattern);
    }
}
