/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.web.jsf;
import java.util.Enumeration;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.*;
import org.netbeans.modules.xml.api.model.DTDUtil;
import org.netbeans.api.xml.services.UserCatalog;

/** DD Grammar provided code completion for web.xml specified by XML schema.
 *
 * @author  Petr Pisl
 */
public class JSFGrammarQueryManager extends org.netbeans.modules.xml.api.model.GrammarQueryManager
{
    private static final String XMLNS_ATTR="xmlns"; //NOI18N
    private static final String JSF_TAG="faces-config"; //NOI18N
    
    public java.util.Enumeration enabled(org.netbeans.modules.xml.api.model.GrammarEnvironment ctx) {
        if (ctx.getFileObject() == null) return null;
        Enumeration en = ctx.getDocumentChildren();
        while (en.hasMoreElements()) {
            Node next = (Node) en.nextElement();
            if (next.getNodeType() == next.DOCUMENT_TYPE_NODE) {
                return null; // null for files specified by DTD
            } else if (next.getNodeType() == next.ELEMENT_NODE) {
                Element element = (Element) next;
                String tag = element.getTagName();
                if (JSF_TAG.equals(tag)) {  
                    String xmlns = element.getAttribute(XMLNS_ATTR);
                    if (xmlns!=null && JSFCatalog.JAVAEE_NS.equals(xmlns)){
                            return org.openide.util.Enumerations.singleton (next);
                    }
                }
            }
        }
        
        return null;
    }
    
    public java.beans.FeatureDescriptor getDescriptor() {
        return new java.beans.FeatureDescriptor();
    }
    
    /** Returns pseudo DTD for code completion
    */
    public org.netbeans.modules.xml.api.model.GrammarQuery getGrammar(org.netbeans.modules.xml.api.model.GrammarEnvironment ctx) {
        UserCatalog catalog = UserCatalog.getDefault();
        if (catalog != null) {
            EntityResolver resolver = catalog.getEntityResolver();
            if (resolver != null) {
                try {
                    String schema = JSFCatalog.JSF_ID_1_2;
                    InputSource inputSource = resolver.resolveEntity(schema, null);
                    if (inputSource!=null) {
                        return DTDUtil.parseDTD(true, inputSource);
                    }
                } catch(SAXException e) {
                    e.printStackTrace(System.out);
                } catch(java.io.IOException e) {
                    e.printStackTrace(System.out);
                }
            }
        }
        return null;
    }
    
}
