/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.web.jsf.config.model;

import java.io.OutputStream;
import java.io.Writer;
import java.io.IOException;
import org.netbeans.modules.schema2beans.Schema2BeansException;

/**
 *
 * @author Pavel Buzek
 */
public interface FacesConfig {
    static final String VERSION_1_0="1.0"; //NOI18N
    static final String VERSION_1_1="1.1"; //NOI18N
    static final String VERSION_1_2="1.2"; //NOI18N
    
    ManagedBean newManagedBean();
    NavigationRule newNavigationRule();
    Converter newConverter();
    
    NavigationRule[] getNavigationRule();
    int addNavigationRule(NavigationRule rule);
    
    ManagedBean[] getManagedBean();
    int addManagedBean(ManagedBean bean);
    int removeManagedBean(ManagedBean bean);
    
    Converter[] getConverter();
    int addConverter(Converter converter);
    int removeConverter(Converter converter);
    
    void write(OutputStream os) throws IOException;
    void write (Writer writer) throws Schema2BeansException, IOException;
}
