/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.web.core.syntax.completion;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.Method;
import org.netbeans.jmi.javamodel.Type;
import org.netbeans.jmi.javamodel.UnresolvedClass;
import org.netbeans.modules.javacore.api.JavaModel;

/**
 *
 * @author petr
 */
public class JMIUtil {
    
    /** Creates a new instance of JMIUtil */
    public JMIUtil() {
    }
    
    /** Returns JavaClass object for the FQPN
     */
    public static JavaClass findClass(String className, ClassPath classPath) {
        JavaClass result = (JavaClass) resolveType(className, classPath);
        return result instanceof UnresolvedClass ? null : result;
    }
    
    public static Type resolveType(String typeName, ClassPath classPath) {
        beginJmiTransaction();
        try {
            JavaModel.setClassPath(classPath);
            return resolveType(typeName);
        } finally {
            endJmiTransaction();
        }
    }
    
    
    public static Method[] getMethods(JavaClass jc) {
        List/*<Method>*/ result = new LinkedList();
        if (jc != null) {
            List features = jc.getFeatures();
            for (Iterator it = features.iterator(); it.hasNext();) {
                Object o =  it.next();
                if (o instanceof Method) {
                    result.add(o);
                }
            }
        }
        return (Method[]) result.toArray(new Method[result.size()]);
    }
    
    public static void beginJmiTransaction(boolean writeAccess) {
        JavaModel.getJavaRepository().beginTrans(writeAccess);
    }

    public static void beginJmiTransaction() {
        beginJmiTransaction(false);
    }

    public static void endJmiTransaction(boolean rollback) {
        JavaModel.getJavaRepository().endTrans(rollback);
    }

    public static void endJmiTransaction() {
        endJmiTransaction(false);
    }
    
    public static Type resolveType(String typeName) {
        Type type = JavaModel.getDefaultExtent().getType().resolve(typeName);
        if (type instanceof UnresolvedClass) {
            Type basicType = JavaModel.getDefaultExtent().getType().resolve("java.lang." + typeName);  // NOI18N;
            if (!(basicType instanceof UnresolvedClass)) {
                return basicType;
            }
        }
        return type;
    }
}
