/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.web.core.syntax.completion;

import java.awt.Component;
import javax.swing.ListCellRenderer;
import javax.swing.JList;

import org.netbeans.editor.ext.Completion;
import org.netbeans.editor.ext.CompletionQuery;
import org.netbeans.editor.ext.CompletionView;
import org.netbeans.editor.ext.ExtEditorUI;
import org.netbeans.editor.ext.JavaDocPane;
import org.netbeans.editor.ext.ListCompletionView;

import org.netbeans.modules.editor.java.NbJCCellRenderer;
import org.netbeans.modules.editor.java.NbScrollJavaDocPane;
import org.netbeans.modules.web.core.syntax.*;


/**
* JSP Completion query specifications
*
* @author Petr Jiricka, Petr Nejedly
*/

public class JspCompletion extends Completion {
    
    protected Completion contentCompletion;

    private JavaDocPane javaDocPane;  

    public JspCompletion(ExtEditorUI extEditorUI) {
        super(extEditorUI);
    }

    public JspCompletion(ExtEditorUI extEditorUI, 
        Completion contentCompletion) {
        super(extEditorUI);
        this.contentCompletion = contentCompletion;
    }

    protected CompletionView createView() {
        return new ListCompletionView(new DelegatingCellRenderer());
    }

    protected CompletionQuery createQuery() {
        CompletionQuery contentQuery = (contentCompletion == null) ? null : contentCompletion.getQuery();
        return new JspCompletionQuery(contentQuery);
    }

    public JavaDocPane getJavaDocPane(){
        if (javaDocPane == null){
            javaDocPane = new NbScrollJavaDocPane(extEditorUI);
        }
        return javaDocPane;
    }
   

/* -------------------------------------------------------------------------- */

   public class DelegatingCellRenderer implements ListCellRenderer {
        ListCellRenderer defaultRenderer = new NbJCCellRenderer();//new DefaultListCellRenderer();
        
        public Component getListCellRendererComponent(JList list, Object value,
                int index, boolean isSelected, boolean cellHasFocus) {
            if( value instanceof CompletionQuery.ResultItem) {
                return ((CompletionQuery.ResultItem)value).getPaintComponent( list, isSelected, cellHasFocus );
            } else {
                return defaultRenderer.getListCellRendererComponent( list, value, index, isSelected, cellHasFocus);
            }
            
        }
    }

}
