/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.test.web.core.syntax;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import javax.swing.SwingUtilities;
import org.netbeans.test.web.FileObjectFilter;
import org.netbeans.test.web.RecurrentSuiteFactory;
import org.openide.filesystems.FileObject;
import junit.framework.Test;
import org.netbeans.api.db.explorer.ConnectionManager;
import org.netbeans.api.db.explorer.DatabaseConnection;

/** 
 *
 * @author ms113234
 */
public class J2EECompletionTest extends CompletionTest{
    
    /** Creates a new instance of CompletionTesJ2EE */
    public J2EECompletionTest(String name, FileObject testFileObj) {
        super(name, testFileObj);
        debug = false;
    }
    
    public static Test suite() {
        // find folder with test projects and define file objects filter
        File datadir = new J2EECompletionTest(null, null).getDataDir();
        File projectsDir = new File(datadir, "J2EECompletionTestProjects");
        FileObjectFilter filter = new FileObjectFilter() {
            public boolean accept(FileObject fo) {
                String ext = fo.getExt();
                String name = fo.getName();
                return (name.startsWith("test") || name.startsWith("Test"))
                && (xmlExts.contains(ext) || jspExts.contains(ext) || ext.equals("java"));
            }
        };
         
        //DB Connecting - this must start with clear userdir, because it expect sample connection as the first one
        int time=0;
        while ((ConnectionManager.getDefault().getConnections().length==0)&&(time<=12)){
         time++;
         try{
             Thread.currentThread().sleep(5000);
         }catch(Exception e){
             e.printStackTrace(System.err);
         }
        }
        if (time>12) {
            System.err.println("IMPOSSIBLE TO CONNECT THE DATABASE");
        } else {
            final DatabaseConnection dbconn = ConnectionManager.getDefault().getConnections()[0];
            try {
                SwingUtilities.invokeAndWait(new Runnable() {
                    public void run() {
                        ConnectionManager.getDefault().showConnectionDialog(dbconn);
                    }
                });
            } catch (InterruptedException e) {
            } catch (InvocationTargetException e) {
            }
        }
        
        return RecurrentSuiteFactory.createSuite(J2EECompletionTest.class,
                projectsDir, filter);
    }
}
