/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.test.web.core.syntax;

import java.io.File;
import java.util.Arrays;
import java.util.List;
import junit.framework.Test;
import org.netbeans.junit.AssertionFailedErrorException;
import org.netbeans.junit.NbTestCase;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.TokenID;
import org.netbeans.editor.TokenItem;
import org.netbeans.editor.ext.ExtSyntaxSupport;
import org.netbeans.test.web.FileObjectFilter;
import org.netbeans.test.web.RecurrentSuiteFactory;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;

/**
 *
 * @author ms113234
 */
public class JspColoringTest extends NbTestCase {
    private FileObject testFileObj;
    
    /** Need to be defined because of JUnit */
    public JspColoringTest(String name, FileObject testFileObj) {
        super(name);
        this.testFileObj = testFileObj;
    }
    
    public void setUp() {
        System.out.println("########  "+getName()+"  #######");
    }
    
    public void tearDown() {
        compareReferenceFiles();
    }
    
    public static Test suite() {
        // find folder with test projects and define file objects filter
        File datadir = new JspColoringTest(null, null).getDataDir();
        File projectsDir = new File(datadir, "JspColoringTestProjects");
        FileObjectFilter filter = new FileObjectFilter() {
            public boolean accept(FileObject fo) {
                String strs[] = new String[] {"jsp", "jspx", "jspf", "html", "tag", "tagx"};
                List exts = Arrays.asList(strs);
                return fo.getName().startsWith("test") && exts.contains(fo.getExt());
            }
        };
        return RecurrentSuiteFactory.createSuite(JspColoringTest.class, projectsDir, filter);
    }
    
    public void runTest() throws Exception {
        dumpTokens(testFileObj);
    }
    
    private void dumpTokens(FileObject fileObj) {
        try {
            DataObject dataObj = DataObject.find(fileObj);
            EditorCookie ed = (EditorCookie) dataObj.getCookie(EditorCookie.class);
            BaseDocument doc = (BaseDocument) ed.openDocument();
            ExtSyntaxSupport ess = (ExtSyntaxSupport) doc.getSyntaxSupport();
            TokenItem token = ess.getTokenChain(0, doc.getLength());
            
            while (token != null) {
                TokenID tokenID = token.getTokenID();
                ref(tokenID.getName()+ ": " + token.getImage());
                token = token.getNext();
            }
        } catch (Exception ex) {
            throw new AssertionFailedErrorException(ex);
        }
    }
    
    /** Use for execution inside IDE */
    public static void main(java.lang.String[] args) {
        // run whole suite
        junit.textui.TestRunner.run(suite());
    }
}
