/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.test.web.core.syntax;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.netbeans.editor.BaseDocument;
import org.netbeans.junit.NbTestCase;
import org.netbeans.modules.web.core.syntax.JSPKit;
import org.netbeans.modules.web.core.syntax.JspFormatter;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.Repository;
import org.openide.util.Lookup;

/**
 *
 * @author Tomasz Slota
 */
public class JSPFormatterTest extends NbTestCase {
    
    /** Creates a new instance of JSPFormatterTest */
    public JSPFormatterTest(String testName) {
        super(testName);
    }
    
    public static Test suite() {
        TestSuite suite = new TestSuite(JSPFormatterTest.class);
        
        return suite;
    }
    
    // public tests
    
    public void testReformatSample1() throws Exception{
        testReformat("TestPage1.jsp");
    }
    
    public void testReformatSample2() throws Exception{
        testReformat("TestPage2.jsp");
    }
    
    public void testIssue82272() throws Exception{
        testReformat("issue82272.jsp");
    }
    
    // end of public tests
    
    private void testReformat(String testFileName) throws Exception {
        System.out.println("testReformat(" + testFileName + ")");
        JspFormatter formatter = new JspFormatter(JSPKit.class);
        BaseDocument doc = createEmptyBaseDocument();
        
        
        String txtRawJSP = readFileContentToString(new File(new File(
                getTestFilesDir(), "testReformat"), testFileName));
        
        doc.insertString(0, txtRawJSP, null);
        formatter.reformat(doc, 0, doc.getLength(), false);
        getRef().print(doc.getText(0, doc.getLength()));
        
        compareReferenceFiles();
    }
 
    private String readFileContentToString(File file) throws IOException {
        StringBuffer buff = new StringBuffer();
        BufferedReader rdr = new BufferedReader(new FileReader(file));
        
        String line;
        
        try{
            while ((line = rdr.readLine()) != null){
                buff.append(line + "\n");
            }
        } finally{
            rdr.close();
        }
        
        return buff.toString();
    }
    
    private File getTestFilesDir(){
        return new File(new File(getDataDir(), "input"), "JSPFormatterTest");
    }
    
    private BaseDocument createEmptyBaseDocument(){
        return new BaseDocument(JSPKit.class, false);
    }
}
