/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.test.web.folding;

import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.Vector;
import javax.swing.JEditorPane;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.text.BadLocationException;
import org.netbeans.api.editor.fold.FoldHierarchy;
import org.netbeans.api.editor.fold.FoldHierarchyEvent;
import org.netbeans.api.editor.fold.FoldHierarchyListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.TokenContext;
import org.netbeans.editor.TokenContextPath;
import org.netbeans.editor.TokenID;
import org.netbeans.editor.TokenItem;
import org.netbeans.editor.ext.html.HTMLSyntax;
import org.netbeans.editor.ext.java.JavaSyntax;
import org.netbeans.junit.NbTestCase;
import org.netbeans.modules.web.core.syntax.folding.JspFoldUtils;

import org.openide.ErrorManager;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;

/** Basic jsp folding tests.
 *
 * @author  mf100882
 */
public class JspFoldingTest extends NbTestCase implements FoldHierarchyListener, ActionListener {
    
    private FileObject webDir = null;
    private Timer timer = null;
    private Object lock = new Object();
    
    public JspFoldingTest() {
        super("jspfoldingtest");
    }
    
    public void setUp() throws IOException {
        File datadir = getDataDir();
        File projectDir = new File(datadir, "TestWebApplication");
        FileObject projectFO = FileUtil.toFileObject(projectDir);
        webDir = projectFO.getFileObject("web");
    }
    
    public void tearDown() {
        compareReferenceFiles();
    }
    
    //--------- test methods -----------
    
    public void testHTMLFolds() throws IOException, BadLocationException, InterruptedException {
        FileObject testFO = webDir.getFileObject("testHTMLtags","jsp");
        dumpFoldHierarchyFor(testFO);
    }
    
    public void testDirectiveFolds() throws IOException, BadLocationException, InterruptedException {
        FileObject testFO = webDir.getFileObject("testDirectives","jsp");
        dumpFoldHierarchyFor(testFO);
    }
    
    public void testScriptlets() throws IOException, BadLocationException, InterruptedException {
        FileObject testFO = webDir.getFileObject("testScriptlets","jsp");
        dumpFoldHierarchyFor(testFO);
    }
    
    public void testComments() throws IOException, BadLocationException, InterruptedException {
        FileObject testFO = webDir.getFileObject("testComments","jsp");
        dumpFoldHierarchyFor(testFO);
    }
    
    public void testMix() throws IOException, BadLocationException, InterruptedException {
        FileObject testFO = webDir.getFileObject("testMix","jsp");
        dumpFoldHierarchyFor(testFO);
    }
    
    //<<< --------- test methods ----------
    
    private void dumpFoldHierarchyFor(FileObject fo) throws IOException, BadLocationException, InterruptedException {
        try {
            //ErrorManager.getDefault().log(ErrorManager.EXCEPTION, "executing " + fo.getNameExt());
            DataObject dobj = DataObject.find(fo);
            
            //open the file in editor
            EditorCookie ec = (EditorCookie)dobj.getCookie(EditorCookie.class);
            EditorCookie.Observable eco = (EditorCookie.Observable)dobj.getCookie(EditorCookie.Observable.class);
            
            //wait for editor to be opened
            final PropertyChangeListener pcl = new PropertyChangeListener() {
                public void propertyChange(PropertyChangeEvent evt) {
                    if (evt.getPropertyName().equals(EditorCookie.Observable.PROP_OPENED_PANES)) {
                        synchronized(lock) {
                            lock.notifyAll();
                            //ErrorManager.getDefault().log(ErrorManager.EXCEPTION, "pane opened");
                        }
                    }
                }
            };
            
            eco.addPropertyChangeListener(pcl);
            
            //open the document
            BaseDocument doc = (BaseDocument)ec.openDocument();
            ec.open();
            
            //and wait for the editor pane to show up
            synchronized(lock) {
                JEditorPane[] panes = getOpenedPanes(ec);
                if(panes == null || panes.length == 0) lock.wait();
            }
            
            eco.removePropertyChangeListener(pcl);
            
            
            //get fold hierarchy for the editor component
            JEditorPane editor = getOpenedPanes(ec)[0];
            FoldHierarchy fh = FoldHierarchy.get(editor);
            
            //I have to wait some time for the foldhierarchy to be built by the foldmanager
            //so I am listening in hirarchy changes for some time.
            fh.addFoldHierarchyListener(this);
            
            //start timeout timer
            timer = new Timer(10000, this);
            timer.setRepeats(false);
            timer.start();
            
            //ErrorManager.getDefault().log(ErrorManager.EXCEPTION, "waiting for hierarchy");
            //wait for the hirerchy to be created
            synchronized(lock) {
                lock.wait();
            }
            //ErrorManager.getDefault().log(ErrorManager.EXCEPTION, "unlocked");
            fh.removeFoldHierarchyListener(this);
            
            //put hierarchy structure into ref stream
            JspFoldUtils.printFolds(fh, getRef());
            
            //ErrorManager.getDefault().log(ErrorManager.EXCEPTION, "closing");
            ec.close();
            //ErrorManager.getDefault().log(ErrorManager.EXCEPTION, "closed");
        }catch(Throwable t) {
            ErrorManager.getDefault().notify(t);
        }
    }
    
    public JEditorPane[] getOpenedPanes(final EditorCookie ec) {
        if(SwingUtilities.isEventDispatchThread()) return ec.getOpenedPanes();
        else {
            final Vector v = new Vector();
            try {
                SwingUtilities.invokeAndWait(new Runnable() {
                    public void run() {
                        v.add(ec.getOpenedPanes());
                    }
                });
            }catch(InvocationTargetException ite) {
                //do nothing
            }catch(InterruptedException ie) {
                //do nothing
            }
            if(v.size() == 1) return (JEditorPane[])v.get(0);
            else return null;
        }
    }
    
    public void foldHierarchyChanged(FoldHierarchyEvent evt) {
        //restart timer - postpone the timout - for 1 second only
        timer.setInitialDelay(1000);
        timer.restart();
        //ErrorManager.getDefault().log(ErrorManager.EXCEPTION, "hierarchy changed");
    }
    
    public void actionPerformed(ActionEvent evt) {
        //timeout elapsed
        synchronized(lock) {
            lock.notifyAll();
        }
        //ErrorManager.getDefault().log(ErrorManager.EXCEPTION, "timer action performed.");
    }
    
}
