/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.web.project.ui;

/**
 *
 * @author  mkuchtiak
 */
public class ServletUriPanel extends javax.swing.JPanel {

    /** Creates new form ServletUriPanel */
    public ServletUriPanel(String[] urlPatterns, String selectedItem, boolean fromRunMenu ) {
        initComponents();
        if (fromRunMenu) {
            jLabel2.setText(org.openide.util.NbBundle.getMessage(ServletUriPanel.class, "DESC_setServletURI"));
        }
        if (selectedItem!=null) {
            jComboBox1.addItem(selectedItem);
        }
        for (int i=0;i<urlPatterns.length;i++) {
            if (!urlPatterns[i].equals(selectedItem))
                jComboBox1.addItem(urlPatterns[i]);
        }
        if (selectedItem!=null) {
            ((javax.swing.JTextField)jComboBox1.getEditor().getEditorComponent()).setText(selectedItem);
        }
    }
    
    public String getServletUri() {
        String servletUri = (String)jComboBox1.getSelectedItem();
        
        if (servletUri != null && servletUri.length() > 0 && servletUri.charAt(0) != '/')
            servletUri = "/" + servletUri;
        
        return servletUri;
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        jComboBox1 = new javax.swing.JComboBox();
        jLabel1 = new javax.swing.JLabel();
        jLabel2 = new javax.swing.JLabel();

        setLayout(new java.awt.GridBagLayout());

        getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(ServletUriPanel.class, "A11Y_desc_setServletURI"));
        jComboBox1.setEditable(true);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(6, 12, 0, 12);
        add(jComboBox1, gridBagConstraints);

        jLabel1.setDisplayedMnemonic(org.openide.util.NbBundle.getMessage(ServletUriPanel.class, "LBL_setServletURI_mnem").charAt(0));
        jLabel1.setLabelFor(jComboBox1);
        jLabel1.setText(org.openide.util.NbBundle.getMessage(ServletUriPanel.class, "LBL_setServletURI"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(12, 12, 0, 12);
        add(jLabel1, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(12, 12, 12, 12);
        add(jLabel2, gridBagConstraints);

    }// </editor-fold>//GEN-END:initComponents
    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JComboBox jComboBox1;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel2;
    // End of variables declaration//GEN-END:variables
    
}
