/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package gui;

import gui.menu.WebProjectsViewPopupMenu;
import org.netbeans.jellytools.ProjectsTabOperator;
import org.netbeans.jellytools.RuntimeTabOperator;
import org.netbeans.jellytools.nodes.Node;
import org.netbeans.junit.NbTestSuite;

/**
 * Measure UI-RESPONSIVENES and WINDOW_OPENING.
 *
 * @author  mmirilovic@netbeans.org
 */
public class MeasureNodePopup  {
    
    public static void main(java.lang.String[] args) {
        junit.textui.TestRunner.run(suite());
    }
    
    public static NbTestSuite suite() {

        new Node(RuntimeTabOperator.invoke().getRootNode(),"Servers").callPopup();
        ProjectsTabOperator.invoke();
        
        NbTestSuite suite = new NbTestSuite(); 
        suite.addTest(new WebProjectsViewPopupMenu("testProjectNodePopupMenuProjects", "Project node popup in Projects View"));
        //suite.addTest(new WebProjectsViewPopupMenu("testProjectNodePopupMenuProjects", "Project node popup in Projects View II"));
        suite.addTest(new WebProjectsViewPopupMenu("testSourcePackagesPopupMenuProjects", "Source Packages node popup in Projects View"));
        suite.addTest(new WebProjectsViewPopupMenu("testPackagePopupMenuProjects", "Package node popup in Projects View"));
        suite.addTest(new WebProjectsViewPopupMenu("testServletPopupMenuProjects", "Servlet node popup in Projects View"));
        suite.addTest(new WebProjectsViewPopupMenu("testWebPagesPopupMenuProjects", "Web Pages node popup in Projects View"));
        suite.addTest(new WebProjectsViewPopupMenu("testJspFilePopupMenuProjects", "JSP File node popup in Projects View"));
        suite.addTest(new WebProjectsViewPopupMenu("testWebInfPopupMenuProjects", "WEB-INF node popup in Projects View"));
        suite.addTest(new WebProjectsViewPopupMenu("testMetaInfPopupMenuProjects", "META-INF node popup in Projects View"));
        suite.addTest(new WebProjectsViewPopupMenu("testWebXmlFilePopupMenuProjects", "Web.xml node popup in Projects View"));
        suite.addTest(new WebProjectsViewPopupMenu("testContextXmlFilePopupMenuProjects", "Context.xml node popup in Projects View"));
        suite.addTest(new WebProjectsViewPopupMenu("testHtmlFilePopupMenuProjects", "HTML node popup in Projects View"));
        suite.addTest(new WebProjectsViewPopupMenu("testTagFilePopupMenuProjects", "Tag file node popup in Projects View"));
        suite.addTest(new WebProjectsViewPopupMenu("testTldPopupMenuProjects", "TLD node popup in Projects View"));
        
        
        return suite;
    }
    
}
