/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.test.web;

import java.io.File;
import java.io.IOException;
import java.net.ConnectException;
import java.net.URL;
import java.net.URLConnection;
import javax.enterprise.deploy.spi.exceptions.DeploymentManagerCreationException;
import javax.swing.JComboBox;
import junit.framework.AssertionFailedError;
import org.netbeans.jellytools.Bundle;
import org.netbeans.jellytools.EditorOperator;
import org.netbeans.jellytools.EditorWindowOperator;
import org.netbeans.jellytools.JellyTestCase;
import org.netbeans.jellytools.MainWindowOperator;
import org.netbeans.jellytools.NbDialogOperator;
import org.netbeans.jellytools.NewFileWizardOperator;
import org.netbeans.jellytools.actions.BuildProjectAction;
import org.netbeans.jellytools.actions.EditAction;
import org.netbeans.jellytools.modules.web.NewJspFileNameStepOperator;
import org.netbeans.jellytools.nodes.SourcePackagesNode;
import org.netbeans.jemmy.EventTool;
import org.netbeans.jemmy.JemmyException;
import org.netbeans.jemmy.JemmyProperties;
import org.netbeans.jemmy.TimeoutExpiredException;
import org.netbeans.jellytools.WizardOperator;
import org.netbeans.jellytools.nodes.Node;
import org.netbeans.jellytools.actions.ActionNoBlock;
import org.netbeans.jellytools.actions.Action;
import org.netbeans.jellytools.NewProjectWizardOperator;
import org.netbeans.jellytools.NewWebProjectNameLocationStepOperator;
import org.netbeans.jellytools.OptionsOperator;
import org.netbeans.jellytools.OutputTabOperator;
import org.netbeans.jellytools.ProjectsTabOperator;
import org.netbeans.jellytools.modules.web.nodes.WebPagesNode;
import org.netbeans.jemmy.operators.JButtonOperator;
import org.netbeans.jemmy.operators.JCheckBoxOperator;
import org.netbeans.jemmy.operators.JComboBoxOperator;
import org.netbeans.jemmy.operators.JLabelOperator;
import org.netbeans.jemmy.operators.JListOperator;
import org.netbeans.jemmy.operators.JRadioButtonOperator;
import org.netbeans.jemmy.operators.JTextFieldOperator;
import org.netbeans.jemmy.operators.JTreeOperator;
import org.netbeans.jemmy.operators.Operator;
import org.netbeans.junit.NbTestSuite;
import org.netbeans.junit.ide.ProjectSupport;
import org.netbeans.modules.tomcat5.TomcatFactory55;
import org.netbeans.modules.tomcat5.TomcatManager;
import org.netbeans.modules.tomcat5.util.TomcatProperties;

/** 
 */
public class WebProjectValidation extends JellyTestCase {
    protected static ProjectHelper phelper = new ProjectHelper() {
        public Node getSourceNode() {
            return new SourcePackagesNode(PROJECT_NAME);
        }
    };
    // location of sample project (parent of PROJECT_FOLDER)
    protected static final String PROJECT_LOCATION =
            System.getProperty("xtest.data");
    // name of sample project
    protected static String PROJECT_NAME = "SampleProject"; // NOI18N
    // foloder of sample project
    protected static String PROJECT_FOLDER =
            PROJECT_LOCATION+File.separator+PROJECT_NAME;
    protected TestURLDisplayer urlDisplayer;
    private static final String BUILD_SUCCESSFUL = "BUILD SUCCESSFUL";
    
    
    /** Need to be defined because of JUnit */
    public WebProjectValidation(String name) { 
        super(name);
    }
    
    public static NbTestSuite suite() {
        NbTestSuite suite = new NbTestSuite();
        suite.addTest(new WebProjectValidation("testPreconditions"));
        suite.addTest(new WebProjectValidation("testNewWebProject"));
        suite.addTest(new WebProjectValidation("testNewJSP"));
        suite.addTest(new WebProjectValidation("testNewJSP2"));
        suite.addTest(new WebProjectValidation("testNewServlet"));
        suite.addTest(new WebProjectValidation("testNewServlet2"));
        suite.addTest(new WebProjectValidation("testBuildProject"));
        suite.addTest(new WebProjectValidation("testCompileAllJSP"));
        suite.addTest(new WebProjectValidation("testCompileJSP"));
        suite.addTest(new WebProjectValidation("testCleanProject"));
        suite.addTest(new WebProjectValidation("testRunProject"));
        suite.addTest(new WebProjectValidation("testRunJSP"));
        suite.addTest(new WebProjectValidation("testRunServlet"));
        suite.addTest(new WebProjectValidation("testCreateTLD"));
        suite.addTest(new WebProjectValidation("testCreateTagHandler"));
        suite.addTest(new WebProjectValidation("testRunTag"));
        suite.addTest(new WebProjectValidation("testNewHTML"));
        suite.addTest(new WebProjectValidation("testRunHTML"));
        suite.addTest(new WebProjectValidation("testNewSegment"));
        suite.addTest(new WebProjectValidation("testNewDocument"));  
        suite.addTest(new WebProjectValidation("testStopTomcat"));
        suite.addTest(new WebProjectValidation("testStartTomcat"));
        suite.addTest(new WebProjectValidation("testBrowserSettings"));
        suite.addTest(new WebProjectValidation("testFinish"));
        return suite;
    }
    
    /** Use for execution inside IDE */
    public static void main(java.lang.String[] args) {
        // run whole suite
        junit.textui.TestRunner.run(suite());
        // run only selected test case
        //junit.textui.TestRunner.run(new MyModuleValidation("testT2"));
    }
    
    public void setUp() throws DeploymentManagerCreationException { 
        System.out.println("########  "+getName()+"  #######");
        initDisplayer();
        JemmyProperties.setCurrentTimeout(
                "ComponentOperator.WaitComponentTimeout", 180000);
        JemmyProperties.setCurrentTimeout(
                "FrameWaiter.WaitFrameTimeout", 180000);
        JemmyProperties.setCurrentTimeout(
                "DialogWaiter.WaitDialogTimeout",180000);
        // extend Tomcat running check timeout
        TomcatManager tm = getTomcatManager();
        tm.getInstanceProperties().setProperty(
                TomcatProperties.PROP_RUNNING_CHECK_TIMEOUT, "8000");
    }
    
    public void tearDown() throws IOException {
        logAndCloseOutputs();
    }
    
    /** checks if the Tomcat ports are not used */
    public void testPreconditions() throws Exception {
        URL url = new URL("http://localhost:8084");
        URLConnection connection = url.openConnection();
        try {
            connection.connect();
            fail("Connection to http://localhost:8084 established, but tomcat should not be running.");
        } catch (ConnectException e) {  }
        url = new URL("http://localhost:8025");
        connection = url.openConnection();
        try {
            connection.connect();
            fail("Connection to http://localhost:8025 established, but tomcat should not be running.");
        } catch (ConnectException e) {  }
    }
    
    /** Test creation of web project. 
     * - open New Project wizard from main menu (File|New Project)
     * - select Web|Web Application
     * - in the next panel type project name and project location
     * - finish the wizard
     * - wait until scanning of java files is finished
     * - check index.jsp is opened
     */
    public void testNewWebProject() throws IOException {
        NewProjectWizardOperator projectWizard = NewProjectWizardOperator.invoke();
        String category = Bundle.getStringTrimmed(
                "org.netbeans.modules.web.core.Bundle",
                "Templates/JSP_Servlet");
        projectWizard.selectCategory(category);
        projectWizard.next();
        NewWebProjectNameLocationStepOperator nameStep =
                new NewWebProjectNameLocationStepOperator();
        nameStep.txtProjectName().typeText(PROJECT_NAME);
        nameStep.txtProjectLocation().setText("");
        nameStep.txtProjectLocation().typeText(PROJECT_LOCATION);
        nameStep.finish();
        // wait for project creation
        sleep(10000);
        ProjectSupport.waitScanFinished();
        new ProjectsTabOperator().getProjectRootNode(PROJECT_NAME);
        new EditorWindowOperator().getEditor("index.jsp");//NOI18N
        ProjectSupport.waitScanFinished();
        // XXX HACK
        WebPagesNode webPages = new WebPagesNode(PROJECT_NAME);
        new Node(webPages,"index.jsp");//NOI18N
        new Node(webPages,"WEB-INF|web.xml");//NOI18N
        new Node(webPages,"META-INF|context.xml");//NOI18N
        ref(Util.dumpProjectView(PROJECT_NAME));
        //compareReferenceFiles();
    }
    
    /** Test new JSP wizard. 
     * - open New File wizard from main menu (File|New File)
     * - select sample project as target
     * - select Web|JSP file type
     * - in the next panel type name
     * - finish the wizard
     * - check file is open in editor and close all opened documents
     */
    public void testNewJSP() throws IOException {
        // XXX workaround due to issue #46073
        new ProjectsTabOperator().getProjectRootNode(PROJECT_NAME).select();
        NewJspFileNameStepOperator nameStep = NewJspFileNameStepOperator.invoke();
        nameStep.setJSPFileName("page1");
        nameStep.finish();
        // check class is opened in Editor and then close it
        new EditorOperator("page1.jsp").close();
        ref(Util.dumpProjectView(PROJECT_NAME));
        //compareReferenceFiles();
    }
    
    /** Test new JSP wizard. 
     * - open New File wizard from context menu on Web Pages (New|File)
     * - select JSP file type
     * - in the next panel type name in
     * - finish the wizard
     * - check file is open in editor and close all opened documents
     */
    public void testNewJSP2() throws IOException {
        Node webPages = new WebPagesNode(PROJECT_NAME);
        // create new .jsp
        new ActionNoBlock(null, "New|JSP").perform(webPages);
        NewJspFileNameStepOperator nameStep = new NewJspFileNameStepOperator();
        nameStep.setJSPFileName("page2");
        nameStep.finish();
        // check class is opened in Editor and then close the  document
        new EditorOperator("page2.jsp").close();
        ref(Util.dumpProjectView(PROJECT_NAME));
        //compareReferenceFiles();
        //compareDD();
    }
    
    /** Test new servlet wizard. 
     * - open New File wizard from main menu (File|New File)
     * - select sample project as target
     * - select Web|Servlet file type
     * - in the next panel type name
     * - finish the wizard
     * - check file is open in editor and close it
     */
    public void testNewServlet() throws IOException {
        // create a new package
        new ActionNoBlock("File|New File", null).perform();
        // WORKAROUND
        new EventTool().waitNoEvent(1000);
        WizardOperator newFileWizard = new WizardOperator("New File");
        new JComboBoxOperator(newFileWizard).selectItem(PROJECT_NAME);
        // workaround due to issue #46007
        new Node(new JTreeOperator(newFileWizard), "Java Classes").select();
        new Node(new JTreeOperator(newFileWizard), "Web").select();
        new JListOperator(newFileWizard, 1).selectItem("Servlet");
        newFileWizard.next();
        JTextFieldOperator txtPackageName = new JTextFieldOperator(newFileWizard);
        // clear text field
        txtPackageName.setText("");
        txtPackageName.typeText("Servlet1");
        JComboBoxOperator txtPackage = new JComboBoxOperator(newFileWizard,1);
        // clear text field
        txtPackage.clearText();
        txtPackage.typeText("test1");
        newFileWizard.next();
        newFileWizard.finish();
        // check class is opened in Editor and close it
        new EditorOperator("Servlet1.java").close();
        // check the servlet is specified in web.xml
        WebPagesNode webPages = new WebPagesNode(PROJECT_NAME);
        webPages.setComparator(new Operator.DefaultStringComparator(true, true));
        Node webXml = new Node(webPages, "WEB-INF|web.xml");
        new EditAction().performPopup(webXml);
        String xmlText = new EditorOperator("web.xml").getText();
        new EditorOperator("web.xml").closeAllDocuments();
        String[] content = new String[] {
            "<servlet-name>Servlet1</servlet-name>",
            "<servlet-class>test1.Servlet1</servlet-class>",
            "<url-pattern>/Servlet1</url-pattern>"
        };
        for (int i=0; i<content.length; i++) {
            assertTrue("Servlet is not correctly specifeid in web.xml." +
                    " Following line is missing in the web.xml:\n"+content[i],
                    xmlText.indexOf(content[i]) != -1);
        } 
        ref(Util.dumpProjectView(PROJECT_NAME));
        //compareReferenceFiles();
        //compareDD();
    }
    
    /** Test new Servlet wizard. 
     * - open New File wizard from main menu (File|New File)
     * - select sample project as target
     * - select Java Classes|Package file type
     * - in the next panel type package name in
     * - finish the wizard
     * - open New File wizard from context menu on created package node (New|File)
     * - select Web|Servlet file type
     * - in the next panel type class name in
     * - finish the wizard
     * - check class is open in editor and close it
     */
    public void testNewServlet2() throws IOException {
        NewFileWizardOperator.create(PROJECT_NAME, "Java Classes", "Java Package",
                null, "test2");
        Node sample1Node = new Node(phelper.getSourceNode(), "test2");
        // create a new class
        new ActionNoBlock(null, "New|Servlet").perform(sample1Node);
        WizardOperator newFileWizard = new WizardOperator("New Servlet");
        new JTextFieldOperator(newFileWizard).typeText("Servlet2");
        newFileWizard.next();
        new JTextFieldOperator(newFileWizard,1).setText("");
        new JTextFieldOperator(newFileWizard,1).typeText("Servlet2Name");
        new JTextFieldOperator(newFileWizard,2).setText("");
        new JTextFieldOperator(newFileWizard,2).typeText("/Servlet2URL");
        newFileWizard.finish();
        // check class is opened in Editor and then close it
        new EditorOperator("Servlet2.java").close();
        ref(Util.dumpProjectView(PROJECT_NAME));
        //compareReferenceFiles();
        //compareDD();
    }
    
    public void testBuildProject() {
        Node rootNode = new ProjectsTabOperator().getProjectRootNode(PROJECT_NAME);
        new BuildProjectAction().perform(rootNode);
        MainWindowOperator.getDefault().waitStatusText("Finished building");
        ref(Util.dumpFiles(new File(PROJECT_FOLDER)));
        //compareReferenceFiles();
    }
    
    public void testCompileAllJSP() {
        Node rootNode = new ProjectsTabOperator().getProjectRootNode(PROJECT_NAME);
        new Action(null,"Properties").perform(rootNode);
        NbDialogOperator properties = new NbDialogOperator("Project Properties");
        new Node(new JTreeOperator(properties), "Build|Compiling").select();
        new JCheckBoxOperator(properties,2).changeSelection(true);
        properties.ok();
        
        testBuildProject();
        testCleanProject();

        new Action(null,"Properties").perform(rootNode);
        properties = new NbDialogOperator("Project Properties");
        new Node(new JTreeOperator(properties), "Build|Compiling").select();
        new JCheckBoxOperator(properties,2).changeSelection(false);
        properties.ok();
    }
    
    public void testCompileJSP() {
        Node rootNode = new ProjectsTabOperator().getProjectRootNode(PROJECT_NAME);
        Node jspNode = new Node(rootNode,"Web Pages|page2.jsp");
        new Action(null,"Compile File").perform(jspNode);
        MainWindowOperator.getDefault().waitStatusText("Finished building");
        ref(Util.dumpFiles(new File(PROJECT_FOLDER)));
        //compareReferenceFiles();
    }
    
    public void testCleanProject() {
        Node rootNode = new ProjectsTabOperator().getProjectRootNode(PROJECT_NAME);
        new Action(null,"Clean Project").perform(rootNode);
        MainWindowOperator.getDefault().waitStatusText("Finished building");
        ref(Util.dumpFiles(new File(PROJECT_FOLDER)));
        //compareReferenceFiles();
    }
    
    public void testRunProject() throws Exception {
        Node rootNode = new ProjectsTabOperator().getProjectRootNode(PROJECT_NAME);
        new Node(rootNode,"Web Pages|index.jsp").performPopupAction("Open");
        EditorOperator editor = new EditorOperator("index.jsp");
        editor.replace("<title>JSP Page</title>",
                       "<title>SampleProject Index Page</title>");
        editor.insert("Running Project\n",23,1);
        new Action(null,"Run Project").perform(rootNode);
        waitBuildSuccessful();
        assertDisplayerContent("<title>SampleProject Index Page</title>");
        editor.deleteLine(23);
        editor.save();
        editor.close();
    }

    public void testRunJSP() {
        Node rootNode = new ProjectsTabOperator().getProjectRootNode(PROJECT_NAME);
        new Node(rootNode,"Web Pages|page2.jsp").performPopupAction("Open");
        EditorOperator editor = new EditorOperator("page2.jsp");
        editor.replace("<title>JSP Page</title>", "<title>Page 2</title>");
        editor.insert("Running JSP\n",6,1);
        new Action("Run|Run File|Run \"page2.jsp\"",null).perform();
        waitBuildSuccessful();
        assertDisplayerContent("<title>Page 2</title>");
        editor.deleteLine(6);
        editor.save();
        editor.close();
    }
    
    public void testRunServlet() {
        Node sourceNode = phelper.getSourceNode();
        new Node(sourceNode,"test1|Servlet1.java").performPopupAction("Open");
        EditorOperator editor = new EditorOperator("Servlet1.java");
        // TODO replace the absolute line numbers by a kind of find to avoid test
        // fails due minor template changes
        if (!editor.getText(30).equals("        /* TODO output your page here\n"))
            throw new AssertionFailedError("Servlet1.java:30 Other content than expected.\n"+
            "was >"+editor.getText(30)+"<, expected >        /* TODO output your page here\n<");
        if (!editor.getText(39).equals("         */\n"))
            throw new AssertionFailedError("Servlet1.java:39 Other content than expected.\n"+
            "was >"+editor.getText(39)+"<, expected >         */\n<");
        editor.deleteLine(39);
        editor.deleteLine(30);
        editor.replace("out.println(\"<title>Servlet Servlet1</title>\");",
                       "out.println(\"<title>Servlet with name=\"+request.getParameter(\"name\")+\"</title>\");");
        new ActionNoBlock("Run|Run File|Run \"Servlet1.java\"",null).perform();
        NbDialogOperator dialog = new NbDialogOperator("Set Servlet Execution Uri");
        JComboBoxOperator combo = new JComboBoxOperator(dialog);
        //-- another variant
        //String orig = combo.getSelectedItem().toString();
        //combo.getTextField().setText(orig+"?name=Servlet1");
        //dialog.ok();
        //-- works on jdk1.6
        combo.typeText("?name=Servlet1\n");
        //dialog.ok();
        editor.close();
        assertDisplayerContent("<title>Servlet with name=Servlet1</title>");
    }
    
    public void testCreateTLD() {
        //HACK
        new Node (new ProjectsTabOperator().getProjectRootNode(PROJECT_NAME), "Web Pages|WEB-INF").expand();

        // workaround due to issue #46073
        new ProjectsTabOperator().getProjectRootNode(PROJECT_NAME).select();

        new ActionNoBlock("File|New File", null).perform();
        // WORKAROUND
        new EventTool().waitNoEvent(1000);
        WizardOperator newFileWizard = new WizardOperator("New File");
        new JComboBoxOperator(newFileWizard).selectItem(PROJECT_NAME);
        // workaround due to issue #46007
        new Node(new JTreeOperator(newFileWizard), "Java Classes").select();
        new Node(new JTreeOperator(newFileWizard), "Web").select();
        new JListOperator(newFileWizard, 1).selectItem("Tag Library Descriptor");
        newFileWizard.next();
        JTextFieldOperator txtName = new JTextFieldOperator(newFileWizard);
        // clear text field
        txtName.setText("");
        txtName.typeText("MyTags");
        newFileWizard.finish();
        //XXX try { Thread.currentThread().sleep(5000); } catch (InterruptedException e) {}
        //XXX HACK #48865
        new Node (new ProjectsTabOperator().getProjectRootNode(PROJECT_NAME), "Web Pages|WEB-INF|tlds|MyTags.tld");
        // check class is opened in Editor and then close it
        new EditorOperator("MyTags.tld").close();
        ref(Util.dumpProjectView(PROJECT_NAME));
        //compareReferenceFiles();
    }
    
    public void testCreateTagHandler() {
        // workaround due to issue #46073
        new ProjectsTabOperator().getProjectRootNode(PROJECT_NAME).select();

        new ActionNoBlock("File|New File", null).perform();
        // WORKAROUND
        new EventTool().waitNoEvent(1000);
        WizardOperator newFileWizard = new WizardOperator("New File");
        new JComboBoxOperator(newFileWizard).selectItem(PROJECT_NAME);
        // workaround due to issue #46007
        new Node(new JTreeOperator(newFileWizard), "Java Classes").select();
        new Node(new JTreeOperator(newFileWizard), "Web").select();
        new JListOperator(newFileWizard, 1).selectItem("Tag Handler");
        newFileWizard.next();
        JTextFieldOperator txtName = new JTextFieldOperator(newFileWizard);
        // clear text field
        txtName.setText("");
        txtName.typeText("MyTag");
        JComboBoxOperator pkg = new JComboBoxOperator(newFileWizard,1);
        pkg.clearText();
        pkg.typeText("tags");
        newFileWizard.next();
        new JButtonOperator(newFileWizard).push();
        NbDialogOperator dialog = new NbDialogOperator("Browse Files");
        new Node(new JTreeOperator(dialog),"Web Pages|WEB-INF|tlds|MyTags.tld").select();
        new JButtonOperator(dialog,"Select File").push();
        newFileWizard.finish();
        // HACK
        new Node (phelper.getSourceNode(), "tags|MyTag.java");
        // check class is opened in Editor and then close it
        EditorOperator editor = new EditorOperator("MyTag.java");
        editor.insert(getTagHandlerCode(),43,1);
        editor.saveDocument();
        editor.close();
        ref(Util.dumpProjectView(PROJECT_NAME));
        //compareReferenceFiles();
    }
    
    protected String getTagHandlerCode() {
        return "out.print(\"TagOutput\"); \n";
    }
    
    public void testRunTag() throws Throwable {
        Node rootNode = new ProjectsTabOperator().getProjectRootNode(PROJECT_NAME);
        Node jspNode = new Node(rootNode,"Web Pages|page2.jsp");
        jspNode.performPopupAction("Open");
        EditorOperator editor = new EditorOperator("page2.jsp");
        editor.replace("<title>Page 2</title>",
                      "<title><my:MyTag/></title>");
        editor.insert("<%@taglib prefix=\"my\" uri=\"/WEB-INF/tlds/MyTags\"%>\n", 3, 1);
        
        new Action(null,"Run File").perform(jspNode);
        waitBuildSuccessful();
        editor.close();
        assertDisplayerContent("<title>TagOutput</title>");
    }
    
    public void testNewHTML() throws IOException {
        // workaround due to issue #46073
        new ProjectsTabOperator().getProjectRootNode(PROJECT_NAME).select();

        new ActionNoBlock("File|New File", null).perform();
        // WORKAROUND
        new EventTool().waitNoEvent(1000);
        WizardOperator newFileWizard = new WizardOperator("New File");
        new JComboBoxOperator(newFileWizard).selectItem(PROJECT_NAME);
        // workaround due to issue #46007
        new Node(new JTreeOperator(newFileWizard), "Java Classes").select();
        new Node(new JTreeOperator(newFileWizard), "Web").select();
        new JListOperator(newFileWizard, 1).selectItem("HTML");
        newFileWizard.next();
        JTextFieldOperator txtPackageName = new JTextFieldOperator(newFileWizard);
        // clear text field
        txtPackageName.setText("");
        txtPackageName.typeText("HTML");
        newFileWizard.finish();
        // check class is opened in Editor and then close it
        new EditorOperator("HTML.html").close();
        ref(Util.dumpProjectView(PROJECT_NAME));
        new Node(new ProjectsTabOperator().getProjectRootNode(PROJECT_NAME),"Web Pages|HTML.html");
        //compareReferenceFiles();
        //compareDD();
    }        
    
    public void testRunHTML() {
        Node rootNode = new ProjectsTabOperator().getProjectRootNode(PROJECT_NAME);
        new Node(rootNode,"Web Pages|HTML.html").performPopupAction("Open");
        new EditorOperator("HTML.html").replace("<title></title>",
                                                "<title>HTML Page</title>");
        new Action("Run|Run File|Run \"HTML.html\"",null).perform();
        //waitBuildSuccessful();
        new EditorOperator("HTML.html").close();
        assertDisplayerContent("<title>HTML Page</title>");
    }
    
    public void testNewSegment() throws IOException {
        Node sample1Node = new Node(new ProjectsTabOperator().getProjectRootNode(PROJECT_NAME),"Web Pages");
        // create a new class
        new ActionNoBlock(null, "New|JSP").perform(sample1Node);
        // WORKAROUND
        new EventTool().waitNoEvent(1000);
        WizardOperator newFileWizard = new WizardOperator("New JSP File");
        new JTextFieldOperator(newFileWizard).typeText("segment");
        new JCheckBoxOperator(newFileWizard).changeSelection(true);
        newFileWizard.finish();
        // check class is opened in Editor and then close all documents
        new EditorOperator("segment.jspf").close();
        ref(Util.dumpProjectView(PROJECT_NAME));
        new Node(new ProjectsTabOperator().getProjectRootNode(PROJECT_NAME),"Web Pages|segment.jspf");
        //compareReferenceFiles();
        //compareDD();
    }
    
    public void testNewDocument() throws IOException {
        Node sample1Node = new Node(new ProjectsTabOperator().getProjectRootNode(PROJECT_NAME),"Web Pages");
        // create a new class
        new ActionNoBlock(null, "New|JSP").perform(sample1Node);
        // WORKAROUND
        new EventTool().waitNoEvent(1000);
        WizardOperator newFileWizard = new WizardOperator("New JSP File");
        new JTextFieldOperator(newFileWizard).typeText("document");
        new JRadioButtonOperator(newFileWizard,1).changeSelection(true);
        newFileWizard.finish();
        // check class is opened in Editor and then close all documents
        new EditorOperator("document.jspx").close();
        ref(Util.dumpProjectView(PROJECT_NAME));
        new Node(new ProjectsTabOperator().getProjectRootNode(PROJECT_NAME),"Web Pages|document.jspx");
        //compareReferenceFiles();
        //compareDD();
    }
    
    public void testStopTomcat() throws Exception {
        Util.stopTomcat();
        try { Thread.currentThread().sleep(5000); } catch (InterruptedException e) {}
        URL url = new URL("http://localhost:8084");
        URLConnection connection = url.openConnection();
        try {
            connection.connect();
            fail("Connection to http://localhost:8084 established, but tomcat" +
                    " should not be running.");
        } catch (ConnectException e) {  }
    }
    
    public void testStartTomcat() throws Exception {
        Util.startTomcat();
        URL url = new URL("http://localhost:8084");
        URLConnection connection = url.openConnection();
        connection.connect();
    }
    
    public void testBrowserSettings() {
        OptionsOperator optionsOper = OptionsOperator.invoke();
        optionsOper.selectGeneral();
        // "Web Browser:"
        String webBrowserLabel = Bundle.getStringTrimmed(
                "org.netbeans.modules.options.general.Bundle",
                "Web_Browser");
        JLabelOperator jloWebBrowser = new JLabelOperator(optionsOper, webBrowserLabel);
        JComboBoxOperator combo = new JComboBoxOperator((JComboBox)jloWebBrowser.getLabelFor());
        for (int i=0; i<combo.getItemCount(); i++) {
            String item = combo.getItemAt(i).toString();
            log("Browser: "+item);
            if (!item.equals("<Default System Browser>") && 
                !item.equals("Mozilla") &&
                !item.equals("Netscape") &&
                !item.equals("Swing HTML Browser") &&
                !item.equals("Internet Explorer") &&
                !item.equals("Firefox") &&
                !item.equals("External Browser (command-line)"))
                fail("Unrecognized settings in Web Browser Options");
        }
        optionsOper.close();
    }
    
    public void testFinish() {
        Util.stopTomcat();
        ProjectSupport.closeProject(PROJECT_NAME);
    }
    
    //********************************************************
    
    protected void sleep(int milis) {
        try {
            Thread.sleep(milis);
        } catch (InterruptedException ex) {
            throw new JemmyException("Interrupted", ex);
        }
    }
    
    private void logAndCloseOutputs() throws IOException {
        long timeout = JemmyProperties.getCurrentTimeout(
                "ComponentOperator.WaitComponentTimeout");
        JemmyProperties.setCurrentTimeout(
                "ComponentOperator.WaitComponentTimeout", 3000);
        try {
            for (int i=0; i<10; i++) {
                OutputTabOperator output = new OutputTabOperator("");
                String log_name = "Output"+i+".log";
                int index = 0;
                while (new File(getWorkDir(),log_name).exists()) {
                    log_name = "Output"+i+"_"+(++index)+".log";
                }
                log(log_name,output.getName()+"\n-------------\n\n"+
                        output.getText());
                output.close();
            }
        } 
        catch (TimeoutExpiredException e) { }
        catch (IOException e) { throw e; }
        finally {
            JemmyProperties.setCurrentTimeout(
                    "ComponentOperator.WaitComponentTimeout", timeout);
        }
    }

    private void waitBuildSuccessful() {
        OutputTabOperator console = new OutputTabOperator(PROJECT_NAME);
        console.getTimeouts().setTimeout("ComponentOperator.WaitStateTimeout", 180000);
        console.waitText(BUILD_SUCCESSFUL);
    }
    
    private TomcatManager getTomcatManager() throws DeploymentManagerCreationException {
        String tomcatUri = "tomcat55:home=$bundled_home:base=$bundled_base";
        return (TomcatManager) TomcatFactory55.create().
                getDisconnectedDeploymentManager(tomcatUri);
    }
    
    private void initDisplayer() {
        if (urlDisplayer == null) {
            urlDisplayer = TestURLDisplayer.getInstance();
        }
        urlDisplayer.invalidateURL();
    }
    
    private void assertDisplayerContent(String substr) {
        try {
            urlDisplayer.waitURL();
        } catch (InterruptedException ex) {
            throw new JemmyException("Waiting interrupted.", ex);
        }
        String page = urlDisplayer.readURL();
        boolean contains = page.indexOf(substr) > -1;
        if (!contains) {
            log("DUMP OF: "+urlDisplayer.getURL()+"\n"); 
            log(page);
        }
        assertTrue("The '"+urlDisplayer.getURL()+"' page does not contain '"+substr+"'", contains);
    }
}

