/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.test.web;

import java.io.File;
import java.io.IOException;
import org.netbeans.jellytools.EditorOperator;
import org.netbeans.jellytools.NewProjectWizardOperator;
import org.netbeans.jellytools.NewWebProjectNameLocationStepOperator;
import org.netbeans.jellytools.NewWebProjectSourcesStepOperator;
import org.netbeans.jellytools.ProjectsTabOperator;
import org.netbeans.jellytools.WizardOperator;
import org.netbeans.jellytools.actions.ActionNoBlock;
import org.netbeans.jellytools.actions.NewProjectAction;
import org.netbeans.jellytools.nodes.Node;
import org.netbeans.jellytools.nodes.SourcePackagesNode;
import org.netbeans.jemmy.EventTool;
import org.netbeans.jemmy.operators.JComboBoxOperator;
import org.netbeans.jemmy.operators.JListOperator;
import org.netbeans.jemmy.operators.JTextFieldOperator;
import org.netbeans.jemmy.operators.JTreeOperator;
import org.netbeans.junit.NbTestSuite;
import org.netbeans.junit.ide.ProjectSupport;

/**
 *
 * @author  lm97939
 */
public class WebProjectValidationNb36WebModule extends WebProjectValidation {

    static {
        PROJECT_NAME = "WebModuleNB36"; // NOI18N
        PROJECT_FOLDER = PROJECT_LOCATION+File.separator+PROJECT_NAME;
    }

    /** Need to be defined because of JUnit */
    public WebProjectValidationNb36WebModule(String name) { 
        super(name);
    }
    
    /** Use for execution inside IDE */
    public static void main(java.lang.String[] args) {
        // run whole suite
        junit.textui.TestRunner.run(suite());
        // run only selected test case
        //junit.textui.TestRunner.run(new MyModuleValidation("testT2"));
    } 
   
     public static NbTestSuite suite() {
        NbTestSuite suite = new NbTestSuite();
        suite.addTest(new WebProjectValidationNb36WebModule("testNewWebProject"));
        suite.addTest(new WebProjectValidationNb36WebModule("testNewJSP"));
        suite.addTest(new WebProjectValidationNb36WebModule("testNewJSP2"));
        suite.addTest(new WebProjectValidationNb36WebModule("testNewServlet"));
        suite.addTest(new WebProjectValidationNb36WebModule("testNewServlet2"));
        suite.addTest(new WebProjectValidationNb36WebModule("testBuildProject"));
        suite.addTest(new WebProjectValidationNb36WebModule("testCompileAllJSP"));
        suite.addTest(new WebProjectValidationNb36WebModule("testCompileJSP"));
        suite.addTest(new WebProjectValidationNb36WebModule("testCleanProject"));
        suite.addTest(new WebProjectValidationNb36WebModule("testRunProject"));
        suite.addTest(new WebProjectValidationNb36WebModule("testRunJSP"));
        suite.addTest(new WebProjectValidationNb36WebModule("testRunServlet"));
        //suite.addTest(new WebProjectValidationNb36WebModule("testDebugProject"));
        //suite.addTest(new WebProjectValidationNb36WebModule("testRunToCursor"));
        //suite.addTest(new WebProjectValidationNb36WebModule("testDebugServlet"));
        suite.addTest(new WebProjectValidationNb36WebModule("testCreateTLD"));
        suite.addTest(new WebProjectValidationNb36WebModule("testCreateTagHandler"));
        suite.addTest(new WebProjectValidationNb36WebModule("testRunTag"));
        //suite.addTest(new WebProjectValidationNb36WebModule("testDebugTag"));
        suite.addTest(new WebProjectValidationNb36WebModule("testNewHTML"));
        suite.addTest(new WebProjectValidationNb36WebModule("testRunHTML"));
        suite.addTest(new WebProjectValidationNb36WebModule("testNewSegment"));
        suite.addTest(new WebProjectValidationNb36WebModule("testNewDocument"));  
        suite.addTest(new WebProjectValidationNb36WebModule("testStopTomcat"));
        suite.addTest(new WebProjectValidationNb36WebModule("testStartTomcat"));
        suite.addTest(new WebProjectValidationNb36WebModule("testFinish"));

        return suite;     
    }
    
    /** Test creation of web application. 
     * - open New Project wizard from main menu (File|New Project)
     * - select Web|Web Application
     * - in the next panel type project name and project location
     * - finish the wizard
     * - wait until scanning of java files is finished
     * - check index.jsp is opened 
     */
    public void testNewWebProject() throws IOException {
        new NewProjectAction().perform();
        NewProjectWizardOperator projectWizard = new NewProjectWizardOperator();
        projectWizard.selectCategory("Web");
        projectWizard.selectProject("Web Application with Existing Sources");
        projectWizard.next();        
        NewWebProjectNameLocationStepOperator
                nameStep = new NewWebProjectNameLocationStepOperator();
        nameStep.txtLocation().setText(getDataDir().getAbsolutePath()+
                File.separator+PROJECT_NAME);
        nameStep.txtProjectName().setText(PROJECT_NAME);
        nameStep.txtProjectFolder().setText(System.getProperty("xtest.data")+
                File.separator+PROJECT_NAME+"Prj");
        nameStep.next();
        new NewWebProjectSourcesStepOperator().finish();
        // wait for project creating 
        sleep(10000);
        ProjectSupport.waitScanFinished();
        //new EditorWindowOperator().getEditor("index.jsp");
        // HACK
        Node webPages = new Node(new ProjectsTabOperator().
                getProjectRootNode(PROJECT_NAME),"Web Pages");
        //new Node(webPages,"index.jsp");
        new Node(webPages,"WEB-INF|web.xml");
        new Node(webPages,"META-INF|context.xml");
        new Node(webPages,"WEB-INF|classes|dummy");
        new Node(webPages,"WEB-INF|lib|dummy");
        new Node(new SourcePackagesNode(PROJECT_NAME), 
                "<default package>|dummy");
        ref(Util.dumpProjectView(PROJECT_NAME));
        compareReferenceFiles();
        //compareDD();
    }
    
    /** Test new JSP wizard. 
     * - open New File wizard from main menu (File|New File)
     * - select sample project as target
     * - select Web|JSP file type
     * - in the next panel type name
     * - finish the wizard
     * - check file is open in editor and close all opened documents
     */
    public void testNewJSP() throws IOException {
        // workaround due to issue #46073
        new ProjectsTabOperator().getProjectRootNode(PROJECT_NAME).select();

        new ActionNoBlock("File|New File", null).perform();
        // WORKAROUND
        new EventTool().waitNoEvent(1000);
        WizardOperator newFileWizard = new WizardOperator("New File");
        new JComboBoxOperator(newFileWizard).selectItem(PROJECT_NAME);
        // workaround due to issue #46007
        new Node(new JTreeOperator(newFileWizard), "Java Classes").select();
        new Node(new JTreeOperator(newFileWizard), "Web").select();
        new JListOperator(newFileWizard, 1).selectItem("JSP");
        newFileWizard.next();
        JTextFieldOperator txtPackageName = new JTextFieldOperator(newFileWizard);
        // clear text field
        //XXX <workaround issue='#61034 - wrond default destination'>
        txtPackageName.setText("index");
        JTextFieldOperator txtProjectFolder = new JTextFieldOperator(
                newFileWizard, 2);
        txtProjectFolder.setText("");
        //</workaround>
        newFileWizard.finish();
        // check class is opened in Editor and then close it
        new EditorOperator("index.jsp").close();
        ref(Util.dumpProjectView(PROJECT_NAME));
        new Node(new ProjectsTabOperator().getProjectRootNode(PROJECT_NAME),"Web Pages|index.jsp");
        //compareReferenceFiles();
        //compareDD();
    }
    
 
    
}
