/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.web.api.webmodule;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.Repository;
import org.netbeans.modules.web.spi.webmodule.WebFrameworkProvider;
import org.openide.loaders.DataFolder;
import org.openide.loaders.FolderLookup;
import org.openide.util.Lookup;

/**
 *
 * @author Petr Pisl
 */

/** This class contains two static methods for obtaining all registerd
 * {@link org.netbeans.modules.web.spi.webmodule.WebFrameworkProvider}s
 * and for obtaining all registered {@link org.netbeans.modules.web.spi.webmodule.LibraryInfoProvider}s.
 **/

public final class WebFrameworkSupport {
    
    /**
     * This method looks for all {@link org.netbeans.modules.web.spi.webmodule.WebFrameworkProvider}s in the  j2ee/webtier/framework folder.
     * @return List of all {@link org.netbeans.modules.web.spi.webmodule.WebFrameworkProvider}s, which are registered in the layer - j2ee/webtier/framework folder.
     */
    public static List/*<WebFrameworkProvider>*/ getFrameworkProviders(){
        FileObject f = Repository.getDefault().getDefaultFileSystem().
                findResource("j2ee/webtier/framework"); //NOI18N
        if (f == null)
            return Collections.EMPTY_LIST;
        DataFolder folder = DataFolder.findFolder(f);
        FolderLookup l = new FolderLookup(folder);
        Lookup.Result result = l.getLookup().lookup(new Lookup.Template(WebFrameworkProvider.class));
        return new ArrayList(result.allInstances()); // since allInstances() returns a Collection
    }
}
