/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.websvc.editor.completion;

import java.awt.Image;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.TreeMap;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.editor.java.NbJavaJMISyntaxSupport;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.loaders.DataObject;

/**
 *
 * @author Marek Fukala
 */
public class FileAttributeSupport {
    
    private static String FILE_PROTOCOL_TEXT = "file://";
    
    static List completionResults(int offset, NbJavaJMISyntaxSupport sup, BaseDocument doc, String valuePart,  boolean requiresFileProtocolPrefix) {
        List res = new ArrayList();
        
        //value part (we support for the CC) may be:
        // file:///user/marek/myWSDL.xml - absolute
        // file://conf/myWSDL.xml - relative (to the project root || to the current source?????)
        
        boolean valueQuoted = valuePart.startsWith("\"");
        valuePart = Utils.unquote(valuePart);
        
        if(requiresFileProtocolPrefix) {
            if(FILE_PROTOCOL_TEXT.indexOf(valuePart) == 0 && FILE_PROTOCOL_TEXT.length() != valuePart.length() || valuePart.length() == 0) {
                //complete file://
                WSResultItem ri = new WSResultItem.FileProtocolResultItem(valueQuoted);
                res.add(0, ri);
                ri.setSubstituteOffset(offset - valuePart.length());
                
                return res;
            }
            
            if(!valuePart.startsWith(FILE_PROTOCOL_TEXT)) {
                return Collections.EMPTY_LIST;
            }
            //cut off the file:// part
            valuePart = valuePart.substring(FILE_PROTOCOL_TEXT.length());
        } else {
            //must start with quote if not file:// prefix
            if(!valueQuoted) return Collections.EMPTY_LIST;
        }
        
        //test if absolute path
        if(valuePart.startsWith("/")) {
            //we cannot do that now
            
            //FileUtil.!!!!!!!!!!!!!!
            //public static FileObject toFileObject(File file) {
            
            ErrorManager.getDefault().log(ErrorManager.INFORMATIONAL,"completion of absolute paths hasn't been implemented yet!");
            return Collections.EMPTY_LIST;
        }
        
        String path = "";   // NOI18N
        String fileNamePart = valuePart;
        int lastSlash = valuePart.lastIndexOf('/');
        if (lastSlash == 0) {
            path = "/"; // NOI18N
            fileNamePart = valuePart.substring(1);
        } else if (lastSlash > 0) { // not a leading slash?
            path = valuePart.substring(0, lastSlash);
            fileNamePart = (lastSlash == valuePart.length())? "": valuePart.substring(lastSlash+1);    // NOI18N
        }
        
        try {
            FileObject orig = NbEditorUtilities.getFileObject(doc);
            if(orig == null) {
                ErrorManager.getDefault().log(ErrorManager.INFORMATIONAL, "Cannot get FileObject from the edited document!");
                return res;
            }
            
            Project project = FileOwnerQuery.getOwner(orig);
            FileObject base = project.getProjectDirectory();
            
            // need to normalize fileNamePart with respect to orig
            String normalizedPath = resolveRelativeURL("/"+orig.getPath(), path);  // NOI18N
            //is this absolute path?
            if (path.startsWith("/"))
                normalizedPath = base.getPath() + path;
            else
                normalizedPath = normalizedPath.substring(1);
            
            
            FileSystem fs = orig.getFileSystem();
            FileObject folder = fs.findResource(normalizedPath);
            if (folder != null) {
                res = files(folder, fileNamePart, sup);
                if (!folder.equals(base) && !path.startsWith("/") // NOI18N
                && ((path.length() == 0 && fileNamePart.length() == 0) || (path.lastIndexOf("../")+3 == path.length()))){ // NOI18N
                    res.add(0,  new WSResultItem.PackageResultItem("../")); // NOI18N
                }
            }
        } catch (FileStateInvalidException ex) {
            // unreachable FS - disable completion
        } catch (IllegalArgumentException ex) {
            // resolving failed
        }
        int itemOffset = offset - valuePart.length() + lastSlash + 1;  // works even with -1
        int itemLength = fileNamePart.length();
        
        
        //set substitute offset
        Iterator i = res.iterator();
        while(i.hasNext()) {
            WSResultItem resultItem = (WSResultItem)i.next();
            resultItem.setSubstituteOffset(itemOffset);
        }
        
        return res;
    }
    
    private static List files(FileObject folder, String prefix, NbJavaJMISyntaxSupport sup) {
        ArrayList res = new ArrayList();
        TreeMap resFolders = new TreeMap();
        TreeMap resFiles = new TreeMap();
        
        Enumeration files = folder.getChildren(false);
        while (files.hasMoreElements()) {
            FileObject file = (FileObject)files.nextElement();
            String fname = file.getNameExt();
            if (fname.startsWith(prefix) && !"cvs".equalsIgnoreCase(fname)) {
                
                if (file.isFolder())
                    resFolders.put(file.getNameExt(), new WSResultItem.PackageResultItem(file.getNameExt() + "/"));
                else{
                    Image icon = getIcon(file); //try to get image from the FO
                    resFiles.put(file.getNameExt(), new WSResultItem.FileResultItem(file.getNameExt(), icon));
                }
            }
        }
        res.addAll(resFolders.values());
        res.addAll(resFiles.values());
        
        return res;
    }
    
    private static Image getIcon(FileObject fo) {
        Image icon = null;
        try {
            icon = DataObject.find(fo).getNodeDelegate().getIcon(java.beans.BeanInfo.ICON_COLOR_16x16);
        } catch(org.openide.loaders.DataObjectNotFoundException e) {
            e.printStackTrace(System.out);
        }
        return icon;
    }
    
    /** Returns an absolute context URL (starting with '/') for a relative URL and base URL.
     *  @param relativeTo url to which the relative URL is related. Treated as directory iff
     *    ends with '/'
     *  @param url the relative URL by RFC 2396
     *  @exception IllegalArgumentException if url is not absolute and relativeTo
     * can not be related to, or if url is intended to be a directory
     */
    private static String resolveRelativeURL(String relativeTo, String url) {
        //System.out.println("- resolving " + url + " relative to " + relativeTo);
        String result;
        if (url.startsWith("/")) { // NOI18N
            result = "/"; // NOI18N
            url = url.substring(1);
        } else {
            // canonize relativeTo
            if ((relativeTo == null) || (!relativeTo.startsWith("/"))) // NOI18N
                throw new IllegalArgumentException();
            relativeTo = resolveRelativeURL(null, relativeTo);
            int lastSlash = relativeTo.lastIndexOf('/');
            if (lastSlash == -1)
                throw new IllegalArgumentException();
            result = relativeTo.substring(0, lastSlash + 1);
        }
        
        // now url does not start with '/' and result starts with '/' and ends with '/'
        StringTokenizer st = new StringTokenizer(url, "/", true); // NOI18N
        while(st.hasMoreTokens()) {
            String tok = st.nextToken();
            //System.out.println("token : \"" + tok + "\""); // NOI18N
            if (tok.equals("/")) { // NOI18N
                if (!result.endsWith("/")) // NOI18N
                    result = result + "/"; // NOI18N
            } else
                if (tok.equals("")) // NOI18N
                    ;  // do nohing
                else
                    if (tok.equals(".")) // NOI18N
                        ;  // do nohing
                    else
                        if (tok.equals("..")) { // NOI18N
                String withoutSlash = result.substring(0, result.length() - 1);
                int ls = withoutSlash.lastIndexOf("/"); // NOI18N
                if (ls != -1)
                    result = withoutSlash.substring(0, ls + 1);
                        } else {
                // some file
                result = result + tok;
                        }
            //System.out.println("result : " + result); // NOI18N
        }
        //System.out.println("- resolved to " + result);
        return result;
    }
}
