/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.websvc.wsdl;

import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

import org.openide.util.NbBundle;
import org.openide.util.Utilities;

import org.netbeans.modules.xml.catalog.spi.CatalogReader;
import org.netbeans.modules.xml.catalog.spi.CatalogDescriptor;
import org.netbeans.modules.xml.catalog.spi.CatalogListener;

/** Catalog for webservice related schemas that enables completion support in
 *  editor.
 *
 *  Original code before webservice modifications taken from DDCatalog.java in web/core
 *
 * @author Peter Williams
 *
 */
public class WSSchemaCatalog implements CatalogReader, CatalogDescriptor, EntityResolver  {

    public static final String JAXRPC_CONFIG_1_1 = "http://java.sun.com/xml/ns/jax-rpc/ri/config"; // NOI18N
    public static final String JAXRPC_CONFIG_1_1_SLASH = "http://java.sun.com/xml/ns/jax-rpc/ri/config/"; // NOI18N
    private static final String JAXRPC_CONFIG_1_1_XSD = "jax-rpc-ri-config_1_1.xsd"; // NOI18N
    private static final String URL_JAXRPC_CONFIG_1_1 = "nbres:/org/netbeans/modules/websvc/wsdl/resources/jax-rpc-ri-config_1_1.xsd"; // NOI18N
    private static final String URL_JAXRPC_CONFIG_1_1_DTD = "nbres:/org/netbeans/modules/websvc/wsdl/resources/jax-rpc-ri-config_1_1.dtd"; // NOI18N

    public static final String JAXRPC_CONFIG_1_1_ID = "SCHEMA:" + JAXRPC_CONFIG_1_1; // NOI18N

    public WSSchemaCatalog() {
    }

    /**
     * Get String iterator representing all public IDs registered in catalog.
     * @return null if cannot proceed, try later.
     */
    public Iterator getPublicIDs() {
        List list = new ArrayList();
        list.add(JAXRPC_CONFIG_1_1_ID);
        return list.listIterator();
    }

    /**
     * Get registered systemid for given public Id or null if not registered.
     * @return null if not registered
     */
    public String getSystemID(String publicId) {
        if(JAXRPC_CONFIG_1_1_ID.equals(publicId)) {
            return URL_JAXRPC_CONFIG_1_1_DTD;
        } else {
            return null;
        }
    }

    /**
     * Refresh content according to content of mounted catalog.
     */
    public void refresh() {
    }

    /**
     * Optional operation allowing to listen at catalog for changes.
     * @throws UnsupportedOpertaionException if not supported by the implementation.
     */
    public void addCatalogListener(CatalogListener l) {
    }

    /**
     * Optional operation couled with addCatalogListener.
     * @throws UnsupportedOpertaionException if not supported by the implementation.
     */
    public void removeCatalogListener(CatalogListener l) {
    }

    /** Registers new listener.  */
    public void addPropertyChangeListener(PropertyChangeListener l) {
    }

    /**
     * @return I18N display name
     */
    public String getDisplayName() {
        return NbBundle.getMessage(WSSchemaCatalog.class, "LBL_WebServiceSchemaCatalog"); // NOI18N
    }

    /**
     * Return visualized state of given catalog.
     * @param type of icon defined by JavaBeans specs
     * @return icon representing current state or null
     */
    public java.awt.Image getIcon(int type) {
        return Utilities.loadImage("org/netbeans/modules/websvc/wsdl/resources/WebServiceSchemaCatalog.png"); // NOI18N
    }

    /**
     * @return I18N short description
     */
    public String getShortDescription() {
        return NbBundle.getMessage (WSSchemaCatalog.class, "DESC_WebServiceSchemaCatalog");
    }

    /** Unregister the listener.
     */
    public void removePropertyChangeListener(PropertyChangeListener l) {
    }

    /**
     * Resolves schema definition file for deployment descriptor (spec.2_4)
     * @param publicId publicId for resolved entity (null in our case)
     * @param systemId systemId for resolved entity
     * @return InputSource for
     */
    public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
        if(JAXRPC_CONFIG_1_1.equals(systemId) || JAXRPC_CONFIG_1_1_SLASH.equals(systemId)) {
            return new InputSource(URL_JAXRPC_CONFIG_1_1);
        } else if(systemId != null && systemId.endsWith(JAXRPC_CONFIG_1_1_XSD)) {
            return new org.xml.sax.InputSource(URL_JAXRPC_CONFIG_1_1);
        } else {
            return null;
        }
    }

    /**
     * Get registered URI for the given name or null if not registered.
     * @return null if not registered
     */
    public String resolveURI(String name) {
        if(JAXRPC_CONFIG_1_1.equals(name) || JAXRPC_CONFIG_1_1_SLASH.equals(name)) {
            return URL_JAXRPC_CONFIG_1_1;
        }

        return null;
    }
    /**
     * Get registered URI for the given publicId or null if not registered.
     * @return null if not registered
     */
    public String resolvePublic(String publicId) {
        return null;
    }
}
