/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.websvc.wsdl;

import java.io.*;
import java.util.Enumeration;

import org.w3c.dom.*;
import org.xml.sax.InputSource;

import org.openide.util.Enumerations;

import org.netbeans.modules.xml.api.model.GrammarEnvironment;
import org.netbeans.modules.xml.api.model.GrammarQuery;
import org.netbeans.modules.xml.api.model.GrammarQueryManager;
import org.netbeans.modules.xml.api.model.DTDUtil;

/** WS Schema Grammar provider for WSDL and jax-rpc config files
 *
 * @author Peter Williams, Milan Kuchtiak
 */
public class WSSchemaGrammarQueryMgr extends GrammarQueryManager
{
    private static final String XMLNS_ATTR = "xmlns"; //NOI18N
    private static final String JAXRPC_CONFIG_TAG = "configuration"; // NOI18N
    private static final String WSDL_DEFINITIONS = "definitions"; // NOI18N
    
    private static final int TYPE_WSDL = 0;
    private static final int TYPE_JAXRPC_CONFIG = 1;
    
    private static final String PUBLIC_WSDL="http://schemas.xmlsoap.org/wsdl/"; //NOI18N
    private static final String PUBLIC_SOAP="http://schemas.xmlsoap.org/wsdl/soap/"; //NOI18N
    private static final String PUBLIC_SOAPENC="http://schemas.xmlsoap.org/soap/encoding/"; //NOI18N
    private static final String PUBLIC_SCHEMA="http://www.w3.org/2001/XMLSchema"; //NOI18N
    
    private int schema_type;
    private String prefix, ns_wsdl, ns_soap, ns_soapenc, ns_schema;
    
    public Enumeration enabled(GrammarEnvironment ctx) {
        if (ctx.getFileObject() == null) {
            return null;
        }

        Enumeration en = ctx.getDocumentChildren();
        while(en.hasMoreElements()) {
            Node next = (Node) en.nextElement();
            if(next.getNodeType() == next.DOCUMENT_TYPE_NODE) {
                schema_type=-1;
                return null; // null for web.xml specified by DTD -- !PW not sure of the relevance here for jaxrpc
            } else if(next.getNodeType() == next.ELEMENT_NODE) {
                prefix=null;
                ns_wsdl="wsdl"; //NOI18N
                ns_soap="soap"; //NOI18N
                ns_soapenc="soapenc"; //NOI18N
                ns_schema="xsd"; //NOI18N
                Element element = (Element) next;
                String tag = element.getTagName();
                if(JAXRPC_CONFIG_TAG.equals(tag)) {
                    String xmlns = element.getAttribute(XMLNS_ATTR);
                    if(WSSchemaCatalog.JAXRPC_CONFIG_1_1.equals(xmlns) || WSSchemaCatalog.JAXRPC_CONFIG_1_1_SLASH.equals(xmlns)) {
                        schema_type=TYPE_JAXRPC_CONFIG;
                        return Enumerations.singleton (next);
                    }
                } else if (WSDL_DEFINITIONS.equals(tag)) {
                    schema_type=TYPE_WSDL;
                    prefix="";
                } else if (tag.endsWith(":"+WSDL_DEFINITIONS)) {
                    schema_type=TYPE_WSDL;
                    prefix = tag.substring(0,tag.indexOf(":"+WSDL_DEFINITIONS));
                }
                if (prefix!=null) {
                    NamedNodeMap map = element.getAttributes();
                    for (int i=0; i<map.getLength();i++) {
                        Attr attr = (Attr)map.item(i);
                        String name = attr.getName();
                        if (name.startsWith("xmlns:")) { //NOI18N
                            if (PUBLIC_WSDL.equals(attr.getValue()))
                                ns_wsdl=name.substring(6); //NOI18N
                            else if (PUBLIC_SOAP.equals(attr.getValue()))
                                ns_soap=name.substring(6); //NOI18N
                            else if (PUBLIC_SOAPENC.equals(attr.getValue()))
                                ns_soapenc=name.substring(6); //NOI18N
                            else if (PUBLIC_SCHEMA.equals(attr.getValue()))
                                ns_schema=name.substring(6); //NOI18N
                        }
                    }
                    return Enumerations.singleton (next);
                }
            }
        }

        return null;
    }

    public java.beans.FeatureDescriptor getDescriptor() {
        return new java.beans.FeatureDescriptor();
    }

    /** Returns pseudo DTD for code completion
    */
    public GrammarQuery getGrammar(GrammarEnvironment ctx) {
        InputSource inputSource=null;
        switch (schema_type) {
            case TYPE_WSDL: {
                StringBuffer buffer=new StringBuffer();
                if (prefix.length()==0) {
                    buffer.append("<!ENTITY % root_prefix ''>"); //NOI18N
                } else {
                    buffer.append("<!ENTITY % root_prefix '"+prefix+":'>"); //NOI18N
                }
                buffer.append("<!ENTITY % wsdl '"+ns_wsdl+"'>"); //NOI18N
                buffer.append("<!ENTITY % soap '"+ns_soap+"'>"); //NOI18N
                buffer.append("<!ENTITY % soapenc '"+ns_soapenc+"'>"); //NOI18N
                buffer.append("<!ENTITY % wsdl_prefix '"+ns_wsdl+":'>"); //NOI18N
                buffer.append("<!ENTITY % soap_prefix '"+ns_soap+":'>"); //NOI18N
                buffer.append("<!ENTITY % p '"+ns_schema+":'><!ENTITY % s ':"+ns_schema+"'>"); //NOI18N
                InputStream is = getClass().getResourceAsStream("/org/netbeans/modules/websvc/wsdl/resources/wsdl-soap.dtd"); //NOI18N
                BufferedReader br = new BufferedReader(new InputStreamReader(is));
                String line = null;
                try {
                    while ((line=br.readLine())!=null) {
                        buffer.append(line);
                    }
                    br.close();
                } catch (IOException ex) {
                    return null;
                }
                inputSource = new InputSource(new StringReader(buffer.toString()));
                inputSource.setSystemId("nbres:/org/netbeans/modules/websvc/wsdl/resources/wsdl-soap.dtd"); //NOI18N
            } break;
            case TYPE_JAXRPC_CONFIG: {
                inputSource = new InputSource("nbres:/org/netbeans/modules/websvc/wsdl/resources/jax-rpc-ri-config_1_1.dtd"); //NOI18N
            }break;
        }
        if (inputSource!=null) {
            return DTDUtil.parseDTD(true, inputSource);
        }
        return null;
    }
}
