/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.websvc.wsdl;

import java.io.IOException;

import org.openide.loaders.ExtensionList;
import org.openide.loaders.UniFileLoader;
import org.openide.loaders.MultiDataObject;
import org.openide.loaders.DataObjectExistsException;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

/** Loader for Wsdl DataObjects.
 *
 * @author Peter Williams
 */
public class WsdlDataLoader extends UniFileLoader {
    
    private static final String WSDL_MIME_TYPE = "text/xml-wsdl"; // NOI18N
    
    public WsdlDataLoader() {
       super("org.netbeans.modules.websvc.wsdl.WsdlDataObject"); // NOI18N
    }

    protected void initialize() {
        super.initialize();

        ExtensionList ext = new ExtensionList();
        ext.addMimeType(WSDL_MIME_TYPE);
        setExtensions(ext);
    }

    protected MultiDataObject createMultiObject(FileObject primaryFile) throws DataObjectExistsException, IOException {
        return new WsdlDataObject(primaryFile, this);
    }

    protected String defaultDisplayName() {
        return NbBundle.getBundle(WsdlDataLoader.class).getString("LBL_WsdlLoader_Name"); // NOI18N
    }
    
    protected String actionsContext() {
        return "Loaders/text/wsdl/Actions/"; // NOI18N
    }
}
