/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.websvc.wsdl;

import java.io.IOException;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeEvent;

import org.openide.nodes.Children;
import org.openide.loaders.DataNode;

import org.netbeans.modules.websvc.wsdl.xmlutils.XMLJ2eeDataObject;

/**
 *
 * @author Peter Williams
 */
public class WsdlDataNode extends DataNode {

    private WsdlDataObject dataObject;
    private PropertyChangeListener propertyChangeListener;

    public WsdlDataNode(WsdlDataObject obj) {
        super(obj, Children.LEAF);

        this.dataObject = obj;
        setIconBase(dataObject.getIconBaseForValidDocument());
        setShortDescription(null);
        addListeners();
    }

    public void destroy() throws IOException {
        super.destroy();
        removeListeners();
    }

    private void addListeners() {
        propertyChangeListener = new PropertyChangeListener() {
            public void propertyChange (PropertyChangeEvent evt) {
// !PW FIXME what properties are really interesting for this object?  PROP_DOC_VALID is fired by parser
//        the rest (commented out) came from the original template (EAR or EJB data node.)
//
//                if (EjbJarDataObject.PROP_DOCUMENT_DTD.equals (evt.getPropertyName ())) {
//                    firePropertyChange (PROPERTY_DOCUMENT_TYPE, evt.getOldValue (), evt.getNewValue ());
//                }
//                if (DataObject.PROP_VALID.equals (evt.getPropertyName ())
//                &&  Boolean.TRUE.equals (evt.getNewValue ())) {
//                    removePropertyChangeListener (EjbJarDataNode.this.ddListener);
//                }
                if(XMLJ2eeDataObject.PROP_DOC_VALID.equals(evt.getPropertyName())) {
                    if(Boolean.TRUE.equals (evt.getNewValue())) {
                        setIconBase(dataObject.getIconBaseForValidDocument());
                        setShortDescription(null);
                    } else {
                        setIconBase(dataObject.getIconBaseForInvalidDocument());
                        setShortDescription(dataObject.getStringForInvalidDocument());
                    }
                }
//                if (Node.PROP_PROPERTY_SETS.equals (evt.getPropertyName ())) {
//                    firePropertySetsChange(null,null);
//                }
            }
        };

        dataObject.addPropertyChangeListener(propertyChangeListener);
    }

    private void removeListeners() {
        dataObject.removePropertyChangeListener(propertyChangeListener);
    }
}
