/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 *
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.websvc.dev.wizard;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.xml.transform.stream.StreamSource;
import org.apache.tools.ant.module.api.support.ActionUtils;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.project.JavaProjectConstants;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.api.project.libraries.LibraryManager;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.modules.j2ee.api.ejbjar.EjbJar;
import org.netbeans.modules.j2ee.common.JMIUtils;
import org.netbeans.modules.j2ee.common.Util;
import org.netbeans.modules.j2ee.deployment.devmodules.api.Deployment;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eePlatform;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.websvc.api.jaxws.project.config.Service;
import org.netbeans.modules.websvc.api.jaxws.wsdlmodel.WsdlModelListener;
import org.netbeans.modules.websvc.api.jaxws.wsdlmodel.WsdlModeler;
import org.netbeans.modules.websvc.api.webservices.WebServicesSupport;
import org.netbeans.modules.websvc.jaxws.api.JAXWSSupport;
import org.netbeans.modules.websvc.api.jaxws.wsdlmodel.WsdlModel;
import org.netbeans.modules.websvc.api.jaxws.wsdlmodel.WsdlPort;
import org.netbeans.modules.websvc.api.jaxws.wsdlmodel.WsdlService;
import org.netbeans.modules.websvc.api.webservices.WsCompileEditorSupport;
import org.netbeans.modules.websvc.core.jaxws.JaxWsUtils;
import org.netbeans.modules.websvc.dev.dd.gen.wscreation.Bean;
import org.netbeans.spi.java.project.classpath.ProjectClassPathExtender;
import org.netbeans.spi.project.support.ant.GeneratedFilesHelper;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.WizardDescriptor;
import org.openide.cookies.EditorCookie;
import org.openide.execution.ExecutorTask;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

/**
 *
 * @author radko
 */
public class WebServiceCreator {
    
    private Project project;
    private String wsName;
    private int serviceType;
    private WizardDescriptor wiz;
    private int projectType;
    
    protected static final int JSE_PROJECT_TYPE = 0;
    protected static final int WEB_PROJECT_TYPE = 1;
    protected static final int EJB_PROJECT_TYPE = 2;
    
    private boolean jwsdpSupported = false;
    private boolean jsr109Supported = false;
    private boolean jsr109oldSupported = false;
    
    /** Creates a new instance of WebServiceCreator */
    
    public WebServiceCreator(Project project, WizardDescriptor wiz) {
        this.project = project;
        this.wiz = wiz;
    }
    
    public WebServiceCreator(Project project) {
        this.project = project;
    }
    
    public void create() {

        serviceType = ((Integer) wiz.getProperty(WizardProperties.WEB_SERVICE_TYPE)).intValue();
        initProjectInfo(project);
        
        // Use Progress API to display generator messages.
        final ProgressHandle handle = ProgressHandleFactory.createHandle( NbBundle.getMessage(WebServiceCreator.class, "TXT_WebServiceGeneration")); //NOI18N
        handle.start(100);
        
        Runnable r = new Runnable() {
            public void run() {
                try {
                    generateWebService(handle);
                } catch (Exception e) {
                    //finish progress bar
                    handle.finish();
                    String message = e.getLocalizedMessage();
                    if(message != null) {
                        ErrorManager.getDefault().notify(ErrorManager.INFORMATIONAL, e);
                        NotifyDescriptor nd = new NotifyDescriptor.Message(message, NotifyDescriptor.ERROR_MESSAGE);
                        DialogDisplayer.getDefault().notify(nd);
                    } else {
                        ErrorManager.getDefault().notify(ErrorManager.EXCEPTION, e);
                    }
                }
            }
        };
        RequestProcessor.getDefault().post(r);
    }
    
    public void createFromWSDL() {
        
        initProjectInfo(project);
        
        final ProgressHandle handle = ProgressHandleFactory.createHandle( NbBundle.getMessage(WebServiceCreator.class, "TXT_WebServiceGeneration")); //NOI18N
        
        Runnable r = new Runnable() {
            public void run() {
                try {
                    if (Util.isJavaEE5orHigher(project) ||
                            (!jsr109Supported && projectType == WEB_PROJECT_TYPE && !jsr109oldSupported)
                            || jwsdpSupported) {
                        handle.start();
                        generateWsFromWsdl15(handle);
                    } else {
                        handle.start(100);
                        generateWsFromWsdl14(handle);
                    }
                } catch (Exception e) {
                    //finish progress bar
                    handle.finish();
                    String message = e.getLocalizedMessage();
                    if(message != null) {
                        ErrorManager.getDefault().notify(ErrorManager.INFORMATIONAL, e);
                        NotifyDescriptor nd = new NotifyDescriptor.Message(message, NotifyDescriptor.ERROR_MESSAGE);
                        DialogDisplayer.getDefault().notify(nd);
                    } else {
                        ErrorManager.getDefault().notify(ErrorManager.EXCEPTION, e);
                    }
                }
            }
        };
        RequestProcessor.getDefault().post(r);
    }
    
    private void initProjectInfo(Project project) {
        JAXWSSupport wss = JAXWSSupport.getJAXWSSupport(project.getProjectDirectory());
        if (wss != null) {
            Map properties = wss.getAntProjectHelper().getStandardPropertyEvaluator().getProperties();
            String serverInstance = (String)properties.get("j2ee.server.instance"); //NOI18N
            if (serverInstance != null) {
                J2eePlatform j2eePlatform = Deployment.getDefault().getJ2eePlatform(serverInstance);
                if (j2eePlatform != null) {
                    jwsdpSupported = j2eePlatform.isToolSupported(J2eePlatform.TOOL_JWSDP);
                    jsr109Supported = j2eePlatform.isToolSupported(J2eePlatform.TOOL_JSR109);
                    jsr109oldSupported = j2eePlatform.isToolSupported(J2eePlatform.TOOL_WSCOMPILE);
                }
            }
        }
        
        WebModule wm = WebModule.getWebModule(project.getProjectDirectory());
        EjbJar em = EjbJar.getEjbJar(project.getProjectDirectory());
        if (em != null)
            projectType = EJB_PROJECT_TYPE;
        else if (wm != null)
            projectType = WEB_PROJECT_TYPE;
        else
            projectType = JSE_PROJECT_TYPE;
    }
    
    private FileObject generateJaxWSImplFromTemplate(FileObject pkg) throws Exception{
        DataFolder df = DataFolder.findFolder(pkg);
        FileObject template = Templates.getTemplate(wiz);
        
        if (projectType==EJB_PROJECT_TYPE) { //EJB Web Service
            FileObject templateParent = template.getParent();
            template = templateParent.getFileObject("EjbWebService","java"); //NOI18N
        }
        DataObject dTemplate = DataObject.find(template);
        DataObject dobj = dTemplate.createFromTemplate(df, wsName);
        FileObject createdFile = dobj.getPrimaryFile();
        
        openFileInEditor(dobj);
        return createdFile;
    }
    
    private void openFileInEditor(DataObject dobj){
        final EditorCookie ec = (EditorCookie)dobj.getCookie(EditorCookie.class);
        RequestProcessor.getDefault().post(new Runnable(){
            public void run(){
                ec.open();
            }
        }, 1000);
    }
    
    private String uniqueWSName(final String origName, List<String> names ){
        int uniquifier = 0;
        String truename = origName;
        while(names.contains(truename)){
            truename = origName + String.valueOf(++uniquifier);
        }
        return truename;
    }
    
    private String getUniqueJaxwsName(JAXWSSupport jaxWsSupport, String origName){
        List<Service> webServices = jaxWsSupport.getServices();
        List<String> serviceNames = new ArrayList<String>(webServices.size());
        for(Service service : webServices){
            serviceNames.add(service.getName());
        }
        return uniqueWSName(origName, serviceNames);
    }
    
    private String getUniqueJaxrpcName(WebServicesSupport wsSupport, String origName){
        List<WsCompileEditorSupport.ServiceSettings> webServices = wsSupport.getServices();
        List<String> serviceNames = new ArrayList<String>(webServices.size());
        for(WsCompileEditorSupport.ServiceSettings service: webServices){
            serviceNames.add(service.getServiceName());
        }
        return uniqueWSName(origName, serviceNames);
    }
    
    //TODO it should be refactored to prevent duplicate code but it is more readable now during development
    private void generateWebService(ProgressHandle handle) throws Exception {
        
        FileObject pkg = Templates.getTargetFolder(wiz);
        wsName = Templates.getTargetName(wiz);
        
        if (serviceType == WizardProperties.FROM_SCRATCH){
            if ((projectType == JSE_PROJECT_TYPE && Util.isSourceLevel16orHigher(project)) ||
                    ((Util.isJavaEE5orHigher(project) &&
                    (projectType == WEB_PROJECT_TYPE || projectType == EJB_PROJECT_TYPE))) ||
                    (jwsdpSupported)
                    ) {
                JAXWSSupport jaxWsSupport = JAXWSSupport.getJAXWSSupport(project.getProjectDirectory());
                wsName = getUniqueJaxwsName(jaxWsSupport, wsName);
                handle.progress(NbBundle.getMessage(WebServiceCreator.class, "MSG_GEN_WS"), 50); //NOI18N
                FileObject createdFile = generateJaxWSImplFromTemplate(pkg);
                handle.finish();
                return;
            } else if (!Util.isJavaEE5orHigher(project) && (projectType == WEB_PROJECT_TYPE ||projectType == EJB_PROJECT_TYPE)) { //NOI18N
                if ((!jsr109Supported && projectType == WEB_PROJECT_TYPE && !jsr109oldSupported)) {  //if the platform is not jsr 109
                    
                    JAXWSSupport jaxWsSupport = JAXWSSupport.getJAXWSSupport(project.getProjectDirectory());
                    wsName = getUniqueJaxwsName(jaxWsSupport, wsName);
                    handle.progress(NbBundle.getMessage(WebServiceCreator.class, "MSG_GEN_WS"), 50); //NOI18N
                    //add the JAXWS 2.0 library, if not already added
                    addJaxws20Library(project);
                    generateJaxWSImplFromTemplate(pkg);
                    
                    handle.finish();
                    
                } else {  //it's not J2ee 1.5 but it is JSR 109
                    WebServicesSupport wsSupport = WebServicesSupport.getWebServicesSupport(pkg);
                    assert wsSupport != null;
                    wsName = getUniqueJaxrpcName(wsSupport, wsName);
                    WebServiceGenerator generator = new WebServiceGenerator(wsSupport, wsName, pkg, project);
                    handle.progress(NbBundle.getMessage(WebServiceCreator.class, "MSG_GEN_SEI_AND_IMPL"), 50); //NOI18N
                    generator.generateWebService();
                    
                    URI targetNS = null;
                    URI typeNS = null;
                    try {
                        targetNS = generator.getTargetNS();
                        typeNS = generator.getDefaultTypeNS(wsName); //Need to get from user
                    } catch(java.net.URISyntaxException e) {
                        String mes = NbBundle.getMessage(WebServiceCreator.class, "MSG_INVALID_URL_SYNTAX"); //NOI18N
                        throw new Exception(mes);
                    }
                    //Create config file
                    handle.progress(NbBundle.getMessage(WebServiceCreator.class, "MSG_CREATING_WSCOMPILE_ARTIFACTS")); //NOI18N
                    String servantClassName = generator.getServantClassName();
                    String seiClassName = generator.getSEIClassName();
                    FileObject configFile = null;
                    configFile = generator.generateConfigFile(seiClassName, servantClassName, targetNS, typeNS);
                    handle.progress(70);
                    
                    //Add web service entries to the project's property file, project file
                    wsSupport.addServiceImpl(wsName, configFile, false);
                    handle.progress(90);
                    
                    //Add web service entries to the module's DD
                    wsSupport.addServiceEntriesToDD(wsName, seiClassName, servantClassName);
                    
                    //Add webservice entry in webservices.xml
                    handle.progress(NbBundle.getMessage(NewWebServiceWizardIterator.class, "MSG_ADDING_DD_ENTRIES")); //NOI18N
                    String portTypeName = null;
                    generator.addWebServiceEntry(seiClassName, portTypeName, targetNS);
                    
                    handle.finish();
                    
                    return;
                }
            }
        }
        if (serviceType == WizardProperties.ENCAPSULATE_SESSION_BEAN) {
            if ((projectType == JSE_PROJECT_TYPE && Util.isSourceLevel16orHigher(project)) ||
                    (Util.isJavaEE5orHigher(project) && (projectType == WEB_PROJECT_TYPE
                    ||projectType == EJB_PROJECT_TYPE)) //NOI18N
                    ) {
                
                JAXWSSupport jaxWsSupport = JAXWSSupport.getJAXWSSupport(project.getProjectDirectory());
                wsName = getUniqueJaxwsName(jaxWsSupport, wsName);
                // PENDING : the part below need to be simplified
                // (the SEI class doesn't need to be generated)
                WebServicesSupport wsSupport = WebServicesSupport.getWebServicesSupport(pkg);
                assert wsSupport != null;
                WebServiceGenerator generator = new WebServiceGenerator(wsSupport, wsName, pkg, project);
                handle.progress(NbBundle.getMessage(WebServiceCreator.class, "MSG_GEN_SEI_AND_IMPL"), 50); //NOI18N
                Node[] nodes = (Node[]) wiz.getProperty(WizardProperties.DELEGATE_TO_SESSION_BEAN);
                generator.generateWebServiceJavaEE5(nodes);
                
                handle.progress(70);
                
                String servantClassName = generator.getServantClassName();
                generator.addReferences(servantClassName, nodes);
                
                
                jaxWsSupport.addService(wsName,servantClassName, jsr109Supported);
                
                handle.finish();
                
                return;
            } else if (projectType == WEB_PROJECT_TYPE ||projectType == EJB_PROJECT_TYPE) {
                WebServicesSupport wsSupport = WebServicesSupport.getWebServicesSupport(pkg);
                assert wsSupport != null;
                wsName = getUniqueJaxrpcName(wsSupport, wsName);
                WebServiceGenerator generator = new WebServiceGenerator(wsSupport, wsName, pkg, project);
                handle.progress(NbBundle.getMessage(WebServiceCreator.class, "MSG_GEN_SEI_AND_IMPL"), 50); //NOI18N
                Node[] nodes = (Node[]) wiz.getProperty(WizardProperties.DELEGATE_TO_SESSION_BEAN);
                generator.generateWebService(nodes);
                
                URI targetNS = null;
                URI typeNS = null;
                try {
                    targetNS = generator.getTargetNS();
                    typeNS = generator.getDefaultTypeNS(wsName); //Need to get from user
                } catch(java.net.URISyntaxException e) {
                    String mes = NbBundle.getMessage(WebServiceCreator.class, "MSG_INVALID_URL_SYNTAX"); //NOI18N
                    throw new Exception(mes);
                }
                //Create config file
                handle.progress(NbBundle.getMessage(WebServiceCreator.class, "MSG_CREATING_WSCOMPILE_ARTIFACTS")); //NOI18N
                String servantClassName = generator.getServantClassName();
                String seiClassName = generator.getSEIClassName();
                FileObject configFile = null;
                configFile = generator.generateConfigFile(seiClassName, servantClassName, targetNS, typeNS);
                handle.progress(70);
                
                //Add web service entries to the project's property file, project file
                wsSupport.addServiceImpl(wsName, configFile, false);
                handle.progress(90);
                
                //Add web service entries to the module's DD
                wsSupport.addServiceEntriesToDD(wsName, seiClassName, servantClassName);
                
                //Add webservice entry in webservices.xml
                handle.progress(NbBundle.getMessage(NewWebServiceWizardIterator.class, "MSG_ADDING_DD_ENTRIES")); //NOI18N
                String portTypeName = null;
                generator.addWebServiceEntry(seiClassName, portTypeName, targetNS);
                
                generator.addReferences(servantClassName, nodes);
                
                handle.finish();
            }
            
            return;
        }
    }
    
    private void addJaxws20Library(Project project) throws Exception {
        
        // check if the wsimport class is already present - this means we don't need to add the library
        SourceGroup[] sgs = ProjectUtils.getSources(project).getSourceGroups(JavaProjectConstants.SOURCES_TYPE_JAVA);
        ClassPath classPath = ClassPath.getClassPath(sgs[0].getRootFolder(),ClassPath.COMPILE);
        FileObject wsimportFO = classPath.findResource("com/sun/tools/ws/ant/WsImport.class"); // NOI18N
        if (wsimportFO != null) {
            return;
        }
        
        ProjectClassPathExtender pce = (ProjectClassPathExtender)project.getLookup().lookup(ProjectClassPathExtender.class);
        Library jaxws20_ext = LibraryManager.getDefault().getLibrary("jaxws20"); //NOI18N
        if (pce != null && jaxws20_ext != null) {
            try{
                pce.addLibrary(jaxws20_ext);
            } catch(IOException e){
                throw new Exception("Unable to add JAXWS 2.0 Library. " + e.getMessage());
            }
        } else{
            throw new Exception("Unable to add JAXWS 2.0 Library. " +
                    "ProjectClassPathExtender or library not found");
        }
    }
    
    private void generateWsFromWsdl14(ProgressHandle handle) throws Exception {
        FileObject pkg = Templates.getTargetFolder(wiz);
        wsName = Templates.getTargetName(wiz);
        WebServicesSupport wsSupport = WebServicesSupport.getWebServicesSupport(pkg);
        assert wsSupport != null;
        WebServiceGenerator generator = new WebServiceGenerator(wsSupport, wsName, pkg, project);
        
        //coming from wsdl
        FileObject wsDDFolder = wsSupport.getWsDDFolder();
        //get wsdl folder, if none, create it
        FileObject wsdlFolder = wsDDFolder.getFileObject("wsdl"); //NOI18N
        if(wsdlFolder == null) {
            wsdlFolder = wsDDFolder.createFolder("wsdl"); //NOI18N
        }
        
        handle.progress(NbBundle.getMessage(WebServiceWizard.class, "MSG_PARSING_WSDL"), 30); //NOI18N
        String wsdlFilePath = (String)wiz.getProperty(WizardProperties.WSDL_FILE_PATH);
        File normalizedWsdlFilePath = FileUtil.normalizeFile(new File(wsdlFilePath));
        final FileObject sourceWsdlFile = FileUtil.toFileObject(normalizedWsdlFilePath);
        if(sourceWsdlFile == null) {
            String mes = NbBundle.getMessage(WebServiceWizard.class, "MSG_CANNOT_GET_FILE_OBJECT", normalizedWsdlFilePath.getAbsolutePath()); //NOI18N
            throw new IOException(mes);
        }
        List schemaFiles = WSGenerationUtil.getSchemaNames(sourceWsdlFile,true);
        String changedWsName = null;
        try {
            changedWsName = generator.parseWSDL(sourceWsdlFile.getInputStream());
        } catch (NoWSPortDefinedException exc) {
            ErrorManager.getDefault().log(ErrorManager.INFORMATIONAL, "WSDL does not contain any defined ports"); //NOI18N
            String mes = NbBundle.getMessage(WebServiceGenerator.class, "ERR_WsdlNoPortDefined"); // NOI18N
            NotifyDescriptor desc = new NotifyDescriptor.Message(mes, NotifyDescriptor.Message.ERROR_MESSAGE);
            DialogDisplayer.getDefault().notify(desc);
            handle.finish();
            return;
        }
        if (changedWsName==null) changedWsName = wsName;
        handle.progress(NbBundle.getMessage(WebServiceWizard.class, "MSG_CREATING_NEW_WSDL"), 50); //NOI18N
        FileObject wsdlFO = generator.generateWSDL(WebServiceGenerator.WSDL_TEMPLATE, changedWsName, generator.getSoapBinding(),
                generator.getPortTypeName(), wsdlFolder, sourceWsdlFile.getParent(), wsName, new StreamSource(sourceWsdlFile.getInputStream()));
        
        URI targetNS = null;
        URI typeNS = null;
        try {
            targetNS = generator.getTargetNS();
            typeNS = generator.getDefaultTypeNS(wsName);     //Need to get from user
        } catch(java.net.URISyntaxException e) {
            String mes = NbBundle.getMessage(WebServiceWizard.class, "MSG_INVALID_URL_SYNTAX"); //NOI18N
            throw new Exception(mes);
        }
        //Create config file
        handle.progress(NbBundle.getMessage(WebServiceWizard.class, "MSG_CREATING_WSCOMPILE_ARTIFACTS")); //NOI18N
        String servantClassName = generator.getServantClassName();
        String seiClassName = generator.getSEIClassName();
        FileObject configFile = null;
        
        File wsdlFile = FileUtil.toFile(wsdlFO);
        URI wsdlURI = wsdlFile.toURI();
        configFile = generator.generateConfigFile(wsdlURI);
        
        handle.progress(70);
        
        //Add web service entries to the project's property file, project file
        wsSupport.addServiceImpl(wsName, configFile, true, generator.getWscompileFeatures());
        //run the wscompile ant target
        handle.progress(NbBundle.getMessage(WebServiceWizard.class, "MSG_RUNNING_WSCOMPILE_TARGET")); //NOI18N
        String targetName = wsName + "_wscompile"; //NOI18N
        ExecutorTask task = ActionUtils.runTarget(findBuildXml(), new String[]{targetName}, null);
        task.waitFinished();
        if(task.result() != 0) {
            String mes = NbBundle.getMessage(WebServiceWizard.class, "MSG_WSCOMPILE_UNSUCCESSFUL"); //NOI18N
            wsSupport.removeProjectEntries(wsName);
            try {
                deleteFile(configFile);
                deleteFile(wsdlFO);
            } catch(IOException e) {
                String message = NbBundle.getMessage(WebServiceWizard.class, "MSG_UNABLE_DELETE_FILES"); //NOI18N
                NotifyDescriptor nd =
                        new NotifyDescriptor.Message(message,
                        NotifyDescriptor.ERROR_MESSAGE);
                DialogDisplayer.getDefault().notify(nd);
                //let this through
            }
            throw new Exception(mes);
        }
        handle.progress(90);
        addHeaderComments(wsName, servantClassName, pkg);
        wsSupport.addInfrastructure(servantClassName, pkg);
        
        //open the class in the editor
        String implClassName = servantClassName.substring(servantClassName.lastIndexOf(".") + 1); //NOI18N
        FileObject clz = pkg.getFileObject(implClassName, "java"); //NOI18N
        DataObject dobj = DataObject.find(clz);
        EditorCookie ec = (EditorCookie) dobj.getCookie(EditorCookie.class);
        ec.open();
        
        //Add web service entries to the module's DD
        wsSupport.addServiceEntriesToDD(wsName, seiClassName, servantClassName);
        
        //Add webservice entry in webservices.xml
        handle.progress(NbBundle.getMessage(WebServiceWizard.class, "MSG_ADDING_DD_ENTRIES")); //NOI18N
        String portTypeName = null;
        
        portTypeName = generator.getPortTypeName();
        
        generator.addWebServiceEntry(seiClassName, portTypeName, targetNS);
        
        handle.finish();
    }
    
    private void generateWsFromWsdl15(final ProgressHandle handle) throws Exception {
        String wsdlFilePath = (String) wiz.getProperty(WizardProperties.WSDL_FILE_PATH);
        File normalizedWsdlFilePath = FileUtil.normalizeFile(new File(wsdlFilePath));
        //convert to URI first to take care of spaces
        final URL wsdlURL = normalizedWsdlFilePath.toURI().toURL();
        final WsdlService service = (WsdlService) wiz.getProperty(WizardProperties.WSDL_SERVICE);
        if (service==null) {
            JAXWSSupport jaxWsSupport = JAXWSSupport.getJAXWSSupport(project.getProjectDirectory());
            FileObject targetFolder = Templates.getTargetFolder(wiz);
            String targetName = Templates.getTargetName(wiz);
            WsdlServiceHandler handler = (WsdlServiceHandler)wiz.getProperty(WizardProperties.WSDL_SERVICE_HANDLER);
            JaxWsUtils.generateJaxWsArtifacts(project,targetFolder,targetName,wsdlURL,handler.getServiceName(),handler.getPortName());
            WsdlModeler wsdlModeler = (WsdlModeler) wiz.getProperty(WizardProperties.WSDL_MODELER);
            if (wsdlModeler!=null && wsdlModeler.getCreationException()!=null) {
                    DialogDisplayer.getDefault().notify(new NotifyDescriptor.Message(
                            NbBundle.getMessage(WebServiceCreator.class,"TXT_CannotGenerateArtifacts",
                                                wsdlModeler.getCreationException().getLocalizedMessage()),
                            NotifyDescriptor.ERROR_MESSAGE)
                    );
            }
            handle.finish();
        } else {
            final WsdlPort port = (WsdlPort) wiz.getProperty(WizardProperties.WSDL_PORT);
            //String portJavaName = port.getJavaName();   
            WsdlModeler wsdlModeler = (WsdlModeler) wiz.getProperty(WizardProperties.WSDL_MODELER);
            // don't set the packageName for modeler (use the default one generated from target Namespace)
            wsdlModeler.generateWsdlModel(new WsdlModelListener() {
                public void modelCreated(WsdlModel model) {
                    WsdlService service1 = model.getServiceByName(service.getName());
                    WsdlPort port1 = service1.getPortByName(port.getName());
                    port1.setSOAPVersion(port.getSOAPVersion());
                    FileObject targetFolder = Templates.getTargetFolder(wiz);
                    String targetName = Templates.getTargetName(wiz);
                    try {
                        JaxWsUtils.generateJaxWsImplementationClass(project, targetFolder, targetName, wsdlURL, service1, port1);
                        handle.finish();
                    } catch (Exception ex) {
                        handle.finish();
                        ErrorManager.getDefault().notify(ErrorManager.EXCEPTION, ex);
                    }
                }
            });
        }
    }
    
    private void addHeaderComments(String wsName, String servantClassName, FileObject pkg) {
        String comment = NbBundle.getMessage(NewWebServiceWizardIterator.class, "MSG_WS_CLASS_COMMENT", wsName); //NOI18N
        StringBuffer buffer = new StringBuffer(comment + "\n"); //NOI18N
        buffer.append(NbBundle.getMessage(NewWebServiceWizardIterator.class, "MSG_CREATED_COMMENT")+ " " + DateFormat.getDateTimeInstance().format(new Date()) + "\n" ); //NOI18N
        buffer.append("@author " + System.getProperty("user.name") ); //NOI18N
        JavaMetamodel.getManager().waitScanFinished();
        JavaClass clazz = JMIUtils.findClass(servantClassName);
        if (clazz!=null) {
            String javadoc = clazz.getJavadocText();
            clazz.setJavadocText(buffer.toString());
        }
    }
    
    private void deleteFile(FileObject file)throws IOException {
        FileLock lock = null;
        try {
            lock = file.lock();
            file.delete(lock);
        } finally {
            if(lock != null) {
                lock.releaseLock();
            }
        }
    }
    
    private FileObject findBuildXml() {
        return project.getProjectDirectory().getFileObject(GeneratedFilesHelper.BUILD_XML_PATH);
    }
    
    public void createMessageHandler() throws IOException {
        
        initProjectInfo(project);
        
        //test JAX-WS library
        SourceGroup[] sgs = ProjectUtils.getSources(project).getSourceGroups(JavaProjectConstants.SOURCES_TYPE_JAVA);
        ClassPath classPath = ClassPath.getClassPath(sgs[0].getRootFolder(),ClassPath.COMPILE);
        FileObject wsimportFO = classPath.findResource("com/sun/tools/ws/ant/WsImport.class"); // NOI18N
        
        if ((projectType == JSE_PROJECT_TYPE && Util.isSourceLevel16orHigher(project)) ||
                (projectType == JSE_PROJECT_TYPE && Util.getSourceLevel(project).equals("1.5") && wsimportFO != null) || //NOI18N
                (Util.isJavaEE5orHigher(project) && (projectType == WEB_PROJECT_TYPE || projectType == EJB_PROJECT_TYPE)) || //NOI18N
                (jwsdpSupported) || (!jsr109Supported && projectType == WEB_PROJECT_TYPE && !jsr109oldSupported)
                ) {
            String handlerName = Templates.getTargetName(wiz);
            FileObject pkg = Templates.getTargetFolder(wiz);
            DataFolder df = DataFolder.findFolder(pkg);
            FileObject template = Templates.getTemplate(wiz);
            DataObject dTemplate = DataObject.find(template);
            DataObject dobj = dTemplate.createFromTemplate(df, handlerName);
            
            //open in the editor
            final EditorCookie ec = (EditorCookie) dobj.getCookie(EditorCookie.class);
            RequestProcessor.getDefault().post(new Runnable(){
                public void run(){
                    ec.open();
                }
            }, 1000);
        } else {
            WSGenerationUtil wsgenUtil = new WSGenerationUtil();
            final String HANDLER_TEMPLATE = WSGenerationUtil.TEMPLATE_BASE + "MessageHandler.xml"; //NOI18N
            FileObject pkg = Templates.getTargetFolder(wiz);
            String handlerName = Templates.getTargetName(wiz);
            String pkgName = wsgenUtil.getSelectedPackageName(pkg, project);
            Bean b = wsgenUtil.getDefaultBean();
            b.setCommentDataWsName(handlerName);
            b.setClassname(true);
            b.setClassnameName(handlerName);
            if(pkgName != null) {
                b.setClassnamePackage(pkgName);
            }
            String handlerClass =  wsgenUtil.getFullClassName(pkgName, wsgenUtil.generateClass(HANDLER_TEMPLATE, b, pkg, true));
        }
    }
    
    public void createLogicalHandler() throws IOException {
        
        initProjectInfo(project);
        
        //test JAX-WS library
        SourceGroup[] sgs = ProjectUtils.getSources(project).getSourceGroups(JavaProjectConstants.SOURCES_TYPE_JAVA);
        ClassPath classPath = ClassPath.getClassPath(sgs[0].getRootFolder(),ClassPath.COMPILE);
        FileObject wsimportFO = classPath.findResource("com/sun/tools/ws/ant/WsImport.class"); // NOI18N
        
        if ((projectType == JSE_PROJECT_TYPE && Util.isSourceLevel16orHigher(project)) ||
                (projectType == JSE_PROJECT_TYPE && Util.getSourceLevel(project).equals("1.5") && wsimportFO != null) || //NOI18N
                (Util.isJavaEE5orHigher(project) && (projectType == WEB_PROJECT_TYPE || projectType == EJB_PROJECT_TYPE)) || //NOI18N
                (jwsdpSupported) || (!jsr109Supported && projectType == WEB_PROJECT_TYPE && !jsr109oldSupported)
                ) {
            String handlerName = Templates.getTargetName(wiz);
            FileObject pkg = Templates.getTargetFolder(wiz);
            DataFolder df = DataFolder.findFolder(pkg);
            FileObject template = Templates.getTemplate(wiz);
            DataObject dTemplate = DataObject.find(template);
            DataObject dobj = dTemplate.createFromTemplate(df, handlerName);
            
            //open in the editor
            final EditorCookie ec = (EditorCookie) dobj.getCookie(EditorCookie.class);
            RequestProcessor.getDefault().post(new Runnable(){
                public void run(){
                    ec.open();
                }
            }, 1000);
        }
    }
    
    public int getProjectType() {
        initProjectInfo(project);
        return projectType;
    }
    
}

