/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.websvc.dev.wizard;

import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.Action;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.j2ee.api.ejbjar.EjbJar;
import org.netbeans.modules.j2ee.common.Util;
import org.netbeans.modules.j2ee.deployment.devmodules.api.Deployment;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eePlatform;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.websvc.jaxws.api.JAXWSSupport;
import org.netbeans.spi.project.ui.LogicalViewProvider;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.WizardDescriptor;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

/**
 *
 * @author  radko
 */
public class WebServiceTypePanel extends javax.swing.JPanel implements HelpCtx.Provider, ItemListener {
    
    private Project project;
    private Node[] sessionBeanNodes;
    
    private final List/*<ChangeListener>*/ listeners = new ArrayList();
    
    private boolean isWaitingForScan = false;
    private boolean jsr109Supported;
    private boolean jsr109oldSupported;
    private boolean jwsdpSupported;
    
    /** Creates new form WebServiceTypePanel */
    public WebServiceTypePanel(Project project) {
        this.project = project;
        
        initComponents();
        
        jsr109Supported = PlatformUtil.isJsr109Supported(project);
        jsr109oldSupported = PlatformUtil.isJsr109OldSupported(project);
        jwsdpSupported = PlatformUtil.isJWSDPSupported(project);
        
        //convert Java class not implemented for 5.5 release, disable components
        jRadioButtonConvert.setEnabled(false);
        jLabelConvert.setEnabled(false);
        jTextFieldConvert.setEnabled(false);
        jButtonConvert.setEnabled(false);
        jRadioButtonConvert.setVisible(false);
        jLabelConvert.setVisible(false);
        jTextFieldConvert.setVisible(false);
        jButtonConvert.setVisible(false);
        
        //disable encapsulate session bean for j2se project
        WebModule wm = WebModule.getWebModule(project.getProjectDirectory());
        EjbJar em = EjbJar.getEjbJar(project.getProjectDirectory());
        if ((em == null && wm == null)
        ||  //disable encapsulate session beans for Tomcat
                ((!jsr109Supported && !jsr109oldSupported ||
                (!jsr109Supported && jsr109oldSupported && jwsdpSupported ))) ) {
            disableDelegateToEJB();
        }
        
        addItemListener(this);
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {
        buttonGroup1 = new javax.swing.ButtonGroup();
        jRadioButtonScratch = new javax.swing.JRadioButton();
        jRadioButtonDelegate = new javax.swing.JRadioButton();
        jLabelDelegate = new javax.swing.JLabel();
        jTextFieldDelegate = new javax.swing.JTextField();
        jButtonDelegate = new javax.swing.JButton();
        jRadioButtonConvert = new javax.swing.JRadioButton();
        jLabelConvert = new javax.swing.JLabel();
        jTextFieldConvert = new javax.swing.JTextField();
        jButtonConvert = new javax.swing.JButton();

        buttonGroup1.add(jRadioButtonScratch);
        jRadioButtonScratch.setMnemonic(org.openide.util.NbBundle.getMessage(WebServiceTypePanel.class, "MNE_CreateEmptyWS").charAt(0));
        jRadioButtonScratch.setSelected(true);
        jRadioButtonScratch.setText(org.openide.util.NbBundle.getMessage(WebServiceTypePanel.class, "LBL_EmptyWebService"));
        jRadioButtonScratch.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
        jRadioButtonScratch.setMargin(new java.awt.Insets(0, 0, 0, 0));

        buttonGroup1.add(jRadioButtonDelegate);
        jRadioButtonDelegate.setMnemonic(org.openide.util.NbBundle.getMessage(WebServiceTypePanel.class, "MNE_DelegateSessionBean").charAt(0));
        jRadioButtonDelegate.setText(org.openide.util.NbBundle.getMessage(WebServiceTypePanel.class, "LBL_EncapsulateSessionBean"));
        jRadioButtonDelegate.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
        jRadioButtonDelegate.setMargin(new java.awt.Insets(0, 0, 0, 0));

        jLabelDelegate.setDisplayedMnemonic(org.openide.util.NbBundle.getMessage(WebServiceTypePanel.class, "MNE_EnterpriseBeans").charAt(0));
        jLabelDelegate.setLabelFor(jTextFieldDelegate);
        jLabelDelegate.setText(org.openide.util.NbBundle.getMessage(WebServiceTypePanel.class, "LBL_EnterpriseBean"));

        jTextFieldDelegate.setEditable(false);
        jTextFieldDelegate.setEnabled(false);

        jButtonDelegate.setMnemonic(org.openide.util.NbBundle.getMessage(WebServiceTypePanel.class, "MNE_Browse").charAt(0));
        jButtonDelegate.setText(org.openide.util.NbBundle.getMessage(WebServiceTypePanel.class, "LBL_Browse"));
        jButtonDelegate.setEnabled(false);
        jButtonDelegate.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonDelegateActionPerformed(evt);
            }
        });

        buttonGroup1.add(jRadioButtonConvert);
        jRadioButtonConvert.setText(org.openide.util.NbBundle.getMessage(WebServiceTypePanel.class, "LBL_ConvertJavaClass"));
        jRadioButtonConvert.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
        jRadioButtonConvert.setMargin(new java.awt.Insets(0, 0, 0, 0));

        jLabelConvert.setLabelFor(jTextFieldConvert);
        jLabelConvert.setText(org.openide.util.NbBundle.getMessage(WebServiceTypePanel.class, "LBL_JavaClass"));

        jTextFieldConvert.setEditable(false);
        jTextFieldConvert.setEnabled(false);

        jButtonConvert.setText(org.openide.util.NbBundle.getMessage(WebServiceTypePanel.class, "LBL_Browse"));
        jButtonConvert.setEnabled(false);

        org.jdesktop.layout.GroupLayout layout = new org.jdesktop.layout.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .add(jRadioButtonScratch)
                .addContainerGap(313, Short.MAX_VALUE))
            .add(layout.createSequentialGroup()
                .add(jRadioButtonDelegate)
                .addContainerGap())
            .add(layout.createSequentialGroup()
                .add(17, 17, 17)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(jLabelConvert)
                    .add(jLabelDelegate))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.TRAILING)
                    .add(jTextFieldConvert)
                    .add(jTextFieldDelegate))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.TRAILING)
                    .add(jButtonConvert)
                    .add(jButtonDelegate)))
            .add(layout.createSequentialGroup()
                .add(jRadioButtonConvert, 0, 497, Short.MAX_VALUE)
                .addContainerGap())
        );

        layout.linkSize(new java.awt.Component[] {jLabelConvert, jLabelDelegate}, org.jdesktop.layout.GroupLayout.HORIZONTAL);

        layout.setVerticalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .add(jRadioButtonScratch)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(jRadioButtonDelegate, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 15, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(jButtonDelegate)
                    .add(jLabelDelegate)
                    .add(jTextFieldDelegate, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(jRadioButtonConvert)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(jLabelConvert)
                    .add(jButtonConvert)
                    .add(jTextFieldConvert, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addContainerGap(184, Short.MAX_VALUE))
        );
    }// </editor-fold>//GEN-END:initComponents
    
    private void jButtonDelegateActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonDelegateActionPerformed
        Project[] allProjects = getCallableEjbProjects(project);
        List ejbProjectNodes = new LinkedList();
        
        for (int i = 0; i < allProjects.length; i++) {
            LogicalViewProvider lvp = (LogicalViewProvider) allProjects[i].getLookup().lookup(LogicalViewProvider.class);
            Node projectView = lvp.createLogicalView();
            ejbProjectNodes.add(new FilterNode(projectView, new EJBListViewChildren(allProjects[i])) {
                public Action[] getActions(boolean context) {
                    return new Action[0];
                }
            });
        }
        
        Children.Array children = new Children.Array();
        children.add((Node[]) ejbProjectNodes.toArray(new Node[ejbProjectNodes.size()]));
        Node root = new AbstractNode(children);
        EjbChooser chooser = new EjbChooser(root);
        final DialogDescriptor dd = new DialogDescriptor(chooser, org.openide.util.NbBundle.getMessage(WebServiceTypePanel.class, "LBL_BrowseBean_Title"));
        
        dd.setValid(false);
        chooser.addPropertyChangeListener(new PropertyChangeListener() {
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equals(EjbChooser.IS_VALID)) {
                    Object newvalue = evt.getNewValue();
                    if ((newvalue != null) && (newvalue instanceof Boolean)) {
                        dd.setValid(((Boolean) newvalue).booleanValue());
                    }
                }
            }
        });
        
        Object result = DialogDisplayer.getDefault().notify(dd);
        
        if (result == DialogDescriptor.OK_OPTION) {
            jTextFieldDelegate.setText(chooser.getSelectedEJBProjectName() + "#" + chooser.getSelectedNodes()[0].getDisplayName());
            sessionBeanNodes = chooser.getSelectedNodes();
            fireChange();
        }
    }//GEN-LAST:event_jButtonDelegateActionPerformed
    
    void validate(WizardDescriptor wizardDescriptor) {
    }
    
    boolean valid(WizardDescriptor wizardDescriptor) {
        //first check for JDK compliance (for non-JSR 109)
        if(!checkNonJsr109Valid(wizardDescriptor)){
            return false;
        }
        
        if (getServiceType() == WizardProperties.ENCAPSULATE_SESSION_BEAN &&
            jTextFieldDelegate.getText().length() == 0) {
            wizardDescriptor.putProperty("WizardPanel_errorMessage", NbBundle.getMessage(WebServiceTypePanel.class, "LBL_SelectOneEJB")); //NOI18N
            return false;        
        }
        
        if (JavaMetamodel.getManager().isScanInProgress()) {
            if (!isWaitingForScan) {
                isWaitingForScan = true;
                RequestProcessor.getDefault().post(new Runnable() {
                    public void run() {
                        JavaMetamodel.getManager().waitScanFinished();
                        isWaitingForScan = false;
                        fireChange();
                    }
                });
            }
            wizardDescriptor.putProperty("WizardPanel_errorMessage", NbBundle.getMessage(WebServiceTypePanel.class, "MSG_ScanningInProgress")); //NOI18N
            return false;
        } else
            wizardDescriptor.putProperty("WizardPanel_errorMessage", ""); //NOI18N
        
        return true;
    }
    
    /**
     * If the project the web service is being created is not on a JSR 109 platform,
     * its Java source level must be at least 1.5
     */
    private boolean checkNonJsr109Valid(WizardDescriptor wizardDescriptor){
        if(!jsr109Supported && !jsr109oldSupported ||
                (!jsr109Supported && jsr109oldSupported && jwsdpSupported )){
            if (Util.isSourceLevel14orLower(project)) {
                wizardDescriptor.putProperty("WizardPanel_errorMessage",
                        NbBundle.getMessage(WebServiceTypePanel.class, "ERR_NeedProperSourceLevel")); // NOI18N
                return false;
            }
        }
        return true;
    }
    
    
    void store(WizardDescriptor d) {
        d.putProperty(WizardProperties.WEB_SERVICE_TYPE, new Integer(getServiceType()));
        if (getServiceType() == WizardProperties.ENCAPSULATE_SESSION_BEAN)
            d.putProperty(WizardProperties.DELEGATE_TO_SESSION_BEAN, sessionBeanNodes);
    }
    
    void read(WizardDescriptor wizardDescriptor) {
    }
    
    public HelpCtx getHelpCtx() {
        return new HelpCtx(WebServiceTypePanel.class);
    }
    
    public void itemStateChanged(ItemEvent e) {
        Object src = e.getSource();
        if (src.equals(jRadioButtonScratch)) {
            jButtonDelegate.setEnabled(false);
            jTextFieldDelegate.setEnabled(false);
//convert Java class not implemented for 5.5 release
//            jButtonConvert.setEnabled(false);
//            jTextFieldConvert.setEnabled(false);
        } else if (src.equals(jRadioButtonDelegate)) {
            jButtonDelegate.setEnabled(true);
            jTextFieldDelegate.setEnabled(true);
//convert Java class not implemented for 5.5 release
//            jButtonConvert.setEnabled(false);
//            jTextFieldConvert.setEnabled(false);
        }
//convert Java class not implemented for 5.5 release
//        else if (src.equals(jRadioButtonConvert)) {
//            jButtonDelegate.setEnabled(false);
//            jTextFieldDelegate.setEnabled(false);
//            jButtonConvert.setEnabled(true);
//            jTextFieldConvert.setEnabled(true);
//        }
        
        fireChange();
    }
    
    public void addItemListener(ItemListener l) {
        jRadioButtonScratch.addItemListener(l);
        jRadioButtonDelegate.addItemListener(l);
//convert Java class not implemented for 5.5 release
//        jRadioButtonConvert.addItemListener(l);
    }
    
    public void removeItemListener(ItemListener l) {
        jRadioButtonScratch.removeItemListener(l);
        jRadioButtonDelegate.removeItemListener(l);
//convert Java class not implemented for 5.5 release
//        jRadioButtonConvert.removeItemListener(l);
    }
    
    public int getServiceType() {
        if (jRadioButtonScratch.isSelected())
            return WizardProperties.FROM_SCRATCH;
        else
//        else if (jRadioButtonDelegate.isSelected())
            return WizardProperties.ENCAPSULATE_SESSION_BEAN;
//convert Java class not implemented for 5.5 release
//        else
//            return NewWebServiceWizardIterator.CONVERT_JAVA_CLASS;
    }
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.ButtonGroup buttonGroup1;
    private javax.swing.JButton jButtonConvert;
    private javax.swing.JButton jButtonDelegate;
    private javax.swing.JLabel jLabelConvert;
    private javax.swing.JLabel jLabelDelegate;
    private javax.swing.JRadioButton jRadioButtonConvert;
    private javax.swing.JRadioButton jRadioButtonDelegate;
    private javax.swing.JRadioButton jRadioButtonScratch;
    private javax.swing.JTextField jTextFieldConvert;
    private javax.swing.JTextField jTextFieldDelegate;
    // End of variables declaration//GEN-END:variables
    
    private void disableDelegateToEJB(){
        jRadioButtonDelegate.setEnabled(false);
        jLabelDelegate.setEnabled(false);
        jTextFieldDelegate.setEnabled(false);
        jButtonDelegate.setEnabled(false);
    }
    
    /** Returns list of all EJB projects that can be called from the caller project.
     *
     * @param enterpriseProject the caller enterprise project
     */
    private Project [] getCallableEjbProjects(Project enterpriseProject) {
        Project[] allProjects = OpenProjects.getDefault().getOpenProjects();
        
        boolean isCallerEJBModule = false;
        J2eeModuleProvider callerJ2eeModuleProvider = (J2eeModuleProvider) enterpriseProject.getLookup().lookup(J2eeModuleProvider.class);
        if (callerJ2eeModuleProvider != null && callerJ2eeModuleProvider.getJ2eeModule().getModuleType().equals(J2eeModule.EJB)) {
            // TODO: HACK - this should be set by calling AntArtifactQuery.findArtifactsByType(p, EjbProjectConstants.ARTIFACT_TYPE_EJBJAR)
            // but now freeform doesn't implement this correctly
            isCallerEJBModule = true;
        }
        // TODO: HACK - this must be solved by freeform's own implementation of EnterpriseReferenceContainer, see issue 57003
        // call ejb should not make this check, all should be handled in EnterpriseReferenceContainer
        boolean isCallerFreeform = enterpriseProject.getClass().getName().equals("org.netbeans.modules.ant.freeform.FreeformProject");
        
        List /*<Project>*/ filteredResults = new ArrayList(allProjects.length);
        for (int i = 0; i < allProjects.length; i++) {
            boolean isEJBModule = false;
            J2eeModuleProvider j2eeModuleProvider = (J2eeModuleProvider) allProjects[i].getLookup().lookup(J2eeModuleProvider.class);
            if (j2eeModuleProvider != null && j2eeModuleProvider.getJ2eeModule().getModuleType().equals(J2eeModule.EJB)) {
                isEJBModule = true;
            }
            if ((isEJBModule && !isCallerFreeform) ||
                    (isCallerFreeform && enterpriseProject.equals(allProjects[i]))) {
                filteredResults.add(allProjects[i]);
            }
        }
        return (Project []) filteredResults.toArray(new Project[filteredResults.size()]);
    }
    
    public void addChangeListener(ChangeListener l) {
        listeners.add(l);
    }
    
    public void removeChangeListener(ChangeListener l) {
        listeners.remove(l);
    }
    
    private void fireChange() {
        ChangeEvent e = new ChangeEvent(this);
        Iterator it = listeners.iterator();
        while (it.hasNext()) {
            ((ChangeListener)it.next()).stateChanged(e);
        }
    }
    
}
