/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.websvc.dev.wizard;

import java.awt.Component;
import java.io.*;
import java.util.*;
import javax.swing.JComponent;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.modules.j2ee.common.JMIUtils;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;
import org.netbeans.spi.java.project.support.ui.templates.JavaTemplates;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.WizardDescriptor;
import javax.swing.event.ChangeListener;
import org.openide.util.NbBundle;
import org.openide.filesystems.FileObject;
import org.openide.nodes.Node;
import java.net.URI;
import org.netbeans.modules.websvc.api.webservices.WebServicesSupport;
import org.netbeans.modules.j2ee.common.Util;
import java.lang.reflect.Constructor;
import org.openide.ErrorManager;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileUtil;
import javax.xml.transform.stream.StreamSource;
import org.openide.filesystems.FileLock;
import org.netbeans.spi.project.support.ant.GeneratedFilesHelper;
import org.apache.tools.ant.module.api.support.ActionUtils;
import org.openide.execution.ExecutorTask;
import org.openide.cookies.EditorCookie;
import org.openide.loaders.DataObject;
import java.net.MalformedURLException;
import java.net.URL;
import org.openide.util.RequestProcessor;
import org.openide.windows.WindowManager;
import java.text.DateFormat;
import java.util.Date;

public class WebServiceWizard implements WizardDescriptor.InstantiatingIterator {
    public int currentPanel = 0;
    private WizardDescriptor.Panel firstPanel; //special case: use Java Chooser
    private WebServiceWizardDescriptor wsPanel;
    private WizardDescriptor wiz;
    private Project project;
    private String wsName;
    private WebServiceWizardHelper helper;
    private FileObject wsdlFO;

    // steps are referred to by these indexes into array "stepClassNames" and "steps"
    private static final int STEP_ENTER_NAME = 0;
    private static final int STEP_SELECT_EXISTING_CODE = 1;

    // each row in stepPaths gives the path (sequence of panel numbers) of a wizard branch.
    private static int[][] stepPaths = new int[][]{
        {STEP_ENTER_NAME},
        {STEP_ENTER_NAME, STEP_SELECT_EXISTING_CODE},
        {STEP_ENTER_NAME},
        {STEP_ENTER_NAME }
    };

    private static final String STEPNAME_ENTER_NAME=NbBundle.getMessage(WebServiceWizard.class, "LBL_SpecifyWSInfo");
    private static final String STEPNAME_SELECT_EXISTING_CODE = NbBundle.getMessage(WebServiceWizard.class, "LBL_SelectExistingCode");
    
    /*
    private static final String [] CREATE_WS_STEPS = new String[]{
        NbBundle.getMessage(WebServiceWizard.class, "LBL_SpecifyWSInfo"),
        NbBundle.getMessage(WebServiceWizard.class, "LBL_SelectExistingCode")
    };
     */

    // step names that correspond to each path above
    private static final String[][] stepPathNames = new String[][]{
        {STEPNAME_ENTER_NAME},
        {STEPNAME_ENTER_NAME, STEPNAME_SELECT_EXISTING_CODE},
        {STEPNAME_ENTER_NAME},
        {STEPNAME_ENTER_NAME}
    };

    //Indexes of each wizard branch stored in stepPaths
    public static final int PATH_CREATE_FROM_SCRATCH = 0;
    public static final int PATH_CREATE_FROM_EXISTING_CODE = 1;
    public static final int PATH_CREATE_FROM_WSDL_FILE = 2;
    public static final int PATH_CREATE_FROM_WSDL_URL = 3;

    private static int currentWizardBranch = PATH_CREATE_FROM_SCRATCH;

    //Class name of each wizard step panel (use for lazy instantiation)
    private static final String[] stepClassNames = new String[]	{
        "dummy",
        "org.netbeans.modules.websvc.dev.wizard.CreateWebServiceFromExistingCodePanel",
        "dummy",
        "dummy"
    };

    // When above Classes are dynamically instantiated, we store them in array "steps"
    // (this array mirrors array stepClassNames)
    private static WizardDescriptor.Panel[] steps = new WizardDescriptor.Panel[] { null, null, null, null};

    //Properties stored in the WizardDescriptor
    public static final String WSDL_FILE_PATH = "wsdlfilepath";
    public static final String WSDL_FILE_URL = "wsdlfileurl";


    public static WebServiceWizard create() {
        return new WebServiceWizard();
    }

    public void initialize(WizardDescriptor wizard) {

        currentWizardBranch= PATH_CREATE_FROM_SCRATCH;
        helper = new WebServiceWizardHelper();
        helper.setWizard(this);

        wiz = wizard;
        project = Templates.getProject(wiz);

        //create the Java Project chooser
        SourceGroup[] sourceGroups = Util.getJavaSourceGroups(project);
        wsPanel = new WebServiceWizardDescriptor(wiz, helper);
        if (sourceGroups.length==0) {
            firstPanel = Templates.createSimpleTargetChooser(project,sourceGroups, wsPanel);
        } else {
            firstPanel = JavaTemplates.createPackageChooser(project,sourceGroups, wsPanel, true);
        }
        
        wsPanel.setTargetChooserPanel(firstPanel);
        
        JComponent c = (JComponent)firstPanel.getComponent();
        Util.changeLabelInComponent(c, NbBundle.getMessage(Util.class, "LBL_JavaTargetChooserPanelGUI_ClassName_Label"),
        NbBundle.getMessage(WebServiceWizard.class, "LBL_Webservice_Name") );
        Util.hideLabelAndLabelFor(c, NbBundle.getMessage(Util.class, "LBL_JavaTargetChooserPanelGUI_CreatedFile_Label"));
    }

    // return a step panel, and instantiate it if necessary.
    private WizardDescriptor.Panel getStep(int step) {
        if(step == 0) return firstPanel;

        if (steps[step] != null) {
            return steps[step];
        }

        WizardDescriptor.Panel p =  createWizardPanel(stepClassNames[step]);
        ((WebServiceWizard.HasWizardHelper)p).setWizardHelper(helper);
        steps[step] = p;

        return p;
    }

    public void uninitialize(WizardDescriptor wizard)
    {}

    public Set instantiate() throws IOException {
        Component c = WindowManager.getDefault().getMainWindow();
        // Use Progress API to display generator messages.

        final ProgressHandle handle = ProgressHandleFactory.createHandle(
                NbBundle.getMessage(WebServiceWizard.class, "TXT_WebServiceGeneration"));
        handle.start(100);

        Runnable r = new Runnable() {
            public void run() {
                try {
                    generateWebService(handle);
                } catch (Exception e) {
                    //finish progress bar
                    handle.finish();
                    String message = e.getLocalizedMessage();
                    if(message != null) {
                        ErrorManager.getDefault().notify(ErrorManager.INFORMATIONAL, e);
                        NotifyDescriptor nd = new NotifyDescriptor.Message(message, NotifyDescriptor.ERROR_MESSAGE);
                        DialogDisplayer.getDefault().notify(nd);
                    } else {
                        ErrorManager.getDefault().notify(ErrorManager.EXCEPTION, e);
                    }                    
                }
            }
        };
        RequestProcessor.getDefault().post(r);
        return Collections.EMPTY_SET;
    }

    private void generateWebService(ProgressHandle handle) throws Exception {
        FileObject pkg = Templates.getTargetFolder(wiz);
        wsName = Templates.getTargetName(wiz);
        Project project = Templates.getProject(wiz);
        WebServicesSupport wsSupport = WebServicesSupport.getWebServicesSupport(pkg);
        assert wsSupport != null;
        WebServiceGenerator generator = new WebServiceGenerator(wsSupport, wsName, pkg, project);
        if(helper.getCreateFrom() == WebServiceWizardHelper.CREATE_FROM_SCRATCH) {
            handle.progress(NbBundle.getMessage(WebServiceWizard.class, "MSG_GEN_SEI_AND_IMPL"), 50);
            generator.generateWebService();
        }
        else if (helper.getCreateFrom() == WebServiceWizardHelper.CREATE_FROM_EXISTING_CODE) {
            handle.progress(NbBundle.getMessage(WebServiceWizard.class, "MSG_GEN_SEI_AND_IMPL"), 50);
            Node[] nodes = helper.getExistingCodeNodes();
            generator.generateWebService(nodes);
        }
        else  //coming from wsdl
        {
            FileObject wsDDFolder = wsSupport.getWsDDFolder();
            //get wsdl folder, if none, create it
            FileObject wsdlFolder = wsDDFolder.getFileObject("wsdl");
            if(wsdlFolder == null) {
                wsdlFolder = wsDDFolder.createFolder("wsdl");
            }
            if (helper.getCreateFrom() == WebServiceWizardHelper.CREATE_FROM_WSDL_FILE) {
                handle.progress(NbBundle.getMessage(WebServiceWizard.class, "MSG_PARSING_WSDL"), 30);
                String wsdlFilePath = (String)wiz.getProperty(WSDL_FILE_PATH);
                File normalizedWsdlFilePath = FileUtil.normalizeFile(new File(wsdlFilePath));
                final FileObject sourceWsdlFile = FileUtil.toFileObject(normalizedWsdlFilePath);
                if(sourceWsdlFile == null) {
                    String mes = NbBundle.getMessage(WebServiceWizard.class, "MSG_CANNOT_GET_FILE_OBJECT", normalizedWsdlFilePath.getAbsolutePath());
                    throw new IOException(mes);
                }
                List schemaFiles = WSGenerationUtil.getSchemaNames(sourceWsdlFile,true);
                String changedWsName = null;
                try {
                    changedWsName = generator.parseWSDL(sourceWsdlFile.getInputStream());
                } catch (NoWSPortDefinedException exc) {
                    ErrorManager.getDefault().log(ErrorManager.INFORMATIONAL, "WSDL does not contain any defined ports"); //NOI18N
                    String mes = NbBundle.getMessage(WebServiceGenerator.class, "ERR_WsdlNoPortDefined"); // NOI18N
                    NotifyDescriptor desc = new NotifyDescriptor.Message(mes, NotifyDescriptor.Message.ERROR_MESSAGE);
                    DialogDisplayer.getDefault().notify(desc);
                    handle.finish();
                    return;
                }
                if (changedWsName==null) changedWsName = wsName;
                handle.progress(NbBundle.getMessage(WebServiceWizard.class, "MSG_CREATING_NEW_WSDL"), 50);
                wsdlFO = generator.generateWSDL(WebServiceGenerator.WSDL_TEMPLATE, changedWsName, generator.getSoapBinding(),
                generator.getPortTypeName(), wsdlFolder, sourceWsdlFile.getParent(), wsName, new StreamSource(sourceWsdlFile.getInputStream()));
            }
            else if (helper.getCreateFrom() == WebServiceWizardHelper.CREATE_FROM_WSDL_URL) {
                handle.progress(NbBundle.getMessage(WebServiceWizard.class, "MSG_PARSING_WSDL"), 30);
                String wsdlUrl = (String) wiz.getProperty(WSDL_FILE_URL);
                URL url = null;
                InputStream in = null;
                try {
                    url = new URL(wsdlUrl);
                    in = url.openStream();
                }
                catch(MalformedURLException e) {
                    String mes = NbBundle.getMessage(WebServiceWizard.class, "MSG_CANNOT_LOCATE_URL", wsdlUrl);
                    throw new Exception(mes);
                }
                catch(IOException e) {
                    String mes = NbBundle.getMessage(WebServiceWizard.class, "MSG_UNABLE_ACCESS_URL", wsdlUrl);
                    throw new Exception(mes);
                }
                String changedWsName = null;
                try {
                    changedWsName = generator.parseWSDL(in);
                } catch (NoWSPortDefinedException exc) {
                    ErrorManager.getDefault().log(ErrorManager.INFORMATIONAL, "WSDL does not contain any defined ports"); //NOI18N
                    String mes = NbBundle.getMessage(WebServiceGenerator.class, "ERR_WsdlNoPortDefined"); // NOI18N
                    NotifyDescriptor desc = new NotifyDescriptor.Message(mes, NotifyDescriptor.Message.ERROR_MESSAGE);
                    DialogDisplayer.getDefault().notify(desc);
                    handle.finish();
                    return;
                }
                if (changedWsName==null) changedWsName = wsName;
                handle.progress(NbBundle.getMessage(WebServiceWizard.class, "MSG_CREATING_NEW_WSDL"), 50);
                wsdlFO = generator.generateWSDL(WebServiceGenerator.WSDL_TEMPLATE, changedWsName, generator.getSoapBinding(),
                generator.getPortTypeName(), wsdlFolder, wsName, new StreamSource(url.openStream()));
            }
        }

        URI targetNS = null;
        URI typeNS = null;
        try{
            targetNS = generator.getTargetNS();
            typeNS = generator.getDefaultTypeNS(wsName);     //Need to get from user
        }catch(java.net.URISyntaxException e){
            String mes = NbBundle.getMessage(WebServiceWizard.class, "MSG_INVALID_URL_SYNTAX");
            throw new Exception(mes);
        }
        //Create config file
        handle.progress(NbBundle.getMessage(WebServiceWizard.class, "MSG_CREATING_WSCOMPILE_ARTIFACTS"));
        String servantClassName = generator.getServantClassName();
        String seiClassName = generator.getSEIClassName();
        FileObject configFile = null;
        if (helper.getCreateFrom() == WebServiceWizardHelper.CREATE_FROM_WSDL_FILE ||
        helper.getCreateFrom() == WebServiceWizardHelper.CREATE_FROM_WSDL_URL) {
            File wsdlFile = FileUtil.toFile(wsdlFO);
            URI wsdlURI = wsdlFile.toURI();
            configFile = generator.generateConfigFile(wsdlURI);
        }
        else {
            configFile = generator.generateConfigFile(seiClassName, servantClassName, targetNS, typeNS);
        }
        handle.progress(70);

        //Add web service entries to the project's property file, project file
        if (helper.getCreateFrom() == WebServiceWizardHelper.CREATE_FROM_WSDL_FILE ||
        helper.getCreateFrom() == WebServiceWizardHelper.CREATE_FROM_WSDL_URL ) {
            wsSupport.addServiceImpl(wsName, configFile, true, generator.getWscompileFeatures());
            //run the wscompile ant target
            handle.progress(NbBundle.getMessage(WebServiceWizard.class, "MSG_RUNNING_WSCOMPILE_TARGET"));
            String targetName = wsName + "_wscompile";
            ExecutorTask task = ActionUtils.runTarget(findBuildXml(), new String[]{targetName}, null);
            task.waitFinished();
            if(task.result() != 0){
                String mes = NbBundle.getMessage(WebServiceWizard.class, "MSG_WSCOMPILE_UNSUCCESSFUL");
                wsSupport.removeProjectEntries(wsName);
                try {
                    deleteFile(configFile);
                    deleteFile(wsdlFO);
                }
                catch(IOException e) {
                    String message = NbBundle.getMessage(WebServiceWizard.class, "MSG_UNABLE_DELETE_FILES");
                    NotifyDescriptor nd =
                    new NotifyDescriptor.Message(message,
                    NotifyDescriptor.ERROR_MESSAGE);
                    DialogDisplayer.getDefault().notify(nd);
                    //let this through
                }
                throw new Exception(mes);
            }
            handle.progress(90);
            addHeaderComments(wsName, servantClassName, pkg);
            wsSupport.addInfrastructure(servantClassName, pkg);

            //open the class in the editor
            String implClassName = servantClassName.substring(servantClassName.lastIndexOf(".") + 1);
            FileObject clz = pkg.getFileObject(implClassName, "java");
            DataObject dobj = DataObject.find(clz);
            EditorCookie ec = (EditorCookie) dobj.getCookie(EditorCookie.class);
            ec.open();
        }
        else {
            wsSupport.addServiceImpl(wsName, configFile, false);
            handle.progress(90);
        }

        //Add web service entries to the module's DD
        wsSupport.addServiceEntriesToDD(wsName, seiClassName, servantClassName);
        
        //Add webservice entry in webservices.xml
        handle.progress(NbBundle.getMessage(WebServiceWizard.class, "MSG_ADDING_DD_ENTRIES"));
        String portTypeName = null;
        if(helper.getCreateFrom() == WebServiceWizardHelper.CREATE_FROM_WSDL_FILE || 
           helper.getCreateFrom() == WebServiceWizardHelper.CREATE_FROM_WSDL_URL) {
            portTypeName = generator.getPortTypeName();
        }
        generator.addWebServiceEntry(seiClassName, portTypeName, targetNS);

        if (helper.getCreateFrom() == WebServiceWizardHelper.CREATE_FROM_EXISTING_CODE) {
            generator.addReferences(servantClassName, helper.getExistingCodeNodes());
        }
        handle.finish();
    }

    private void addHeaderComments(String wsName, String servantClassName, FileObject pkg) {
        String comment = NbBundle.getMessage(WebServiceWizard.class, "MSG_WS_CLASS_COMMENT", wsName);
        StringBuffer buffer = new StringBuffer(comment + "\n");
        buffer.append(NbBundle.getMessage(WebServiceWizard.class, "MSG_CREATED_COMMENT")+ " " + DateFormat.getDateTimeInstance().format(new Date()) + "\n" );
        buffer.append("@author " + System.getProperty("user.name") );
        JavaMetamodel.getManager().waitScanFinished();
        JavaClass clazz = JMIUtils.findClass(servantClassName);
        if (clazz!=null) {
            String javadoc = clazz.getJavadocText();
            clazz.setJavadocText(buffer.toString());
        }
    }

    private void deleteFile(FileObject file)throws IOException{
        FileLock lock = null;
        try{
            lock = file.lock();
            file.delete(lock);
        }
        finally{
            if(lock != null){
                lock.releaseLock();
            }
        }
    }

    private FileObject findBuildXml() {
        return project.getProjectDirectory().getFileObject(GeneratedFilesHelper.BUILD_XML_PATH);
    }

    public void addChangeListener(ChangeListener l) {
        WizardDescriptor.Panel p = null;
        for(int i = 0; i < stepPathNames[currentWizardBranch].length; i++){
            //special case: if first panel add listener to wsPanel
            if(currentWizardBranch == 0) {
                p = wsPanel;
            }
            else {
                p = getStep(stepPaths[currentWizardBranch][i]);
            }
            if(p != null)
                p.addChangeListener(l);
        }
    }

    public WizardDescriptor.Panel current() {
        WizardDescriptor.Panel pnl = getStep(stepPaths[currentWizardBranch][currentPanel]);
        JComponent c = (JComponent) pnl.getComponent();
        if(currentPanel != 0) {
            ((WebServiceWizard.HasWizardHelper)pnl).setWizardHelper(helper);
        }
        c.putClientProperty("WizardPanel_contentData", stepPathNames[currentWizardBranch]); // NOI18N
        c.putClientProperty("WizardPanel_contentSelectedIndex", new Integer(currentPanel)); // NOI18N

        return getStep(stepPaths[currentWizardBranch][currentPanel]);
    }

    public boolean hasNext() {
        return ((currentPanel + 1) < stepPaths[currentWizardBranch].length);
    }

    public boolean hasPrevious() {
        return currentPanel > 0;
    }

    public String name() {
        return NbBundle.getMessage(WebServiceWizard.class, "LBL_Create_WS_Title");
    }

    public void nextPanel() {
        if(!hasNext()){
            throw new NoSuchElementException();
        }
        currentPanel++;
    }

    public void previousPanel() {
        if(!hasPrevious()){
            throw new NoSuchElementException();
        }
        currentPanel--;
    }

    public void removeChangeListener(ChangeListener l) {
        WizardDescriptor.Panel p = null;
        for (int i = 0; i < stepPathNames[currentWizardBranch].length; i++) {
            if(currentWizardBranch == 0) {
                p = wsPanel;
            }
            else {
                p = getStep(stepPaths[currentWizardBranch][i]);
            }
            if (p != null)
                p.removeChangeListener(l);
        }
    }

    // This is called by panel frames to tell the wizard that something the user
    // has done has caused a branch to occur.  Panel frame then calls fireStateChanged()
    // after calling this method.
    public void setPanelsAndSteps(int branch) {
        currentWizardBranch = branch;
    }

    protected int getCurrentPanelIndex() {
        return currentPanel;
    }

    protected WizardDescriptor.Panel createWizardPanel(String panelName) {
        try {
            Class newClass = Class.forName(panelName);
            Constructor cons = newClass.getDeclaredConstructor(new Class[]{WebServiceWizardHelper.class});
            return (WizardDescriptor.Panel) cons.newInstance(new Object[]{helper});
        }
        catch(Exception e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    // ----------------- Inner Classes ----------------------

    // this wizard's step panels must implememt this interface.
    public static interface HasWizardHelper {
        public void setWizardHelper(WebServiceWizardHelper h);
    }
    
}
