/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.websvc.jaxwsmodel.project.metadata;

import java.io.IOException;
import org.netbeans.modules.j2ee.metadata.MetadataUnit;
import org.netbeans.modules.j2ee.metadata.NNMDRListener;
import org.netbeans.modules.websvc.api.jaxws.project.config.JaxWsModel;

/**
 *
 * @author Marek Fukala
 */
public class JAXWSNNMergerProvider {
    
    private static final JAXWSNNMergerProvider nnProvider = new JAXWSNNMergerProvider();

    private JAXWSNNMergerProvider() {
    }
    
    public static JAXWSNNMergerProvider getDefault() {
        return nnProvider;
    }

    public synchronized void initNNMerger(JaxWsModel jaxwsmodel, MetadataUnit mu) throws IOException {
        if (mu == null || jaxwsmodel == null) {
            throw new IllegalArgumentException("method arguments cannot be null! (JaxWsModel=" + jaxwsmodel+ ", MetadataUnit=" + mu);
        }
        NNMDRListener.getDefault().addAnnotationListener(new JAXWSNNListener(jaxwsmodel, mu.getClassPath()));
        //System.out.println("JAXWSNNMergerProvider initialized... NN events should come soon...");
    }
    
}
