/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.websvc.wsitconf.refactoring;

import org.netbeans.jmi.javamodel.Element;
import org.netbeans.modules.javacore.internalapi.ExternalChange;
import org.netbeans.modules.refactoring.spi.RefactoringElementImplementation;
import org.netbeans.modules.refactoring.spi.SimpleRefactoringElementImpl;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;
import org.openide.filesystems.FileObject;
import org.openide.text.PositionBounds;

/**
 *
 * @author mg116726
 */
public abstract class AbstractRenameRefactoringElement extends SimpleRefactoringElementImpl implements RefactoringElementImplementation, ExternalChange {

    private int status = RefactoringElementImplementation.NORMAL;

    protected boolean enabled = true;
    protected String oldName;
    protected String newName;

    protected WSDLModel model;
    protected FileObject parentFile;
    
    /** Indicates whether this refactoring element is enabled.
     * @return <code>true</code> if this element is enabled, otherwise <code>false</code>.
     */
    @Override
    public boolean isEnabled() {
        return enabled;
    }

    /** Enables/disables this element.
     * @param enabled If <code>true</code> the element is enabled, otherwise it is disabled.
     */
    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    /** Returns text describing the refactoring element.
     * @return Text.
     */
    public String getText() {
        return getDisplayText();
    }

    /** Returns Java element associated with this refactoring element.
     * @return MDR Java element.
     */
    public Element getJavaElement() {
        return null;
    }

    /** Returns file that the element affects (relates to)
     * @return File
     */
    public FileObject getParentFile() {
        return parentFile;
    }

    /** Returns position bounds of the text to be affected by this refactoring element.
     */
    public PositionBounds getPosition() {
        return null;
    }

    /** Returns the status of this refactoring element (whether it is a normal element,
     * or a warning.
     * @return Status of this element.
     */
    @Override
    public int getStatus() {
        return status;
    }

    @Override
    public void setStatus(int status) {
        this.status = status;
    }
    
}