/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.websvc.wsitconf.ui.client;

import java.io.IOException;
import java.util.Enumeration;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.modules.j2ee.deployment.devmodules.api.Deployment;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eePlatform;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.javacore.api.JavaModel;
import org.netbeans.modules.websvc.jaxws.api.JAXWSSupport;
import org.netbeans.modules.websvc.wsitconf.ui.StoreFileFilter;
import org.netbeans.modules.websvc.wsitconf.util.Util;
import org.netbeans.modules.websvc.wsitmodelext.security.proprietary.KeyStore;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.ProprietarySecurityPolicyModelHelper;
import org.netbeans.modules.xml.multiview.ui.SectionInnerPanel;
import org.netbeans.modules.xml.multiview.ui.SectionView;
import org.netbeans.modules.xml.multiview.ui.SectionVisualTheme;
import org.netbeans.modules.xml.wsdl.model.Binding;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import javax.swing.*;
import java.io.File;
import org.netbeans.modules.j2ee.deployment.plugins.api.InstanceProperties;
import org.netbeans.modules.websvc.api.jaxws.project.config.JaxWsModel;
import org.netbeans.modules.websvc.wsitconf.spi.SecurityCheckerRegistry;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;

/**
 *
 * @author Martin Grebac
 */
public class KeystorePanel extends SectionInnerPanel {

    private static final String PKCS12 = "PKCS12";  //NOI18N
    private static final String JKS = "JKS";        //NOI18N

    private static final String DEFAULT_PASSWORD="changeit";    //NOI18N
    
    private WSDLModel model;
    private Node node;
    private Binding binding;

    private String keystoreType = JKS;
    private String truststoreType = JKS;
    
    private boolean inSync = false;
    
    private Project project;
    
    private JaxWsModel jaxwsmodel;
    
    public KeystorePanel(SectionView view, WSDLModel model, Node node, Binding binding, JaxWsModel jaxwsmodel) {
        super(view);
        this.model = model;
        this.node = node;
        this.binding = binding;
        this.jaxwsmodel = jaxwsmodel;
        
        FileObject fo = (FileObject) node.getLookup().lookup(FileObject.class);
        if (fo != null) project = FileOwnerQuery.getOwner(fo);
        
        initComponents();

        keyAliasCombo.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        keyAliasLabel.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        keyPasswordLabel.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        keyPasswordField.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        keystoreLocationLabel.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        keystoreLocationTextField.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        keystorePasswordLabel.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        keystorePasswordField.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        trustAliasCombo.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        trustAliasLabel.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        trustPasswordField.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        truststoreLocationLbl.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        truststoreLocationTextField.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        truststorePasswordLabel.setBackground(SectionVisualTheme.getDocumentBackgroundColor());

        addModifier(keystoreLocationTextField);
        addModifier(keyAliasCombo);
        addModifier(keystorePasswordField);
        addModifier(keyPasswordField);
        addModifier(truststoreLocationTextField);
        addModifier(trustPasswordField);
        addModifier(trustAliasCombo);

        sync();
    }

    private String getKeystoreAlias() {
        return (String) this.keyAliasCombo.getSelectedItem();
    }

    private void setKeystoreAlias(String alias) {
        this.keyAliasCombo.setSelectedItem(alias);
    }
    
    private String getTruststoreAlias() {
        return (String) this.trustAliasCombo.getSelectedItem();
    }

    private void setTruststoreAlias(String alias) {
        this.trustAliasCombo.setSelectedItem(alias);
    }

    private char[] getCharPassword(boolean trust) {
        return trust ? trustPasswordField.getPassword() : keystorePasswordField.getPassword();
    }

    private String getKeyPassword() {
        return String.valueOf(this.keyPasswordField.getPassword());
    }
    
    private String getKeystorePassword() {
        return String.valueOf(this.keystorePasswordField.getPassword());
    }

    private void setKeyPassword(String password) {
        this.keyPasswordField.setText(password);
    }

    private void setKeystorePassword(String password) {
        this.keystorePasswordField.setText(password);
    }

    private String getTruststorePassword() {
        return String.valueOf(this.trustPasswordField.getPassword());
    }

    private void setTruststorePassword(String password) {
        this.trustPasswordField.setText(password);
    }
    
    private void setKeystorePath(String path) {
        this.keystoreLocationTextField.setText(path);
    }
    
    private String getKeystorePath() {
        String path = this.keystoreLocationTextField.getText();
        if ("".equals(path) || (path == null)) {    //NOI18N
            return null;
        }
        return path;
    }

    private void setTruststorePath(String path) {
        this.truststoreLocationTextField.setText(path);
    }

    private String getTruststorePath() {
        String path = this.truststoreLocationTextField.getText();
        if ("".equals(path) || (path == null)) {    //NOI18N
            return null;
        }
        return path;
    }
    
    public void sync() {
        inSync = true;
                
        J2eePlatform p = null;        
        JavaClass jc = (JavaClass)node.getLookup().lookup(JavaClass.class);
        JAXWSSupport ws = null;
        FileObject fo = null;
        if (jc != null) {
            fo = JavaModel.getFileObject(jc.getResource());
            if (fo != null) {
                ws = JAXWSSupport.getJAXWSSupport(fo);
            }
        }
        if ((ws != null) && (fo != null)) {
            Project project = FileOwnerQuery.getOwner(fo);
            if (project != null) {
                J2eeModuleProvider mp = (J2eeModuleProvider)project.getLookup().lookup(J2eeModuleProvider.class);
                if (mp != null) {
                    String instance = mp.getServerInstanceID();
                    p = Deployment.getDefault().getJ2eePlatform(instance);
                }
            }
        }

        String keystoreLocation = ProprietarySecurityPolicyModelHelper.getStoreLocation(binding, false);
        if (keystoreLocation != null) {
            setKeystorePath(keystoreLocation);
        } else {
            setKeystorePath(getServerStoreLocation(false));
        }
        
        String truststoreLocation = ProprietarySecurityPolicyModelHelper.getStoreLocation(binding, true);
        if (truststoreLocation != null) {
            setTruststorePath(truststoreLocation);
        } else {
            setTruststorePath(getServerStoreLocation(true));
        }
       
        String keyStorePassword = ProprietarySecurityPolicyModelHelper.getStorePassword(binding, false);
        if (keyStorePassword != null) {
            setKeystorePassword(keyStorePassword);
            reloadAliases(false);
        } else {
            setKeystorePassword(DEFAULT_PASSWORD);
        }
        
        String trustStorePassword = ProprietarySecurityPolicyModelHelper.getStorePassword(binding,true);
        if (trustStorePassword != null) {
            setTruststorePassword(trustStorePassword);
            reloadAliases(true);
        } else {
            setTruststorePassword(DEFAULT_PASSWORD);
        }

        String keyPassword = ProprietarySecurityPolicyModelHelper.getKeyPassword(binding);
        if (keyPassword != null) {
            setKeyPassword(keyPassword);
        }

        String keyStoreAlias = ProprietarySecurityPolicyModelHelper.getStoreAlias(binding, false);
        setKeystoreAlias(keyStoreAlias);
            
        String truststoreAlias = ProprietarySecurityPolicyModelHelper.getStoreAlias(binding,true);
        setTruststoreAlias(truststoreAlias);
        
        enableDisable();
        
        inSync = false;
    }
    
    private String getServerStoreLocation(boolean trust) {
        String storeLocation = null;
        J2eeModuleProvider mp = (J2eeModuleProvider)project.getLookup().lookup(J2eeModuleProvider.class);
        if (mp != null) {
            String sID = mp.getServerInstanceID();

            InstanceProperties ip = mp.getInstanceProperties();
            if ("".equals(ip.getProperty("LOCATION"))) {
                return "";
            }
            
            J2eePlatform j2eePlatform = Deployment.getDefault().getJ2eePlatform(sID);
            File[] keyLocs = null;
            keyLocs = trust ? j2eePlatform.getToolClasspathEntries(J2eePlatform.TOOL_TRUSTSTORE_CLIENT) :
                              j2eePlatform.getToolClasspathEntries(J2eePlatform.TOOL_KEYSTORE_CLIENT);
            if ((keyLocs != null) && (keyLocs.length > 0)) {
                storeLocation = keyLocs[0].getAbsolutePath();
            }
        }
        return storeLocation;
    }
    
    @Override
    public void setValue(javax.swing.JComponent source, Object value) {
        
        if (inSync) return;
        
        if (source.equals(keystoreLocationTextField) || 
                source.equals(keyAliasCombo) || 
                source.equals(keystorePasswordField) || 
                source.equals(keyPasswordField)) {
            
            String alias = getKeystoreAlias();
            if ((alias == null) || (alias.length() == 0)) {
                ProprietarySecurityPolicyModelHelper.setKeyStoreAlias(binding, null, true);
            } else {
                ProprietarySecurityPolicyModelHelper.setKeyStoreAlias(binding, alias, true);
            }
            
            String passwd = getKeystorePassword();
            if ((passwd == null) || (passwd.length() == 0)) {
                ProprietarySecurityPolicyModelHelper.setStorePassword(binding, null, false, true);
            } else {
                ProprietarySecurityPolicyModelHelper.setStorePassword(binding, passwd, false, true);
            }

            String kpasswd = getKeyPassword();
            if ((kpasswd == null) || (kpasswd.length() == 0)) {
                ProprietarySecurityPolicyModelHelper.setKeyPassword(binding, null, true);
            } else {
                ProprietarySecurityPolicyModelHelper.setKeyPassword(binding, kpasswd, true);
            }

            String loc = getKeystorePath();
            if ((loc == null) || (loc.length() == 0)) {
                ProprietarySecurityPolicyModelHelper.setStoreType(binding, null, false, true);
                ProprietarySecurityPolicyModelHelper.setStoreLocation(binding, null, false, true);
            } else {
                ProprietarySecurityPolicyModelHelper.setStoreType(binding, KeyStore.KEYSTORE_TYPE, false, true);
                ProprietarySecurityPolicyModelHelper.setStoreLocation(binding, loc, false, true);
            }
            
            return;
        }

        if (source.equals(truststoreLocationTextField) || source.equals(trustAliasCombo) || 
                source.equals(trustPasswordField) ) {
        
            String alias = getTruststoreAlias();
            if ((alias == null) || (alias.length() == 0)) {
                ProprietarySecurityPolicyModelHelper.setTrustPeerAlias(binding, null, true);
            } else {
                ProprietarySecurityPolicyModelHelper.setTrustPeerAlias(binding, alias, true);
            }

            String passwd = getTruststorePassword();
            if ((passwd == null) || (passwd.length() == 0)) {
                ProprietarySecurityPolicyModelHelper.setStorePassword(binding, null, true, true);
            } else {
                ProprietarySecurityPolicyModelHelper.setStorePassword(binding, passwd, true, true);
            }

            String loc = getTruststorePath();
            if ((loc == null) || (loc.length() == 0)) {
                ProprietarySecurityPolicyModelHelper.setStoreType(binding, null, true, true);
                ProprietarySecurityPolicyModelHelper.setStoreLocation(binding, null, true, true);
            } else {
                ProprietarySecurityPolicyModelHelper.setStoreType(binding, KeyStore.KEYSTORE_TYPE, true, true);
                ProprietarySecurityPolicyModelHelper.setStoreLocation(binding, loc, true, true);
            }

            return;
        }
        
        enableDisable();
    }
    
    private void enableDisable() {
        
        boolean amSec = SecurityCheckerRegistry.getDefault().isNonWsitSecurityEnabled(node, jaxwsmodel);

        keyAliasLabel.setEnabled(!amSec);
        keyPasswordField.setEnabled(!amSec);
        keyPasswordLabel.setEnabled(!amSec);
        keystoreLocationButton.setEnabled(!amSec);
        keystoreLocationLabel.setEnabled(!amSec);
        keystoreLocationTextField.setEnabled(!amSec);
        keystorePasswordField.setEnabled(!amSec);
        keystorePasswordLabel.setEnabled(!amSec);
        loadKeyAliases.setEnabled(!amSec);
        loadTrustAliases.setEnabled(!amSec);
        trustAliasCombo.setEnabled(!amSec);
        trustAliasLabel.setEnabled(!amSec);
        trustPasswordField.setEnabled(!amSec);
        truststoreLocationButton.setEnabled(!amSec);
        truststoreLocationLbl.setEnabled(!amSec);
        truststoreLocationTextField.setEnabled(!amSec);
        truststorePasswordLabel.setEnabled(!amSec);
    }
    
    @Override
    public void documentChanged(javax.swing.text.JTextComponent comp, String value) {
        enableDisable();
    }

    @Override
    public void rollbackValue(javax.swing.text.JTextComponent source) {
    }
    
    @Override
    protected void endUIChange() {
    }

    public void linkButtonPressed(Object ddBean, String ddProperty) {
    }

    public javax.swing.JComponent getErrorComponent(String errorId) {
        return null;
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {

        keystoreLocationLabel = new javax.swing.JLabel();
        truststorePasswordLabel = new javax.swing.JLabel();
        truststoreLocationLbl = new javax.swing.JLabel();
        keystorePasswordLabel = new javax.swing.JLabel();
        keystoreLocationTextField = new javax.swing.JTextField();
        keystoreLocationButton = new javax.swing.JButton();
        truststoreLocationTextField = new javax.swing.JTextField();
        truststoreLocationButton = new javax.swing.JButton();
        keyAliasLabel = new javax.swing.JLabel();
        keyPasswordLabel = new javax.swing.JLabel();
        keyAliasCombo = new javax.swing.JComboBox();
        trustAliasLabel = new javax.swing.JLabel();
        trustAliasCombo = new javax.swing.JComboBox();
        keystorePasswordField = new javax.swing.JPasswordField();
        keyPasswordField = new javax.swing.JPasswordField();
        trustPasswordField = new javax.swing.JPasswordField();
        loadKeyAliases = new javax.swing.JButton();
        loadTrustAliases = new javax.swing.JButton();

        addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusGained(java.awt.event.FocusEvent evt) {
                formFocusGained(evt);
            }
        });
        addAncestorListener(new javax.swing.event.AncestorListener() {
            public void ancestorMoved(javax.swing.event.AncestorEvent evt) {
            }
            public void ancestorAdded(javax.swing.event.AncestorEvent evt) {
                formAncestorAdded(evt);
            }
            public void ancestorRemoved(javax.swing.event.AncestorEvent evt) {
            }
        });

        keystoreLocationLabel.setLabelFor(keystoreLocationTextField);
        org.openide.awt.Mnemonics.setLocalizedText(keystoreLocationLabel, org.openide.util.NbBundle.getMessage(KeystorePanel.class, "LBL_KeyStorePanel_KeyStoreLocationLabel")); // NOI18N

        truststorePasswordLabel.setLabelFor(trustPasswordField);
        org.openide.awt.Mnemonics.setLocalizedText(truststorePasswordLabel, org.openide.util.NbBundle.getMessage(KeystorePanel.class, "LBL_KeyStorePanel_TrustPasswordLabel")); // NOI18N

        truststoreLocationLbl.setLabelFor(truststoreLocationTextField);
        org.openide.awt.Mnemonics.setLocalizedText(truststoreLocationLbl, org.openide.util.NbBundle.getMessage(KeystorePanel.class, "LBL_KeyStorePanel_TrustStoreLocationLabel")); // NOI18N

        keystorePasswordLabel.setLabelFor(keystorePasswordField);
        org.openide.awt.Mnemonics.setLocalizedText(keystorePasswordLabel, org.openide.util.NbBundle.getMessage(KeystorePanel.class, "LBL_KeyStorePanel_KeystorePasswordLabel")); // NOI18N

        org.openide.awt.Mnemonics.setLocalizedText(keystoreLocationButton, org.openide.util.NbBundle.getMessage(KeystorePanel.class, "LBL_KeyStorePanel_KBrowseButton")); // NOI18N
        keystoreLocationButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                keystoreLocationButtonActionPerformed(evt);
            }
        });

        org.openide.awt.Mnemonics.setLocalizedText(truststoreLocationButton, org.openide.util.NbBundle.getMessage(KeystorePanel.class, "LBL_KeyStorePanel_TBrowseButton")); // NOI18N
        truststoreLocationButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                truststoreLocationButtonActionPerformed(evt);
            }
        });

        keyAliasLabel.setLabelFor(keyAliasCombo);
        org.openide.awt.Mnemonics.setLocalizedText(keyAliasLabel, org.openide.util.NbBundle.getMessage(KeystorePanel.class, "LBL_KeyStorePanel_KeyAliasLabel")); // NOI18N

        keyPasswordLabel.setLabelFor(keyPasswordField);
        org.openide.awt.Mnemonics.setLocalizedText(keyPasswordLabel, org.openide.util.NbBundle.getMessage(KeystorePanel.class, "LBL_KeyStorePanel_KeyPasswordLabel")); // NOI18N

        keyAliasCombo.setEditable(true);
        keyAliasCombo.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                keyAliasComboActionPerformed(evt);
            }
        });
        keyAliasCombo.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyReleased(java.awt.event.KeyEvent evt) {
                keyAliasComboKeyReleased(evt);
            }
        });

        trustAliasLabel.setLabelFor(trustAliasCombo);
        org.openide.awt.Mnemonics.setLocalizedText(trustAliasLabel, org.openide.util.NbBundle.getMessage(KeystorePanel.class, "LBL_KeyStorePanel_TrustAliasLabel")); // NOI18N

        trustAliasCombo.setEditable(true);
        trustAliasCombo.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                trustAliasComboActionPerformed(evt);
            }
        });
        trustAliasCombo.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyReleased(java.awt.event.KeyEvent evt) {
                trustAliasComboKeyReleased(evt);
            }
        });

        java.util.ResourceBundle bundle = java.util.ResourceBundle.getBundle("org/netbeans/modules/websvc/wsitconf/ui/client/Bundle"); // NOI18N
        org.openide.awt.Mnemonics.setLocalizedText(loadKeyAliases, bundle.getString("LBL_KLoadKeys")); // NOI18N
        loadKeyAliases.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                loadKeyAliasesActionPerformed(evt);
            }
        });

        org.openide.awt.Mnemonics.setLocalizedText(loadTrustAliases, bundle.getString("LBL_TLoadKeys")); // NOI18N
        loadTrustAliases.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                loadTrustAliasesActionPerformed(evt);
            }
        });

        org.jdesktop.layout.GroupLayout layout = new org.jdesktop.layout.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(layout.createSequentialGroup()
                        .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                            .add(truststorePasswordLabel)
                            .add(truststoreLocationLbl)
                            .add(trustAliasLabel))
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                            .add(org.jdesktop.layout.GroupLayout.TRAILING, layout.createSequentialGroup()
                                .add(truststoreLocationTextField, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 245, Short.MAX_VALUE)
                                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                                .add(truststoreLocationButton))
                            .add(layout.createSequentialGroup()
                                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.TRAILING, false)
                                    .add(org.jdesktop.layout.GroupLayout.LEADING, trustAliasCombo, 0, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                                    .add(org.jdesktop.layout.GroupLayout.LEADING, trustPasswordField, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 151, Short.MAX_VALUE))
                                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                                .add(loadTrustAliases)
                                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED, 74, Short.MAX_VALUE))))
                    .add(layout.createSequentialGroup()
                        .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                            .add(keystoreLocationLabel)
                            .add(keystorePasswordLabel)
                            .add(keyAliasLabel)
                            .add(keyPasswordLabel))
                        .add(22, 22, 22)
                        .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                            .add(org.jdesktop.layout.GroupLayout.TRAILING, layout.createSequentialGroup()
                                .add(keystoreLocationTextField, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 244, Short.MAX_VALUE)
                                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                                .add(keystoreLocationButton))
                            .add(layout.createSequentialGroup()
                                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.TRAILING, false)
                                    .add(org.jdesktop.layout.GroupLayout.LEADING, keyPasswordField)
                                    .add(org.jdesktop.layout.GroupLayout.LEADING, keyAliasCombo, 0, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                                    .add(org.jdesktop.layout.GroupLayout.LEADING, keystorePasswordField, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 153, Short.MAX_VALUE))
                                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                                .add(loadKeyAliases)
                                .add(71, 71, 71)))))
                .addContainerGap())
        );

        layout.linkSize(new java.awt.Component[] {keystoreLocationButton, truststoreLocationButton}, org.jdesktop.layout.GroupLayout.HORIZONTAL);

        layout.setVerticalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(keystoreLocationLabel)
                    .add(keystoreLocationButton)
                    .add(keystoreLocationTextField, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(keystorePasswordLabel)
                    .add(keystorePasswordField, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(keyAliasLabel)
                    .add(keyAliasCombo, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 20, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                    .add(loadKeyAliases))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(keyPasswordLabel)
                    .add(keyPasswordField, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .add(49, 49, 49)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(truststoreLocationLbl)
                    .add(truststoreLocationButton)
                    .add(truststoreLocationTextField, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(truststorePasswordLabel)
                    .add(trustPasswordField, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(trustAliasLabel)
                    .add(trustAliasCombo, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 21, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                    .add(loadTrustAliases))
                .addContainerGap(org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );
    }// </editor-fold>//GEN-END:initComponents

private void formAncestorAdded(javax.swing.event.AncestorEvent evt) {//GEN-FIRST:event_formAncestorAdded
    enableDisable();
}//GEN-LAST:event_formAncestorAdded

private void formFocusGained(java.awt.event.FocusEvent evt) {//GEN-FIRST:event_formFocusGained
    enableDisable();
}//GEN-LAST:event_formFocusGained

    private void trustAliasComboKeyReleased(java.awt.event.KeyEvent evt) {//GEN-FIRST:event_trustAliasComboKeyReleased
        setValue(trustAliasCombo, null);
    }//GEN-LAST:event_trustAliasComboKeyReleased

    private void trustAliasComboActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_trustAliasComboActionPerformed
        setValue(trustAliasCombo, null);
    }//GEN-LAST:event_trustAliasComboActionPerformed

    private void keyAliasComboKeyReleased(java.awt.event.KeyEvent evt) {//GEN-FIRST:event_keyAliasComboKeyReleased
        setValue(keyAliasCombo, null);
    }//GEN-LAST:event_keyAliasComboKeyReleased

    private void keyAliasComboActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_keyAliasComboActionPerformed
        setValue(keyAliasCombo, null);
    }//GEN-LAST:event_keyAliasComboActionPerformed

    private void loadTrustAliasesActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_loadTrustAliasesActionPerformed
        boolean success = reloadAliases(true);
        if (!success) {
            DialogDisplayer.getDefault().notify(
                    new NotifyDescriptor.Message(NbBundle.getMessage(KeystorePanel.class, "MSG_WrongPassword"   //NOI18N
                    )));
        }
    }//GEN-LAST:event_loadTrustAliasesActionPerformed

    private void loadKeyAliasesActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_loadKeyAliasesActionPerformed
        boolean success = reloadAliases(false);
        if (!success) {
            DialogDisplayer.getDefault().notify(
                    new NotifyDescriptor.Message(NbBundle.getMessage(KeystorePanel.class, "MSG_WrongPassword"   //NOI18N
                    )));
        }        
    }//GEN-LAST:event_loadKeyAliasesActionPerformed
    
    private void truststoreLocationButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_truststoreLocationButtonActionPerformed
        JFileChooser chooser = new JFileChooser();
        FileUtil.preventFileChooserSymlinkTraversal(chooser, null);
        chooser.setDialogTitle(NbBundle.getMessage(KeystorePanel.class, "LBL_TruststoreBrowse_Title"));
        chooser.setFileSelectionMode (JFileChooser.FILES_ONLY);
        chooser.setMultiSelectionEnabled(false);
        chooser.setFileFilter(new StoreFileFilter());
        File f = new File(truststoreLocationTextField.getText());
        File dir = null;
        if ((f != null) && (f.exists())) {
            if (f.isDirectory()) {
                chooser.setCurrentDirectory(f);
            } else {
                chooser.setCurrentDirectory(f.getParentFile());
            }
        }
        if (chooser.showOpenDialog(this)== JFileChooser.APPROVE_OPTION) {
            File file = chooser.getSelectedFile();
            if (file != null) {
                setTruststorePath(file.getPath());
                String extension = FileUtil.getExtension(file.getName());
                keystoreType = StoreFileFilter.JKS_EXT.equals(extension) ? JKS : PKCS12;
                setValue(truststoreLocationTextField, null);
            }
        }
    }//GEN-LAST:event_truststoreLocationButtonActionPerformed

    private void keystoreLocationButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_keystoreLocationButtonActionPerformed
        JFileChooser chooser = new JFileChooser();
        FileUtil.preventFileChooserSymlinkTraversal(chooser, null);
        chooser.setDialogTitle(NbBundle.getMessage(KeystorePanel.class, "LBL_KeystoreBrowse_Title"));
        chooser.setFileSelectionMode (JFileChooser.FILES_ONLY);
        chooser.setMultiSelectionEnabled(false);
        chooser.setFileFilter(new StoreFileFilter());
        File f = new File(truststoreLocationTextField.getText());
        File dir = null;
        if ((f != null) && (f.exists())) {
            if (f.isDirectory()) {
                chooser.setCurrentDirectory(f);
            } else {
                chooser.setCurrentDirectory(f.getParentFile());
            }
        }
        if (chooser.showOpenDialog(this)== JFileChooser.APPROVE_OPTION) {
            File file = chooser.getSelectedFile();
            if (file != null) {
                setKeystorePath(file.getPath());
                String extension = FileUtil.getExtension(file.getName());
                truststoreType = StoreFileFilter.JKS_EXT.equals(extension) ? JKS : PKCS12;
                setValue(keystoreLocationTextField, null);
            }
        }
    }//GEN-LAST:event_keystoreLocationButtonActionPerformed

    private boolean reloadAliases(boolean trust) {
        JComboBox combo = trust ? trustAliasCombo : keyAliasCombo;
        String path = trust ? getTruststorePath() : getKeystorePath();
        String type = trust ? truststoreType : keystoreType;
        Enumeration<String> aliases;
        try {
            aliases = Util.getAliases(path, getCharPassword(trust), truststoreType);
        } catch (IOException ex) {
            ex.printStackTrace();
            return false;
        }
        combo.removeAllItems();
        if (aliases != null) {
            combo.addItem("");  //NOI18N            
            while (aliases.hasMoreElements()){
                String alias = aliases.nextElement();
                combo.addItem(alias);
            }
            if (combo.getItemCount() > 1) {
                combo.setSelectedIndex(1);
            }
        }
        return true;
    }
        
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JComboBox keyAliasCombo;
    private javax.swing.JLabel keyAliasLabel;
    private javax.swing.JPasswordField keyPasswordField;
    private javax.swing.JLabel keyPasswordLabel;
    private javax.swing.JButton keystoreLocationButton;
    private javax.swing.JLabel keystoreLocationLabel;
    private javax.swing.JTextField keystoreLocationTextField;
    private javax.swing.JPasswordField keystorePasswordField;
    private javax.swing.JLabel keystorePasswordLabel;
    private javax.swing.JButton loadKeyAliases;
    private javax.swing.JButton loadTrustAliases;
    private javax.swing.JComboBox trustAliasCombo;
    private javax.swing.JLabel trustAliasLabel;
    private javax.swing.JPasswordField trustPasswordField;
    private javax.swing.JButton truststoreLocationButton;
    private javax.swing.JLabel truststoreLocationLbl;
    private javax.swing.JTextField truststoreLocationTextField;
    private javax.swing.JLabel truststorePasswordLabel;
    // End of variables declaration//GEN-END:variables
    
}
