/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.websvc.wsitconf.ui.service;

import javax.swing.JPanel;
import org.netbeans.modules.websvc.wsitconf.ui.ComboConstants;
import org.netbeans.modules.websvc.wsitconf.ui.service.profiles.EndorsingCertificate;
import org.netbeans.modules.websvc.wsitconf.ui.service.profiles.Generic;
import org.netbeans.modules.websvc.wsitconf.ui.service.profiles.KerberosAuthentication;
import org.netbeans.modules.websvc.wsitconf.ui.service.profiles.MessageAuthentication;
import org.netbeans.modules.websvc.wsitconf.ui.service.profiles.MutualCertificates;
import org.netbeans.modules.websvc.wsitconf.ui.service.profiles.SAMLAuthorizationOverSSL;
import org.netbeans.modules.websvc.wsitconf.ui.service.profiles.SAMLHolderOfKey;
import org.netbeans.modules.websvc.wsitconf.ui.service.profiles.STSIssued;
import org.netbeans.modules.websvc.wsitconf.ui.service.profiles.STSIssuedCert;
import org.netbeans.modules.websvc.wsitconf.ui.service.profiles.STSIssuedEndorsing;
import org.netbeans.modules.websvc.wsitconf.ui.service.profiles.SenderVouches;
import org.netbeans.modules.websvc.wsitconf.ui.service.profiles.TransportSecurity;
import org.netbeans.modules.websvc.wsitconf.ui.service.profiles.UsernameAuthentication;
import org.netbeans.modules.xml.wsdl.model.WSDLComponent;

/**
 *
 * @author MartinG
 */
public class ProfileUtil {
    
    /** Creates a new instance of ProfileUtil */
    public ProfileUtil() {
    }

    public static JPanel getProfilePanel(String profile, WSDLComponent comp) {
        if (ComboConstants.PROF_GENERIC.equals(profile)) return new Generic(comp);
        if (ComboConstants.PROF_TRANSPORT.equals(profile)) return new TransportSecurity(comp);
        if (ComboConstants.PROF_MSGAUTHSSL.equals(profile)) return new MessageAuthentication(comp);
        if (ComboConstants.PROF_SAMLSSL.equals(profile)) return new SAMLAuthorizationOverSSL(comp);
        if (ComboConstants.PROF_USERNAME.equals(profile)) return new UsernameAuthentication(comp);
        if (ComboConstants.PROF_MUTUALCERT.equals(profile)) return new MutualCertificates(comp);
        if (ComboConstants.PROF_ENDORSCERT.equals(profile)) return new EndorsingCertificate(comp);
        if (ComboConstants.PROF_SAMLSENDER.equals(profile)) return new SenderVouches(comp);
        if (ComboConstants.PROF_SAMLHOLDER.equals(profile)) return new SAMLHolderOfKey(comp);
        if (ComboConstants.PROF_KERBEROS.equals(profile)) return new KerberosAuthentication(comp);
        if (ComboConstants.PROF_STSISSUED.equals(profile)) return new STSIssued(comp);
        if (ComboConstants.PROF_STSISSUEDCERT.equals(profile)) return new STSIssuedCert(comp);
        if (ComboConstants.PROF_STSISSUEDENDORSE.equals(profile)) return new STSIssuedEndorsing(comp);
        return null;
    }

    public static String getProfileInfo(String profile) {
        if (ComboConstants.PROF_GENERIC.equals(profile)) return ComboConstants.PROF_GENERIC_INFO;
        if (ComboConstants.PROF_TRANSPORT.equals(profile)) return ComboConstants.PROF_TRANSPORT_INFO;
        if (ComboConstants.PROF_MSGAUTHSSL.equals(profile)) return ComboConstants.PROF_MSGAUTHSSL_INFO;
        if (ComboConstants.PROF_SAMLSSL.equals(profile)) return ComboConstants.PROF_SAMLSSL_INFO;
        if (ComboConstants.PROF_USERNAME.equals(profile)) return ComboConstants.PROF_USERNAME_INFO;
        if (ComboConstants.PROF_MUTUALCERT.equals(profile)) return ComboConstants.PROF_MUTUALCERT_INFO;
        if (ComboConstants.PROF_ENDORSCERT.equals(profile)) return ComboConstants.PROF_ENDORSCERT_INFO;
        if (ComboConstants.PROF_SAMLSENDER.equals(profile)) return ComboConstants.PROF_SAMLSENDER_INFO;
        if (ComboConstants.PROF_SAMLHOLDER.equals(profile)) return ComboConstants.PROF_SAMLHOLDER_INFO;
        if (ComboConstants.PROF_KERBEROS.equals(profile)) return ComboConstants.PROF_KERBEROS_INFO;
        if (ComboConstants.PROF_STSISSUED.equals(profile)) return ComboConstants.PROF_STSISSUED_INFO;
        if (ComboConstants.PROF_STSISSUEDCERT.equals(profile)) return ComboConstants.PROF_STSISSUEDCERT_INFO;
        if (ComboConstants.PROF_STSISSUEDENDORSE.equals(profile)) return ComboConstants.PROF_STSISSUEDENDORSE_INFO;
        return null;
    }    
}
