/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.websvc.wsitconf.ui.service.profiles;

import org.netbeans.modules.websvc.wsitconf.ui.ComboConstants;
import org.netbeans.modules.xml.multiview.ui.SectionVisualTheme;
import org.netbeans.modules.xml.wsdl.model.WSDLComponent;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;

/**
 *
 * @author  Martin Grebac
 */
public class Generic extends javax.swing.JPanel implements ComboConstants {

    private boolean inSync = false;

    private WSDLComponent comp;
    private WSDLModel model;
    
    /**
     * Creates new form Generic
     */
    public Generic(WSDLComponent comp) {
        super();
        initComponents();
        this.model = comp.getModel();
        this.comp = comp;

        algoSuiteCombo.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        algoSuiteLabel.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        authTokenCombo.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        authTokenLabel.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        confidentCombo.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        confidentLabel.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        integrityCombo.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        integrityLabel.setBackground(SectionVisualTheme.getDocumentBackgroundColor());

        layoutLabel.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        layoutCombo.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        wssVersionLabel.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        wssVersionCombo.setBackground(SectionVisualTheme.getDocumentBackgroundColor());

        derivedKeysChBox.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        encryptOrderChBox.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        entireSignChBox.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        protectTokenChBox.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        secConvChBox.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        timestampChBox.setBackground(SectionVisualTheme.getDocumentBackgroundColor());

        inSync = true;
        layoutCombo.removeAllItems();
        layoutCombo.addItem(ComboConstants.STRICT);
        layoutCombo.addItem(ComboConstants.LAX);
        layoutCombo.addItem(ComboConstants.LAXTSFIRST);
        layoutCombo.addItem(ComboConstants.LAXTSLAST);
        
        confidentCombo.removeAllItems();
        confidentCombo.addItem(ComboConstants.NONE);
        confidentCombo.addItem(ComboConstants.RANDOMSYMMETRIC_KEYS);
        confidentCombo.addItem(ComboConstants.ISSUEDSYMMETRIC_KEYS);
        confidentCombo.addItem(ComboConstants.TRANSPORTPROTECTION);

        integrityCombo.removeAllItems();
        integrityCombo.addItem(ComboConstants.NONE);
        integrityCombo.addItem(ComboConstants.ASSYMETRIC_KEYS);
        integrityCombo.addItem(ComboConstants.RANDOMSYMMETRIC_KEYS);
        integrityCombo.addItem(ComboConstants.ISSUEDSYMMETRIC_KEYS);

        wssVersionCombo.removeAllItems();
        wssVersionCombo.addItem(ComboConstants.WSS10);
        wssVersionCombo.addItem(ComboConstants.WSS11);

        algoSuiteCombo.removeAllItems();
        algoSuiteCombo.addItem(ComboConstants.BASIC256);
        algoSuiteCombo.addItem(ComboConstants.BASIC192);
        algoSuiteCombo.addItem(ComboConstants.BASIC128);
        algoSuiteCombo.addItem(ComboConstants.TRIPLEDES);
        algoSuiteCombo.addItem(ComboConstants.BASIC256RSA15);
        algoSuiteCombo.addItem(ComboConstants.BASIC192RSA15);
        algoSuiteCombo.addItem(ComboConstants.BASIC128RSA15);
        algoSuiteCombo.addItem(ComboConstants.TRIPLEDESRSA15);
//        algoSuiteCombo.addItem(ComboConstants.BASIC256SHA256);
//        algoSuiteCombo.addItem(ComboConstants.BASIC192SHA256);
//        algoSuiteCombo.addItem(ComboConstants.BASIC128SHA256);
//        algoSuiteCombo.addItem(ComboConstants.TRIPLEDESSHA256);
//        algoSuiteCombo.addItem(ComboConstants.BASIC256SHA256RSA15);
//        algoSuiteCombo.addItem(ComboConstants.BASIC192SHA256RSA15);
//        algoSuiteCombo.addItem(ComboConstants.BASIC128SHA256RSA15);
//        algoSuiteCombo.addItem(ComboConstants.TRIPLEDESSHA256RSA15);

        authTokenCombo.removeAllItems();
        authTokenCombo.addItem(ComboConstants.NONE);
        authTokenCombo.addItem(ComboConstants.USERNAME);
        authTokenCombo.addItem(ComboConstants.X509);
        authTokenCombo.addItem(ComboConstants.SAML);
        authTokenCombo.addItem(ComboConstants.ISSUED);
        authTokenCombo.addItem(ComboConstants.HTTPS);
        authTokenCombo.addItem(ComboConstants.KERBEROS);

        inSync = false;
        
        sync();
    }
    
    private void sync() {
        inSync = true;


        inSync = false;
    }

    public void setValue(javax.swing.JComponent source, Object value) {

        if (!inSync) {
//            if (source.equals(inclusionLevelCombo)) {
//                SecurityTokensModelHelper.setTokenInclusionLevel(tokenType, (String)inclusionLevelCombo.getSelectedItem());
////                setter.setDirty();
//                return;
//            }
//
//            if (source.equals(requireDerivedKeysChBox)) {
//                boolean enable = requireDerivedKeysChBox.isSelected();
//                if (SecurityPolicyModelHelper.isAttributeEnabled((ExtensibilityElement) tokenType, RequireDerivedKeys.class) != enable) {
//                    SecurityPolicyModelHelper.enableRequireDerivedKeys(tokenType, enable);
////                    setter.setDirty();
//                }
//                return;
//            }
        }
    }

    
    private void setRequireDerivedKeys(Boolean enable) {
        if (enable == null) {
            this.derivedKeysChBox.setSelected(false);
        } else {
            this.derivedKeysChBox.setSelected(enable);
        }
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {

        authTokenLabel = new javax.swing.JLabel();
        authTokenCombo = new javax.swing.JComboBox();
        integrityLabel = new javax.swing.JLabel();
        integrityCombo = new javax.swing.JComboBox();
        secConvChBox = new javax.swing.JCheckBox();
        timestampChBox = new javax.swing.JCheckBox();
        protectTokenChBox = new javax.swing.JCheckBox();
        entireSignChBox = new javax.swing.JCheckBox();
        derivedKeysChBox = new javax.swing.JCheckBox();
        confidentLabel = new javax.swing.JLabel();
        confidentCombo = new javax.swing.JComboBox();
        algoSuiteLabel = new javax.swing.JLabel();
        algoSuiteCombo = new javax.swing.JComboBox();
        layoutLabel = new javax.swing.JLabel();
        layoutCombo = new javax.swing.JComboBox();
        wssVersionLabel = new javax.swing.JLabel();
        wssVersionCombo = new javax.swing.JComboBox();
        encryptOrderChBox = new javax.swing.JCheckBox();

        authTokenLabel.setText(org.openide.util.NbBundle.getMessage(Generic.class, "LBL_AuthToken")); // NOI18N

        integrityLabel.setText(org.openide.util.NbBundle.getMessage(Generic.class, "LBL_IntegrityLabel")); // NOI18N

        secConvChBox.setText(org.openide.util.NbBundle.getMessage(Generic.class, "LBL_SecConvLabel")); // NOI18N
        secConvChBox.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
        secConvChBox.setMargin(new java.awt.Insets(0, 0, 0, 0));

        timestampChBox.setText(org.openide.util.NbBundle.getMessage(Generic.class, "LBL_IncludeTimestamp")); // NOI18N
        timestampChBox.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
        timestampChBox.setMargin(new java.awt.Insets(0, 0, 0, 0));

        protectTokenChBox.setText(org.openide.util.NbBundle.getMessage(Generic.class, "LBL_ProtectTokenLabel")); // NOI18N
        protectTokenChBox.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
        protectTokenChBox.setMargin(new java.awt.Insets(0, 0, 0, 0));

        entireSignChBox.setText(org.openide.util.NbBundle.getMessage(Generic.class, "LBL_EntireSignLabel")); // NOI18N
        entireSignChBox.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
        entireSignChBox.setMargin(new java.awt.Insets(0, 0, 0, 0));

        derivedKeysChBox.setText(org.openide.util.NbBundle.getMessage(Generic.class, "LBL_RequireDerivedKeys")); // NOI18N
        derivedKeysChBox.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
        derivedKeysChBox.setMargin(new java.awt.Insets(0, 0, 0, 0));

        confidentLabel.setText(org.openide.util.NbBundle.getMessage(Generic.class, "LBL_ConfidentialityLabel")); // NOI18N

        algoSuiteLabel.setText(org.openide.util.NbBundle.getMessage(Generic.class, "LBL_AlgoSuiteLabel")); // NOI18N

        layoutLabel.setText(org.openide.util.NbBundle.getMessage(Generic.class, "LBL_LayoutLabel")); // NOI18N

        wssVersionLabel.setText(org.openide.util.NbBundle.getMessage(Generic.class, "LBL_WSSVersionLabel")); // NOI18N

        encryptOrderChBox.setText(org.openide.util.NbBundle.getMessage(Generic.class, "LBL_EncryptOrderLabel")); // NOI18N
        encryptOrderChBox.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
        encryptOrderChBox.setMargin(new java.awt.Insets(0, 0, 0, 0));

        org.jdesktop.layout.GroupLayout layout = new org.jdesktop.layout.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(layout.createSequentialGroup()
                        .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                            .add(authTokenLabel)
                            .add(integrityLabel)
                            .add(confidentLabel)
                            .add(algoSuiteLabel)
                            .add(layoutLabel)
                            .add(wssVersionLabel))
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING, false)
                            .add(algoSuiteCombo, 0, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                            .add(integrityCombo, 0, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                            .add(confidentCombo, 0, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                            .add(layoutCombo, 0, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                            .add(wssVersionCombo, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                            .add(authTokenCombo, 0, 144, Short.MAX_VALUE)))
                    .add(secConvChBox)
                    .add(derivedKeysChBox)
                    .add(timestampChBox)
                    .add(protectTokenChBox)
                    .add(entireSignChBox)
                    .add(encryptOrderChBox))
                .addContainerGap(org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        layout.linkSize(new java.awt.Component[] {algoSuiteCombo, authTokenCombo, confidentCombo, integrityCombo, layoutCombo, wssVersionCombo}, org.jdesktop.layout.GroupLayout.HORIZONTAL);

        layout.setVerticalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(authTokenLabel)
                    .add(authTokenCombo, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(integrityLabel)
                    .add(integrityCombo, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(confidentLabel)
                    .add(confidentCombo, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(algoSuiteLabel)
                    .add(algoSuiteCombo, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(layoutLabel)
                    .add(layoutCombo, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(wssVersionLabel)
                    .add(wssVersionCombo, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(secConvChBox)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(derivedKeysChBox)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(timestampChBox)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(protectTokenChBox)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(entireSignChBox)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(encryptOrderChBox)
                .addContainerGap(org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        layout.linkSize(new java.awt.Component[] {algoSuiteCombo, authTokenCombo, confidentCombo, integrityCombo, layoutCombo, wssVersionCombo}, org.jdesktop.layout.GroupLayout.VERTICAL);

    }// </editor-fold>//GEN-END:initComponents
            
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JComboBox algoSuiteCombo;
    private javax.swing.JLabel algoSuiteLabel;
    private javax.swing.JComboBox authTokenCombo;
    private javax.swing.JLabel authTokenLabel;
    private javax.swing.JComboBox confidentCombo;
    private javax.swing.JLabel confidentLabel;
    private javax.swing.JCheckBox derivedKeysChBox;
    private javax.swing.JCheckBox encryptOrderChBox;
    private javax.swing.JCheckBox entireSignChBox;
    private javax.swing.JComboBox integrityCombo;
    private javax.swing.JLabel integrityLabel;
    private javax.swing.JComboBox layoutCombo;
    private javax.swing.JLabel layoutLabel;
    private javax.swing.JCheckBox protectTokenChBox;
    private javax.swing.JCheckBox secConvChBox;
    private javax.swing.JCheckBox timestampChBox;
    private javax.swing.JComboBox wssVersionCombo;
    private javax.swing.JLabel wssVersionLabel;
    // End of variables declaration//GEN-END:variables
    
}
