/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.websvc.wsitconf.ui.service.subpanels;

import org.netbeans.modules.websvc.wsitconf.ui.security.listmodels.MessageHeader;

/**
 *
 * @author  Martin Grebac
 */
public class AddHeaderPanel extends javax.swing.JPanel {
    
    /**
     * Creates new form AddHeaderPanel
     */
    public AddHeaderPanel() {
        super();
        initComponents();

        headerCombo.addItem(MessageHeader.ADDRESSING_TO);
        headerCombo.addItem(MessageHeader.ADDRESSING_FROM);
        headerCombo.addItem(MessageHeader.ADDRESSING_FAULTTO);
        headerCombo.addItem(MessageHeader.ADDRESSING_REPLYTO);
        headerCombo.addItem(MessageHeader.ADDRESSING_MESSAGEID);
        headerCombo.addItem(MessageHeader.ADDRESSING_RELATESTO);
        headerCombo.addItem(MessageHeader.ADDRESSING_ACTION);

        headerCombo.addItem(MessageHeader.RM_ACKREQUESTED);
        headerCombo.addItem(MessageHeader.RM_SEQUENCEACK);
        headerCombo.addItem(MessageHeader.RM_SEQUENCE);
    }
    
    public boolean isAllHeaders() {
        return allHeadersChBox.isSelected();
    }

    public String getHeader() {
        return (String)headerCombo.getSelectedItem();
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {
        headerLabel = new javax.swing.JLabel();
        headerCombo = new javax.swing.JComboBox();
        allHeadersChBox = new javax.swing.JCheckBox();

        headerLabel.setText(org.openide.util.NbBundle.getMessage(AddHeaderPanel.class, "LBL_AddHeader_HeaderLabel")); // NOI18N

        allHeadersChBox.setText(org.openide.util.NbBundle.getMessage(AddHeaderPanel.class, "LBL_AllHeaders")); // NOI18N
        allHeadersChBox.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
        allHeadersChBox.setMargin(new java.awt.Insets(0, 0, 0, 0));
        allHeadersChBox.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                allHeadersChBoxActionPerformed(evt);
            }
        });

        org.jdesktop.layout.GroupLayout layout = new org.jdesktop.layout.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(headerLabel)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(headerCombo, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(allHeadersChBox)
                .addContainerGap(112, Short.MAX_VALUE))
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(headerLabel)
                    .add(headerCombo, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                    .add(allHeadersChBox))
                .addContainerGap(org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );
    }// </editor-fold>//GEN-END:initComponents

    private void allHeadersChBoxActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_allHeadersChBoxActionPerformed
        headerCombo.setEnabled(!allHeadersChBox.isSelected());
    }//GEN-LAST:event_allHeadersChBoxActionPerformed
            
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JCheckBox allHeadersChBox;
    private javax.swing.JComboBox headerCombo;
    private javax.swing.JLabel headerLabel;
    // End of variables declaration//GEN-END:variables
    
}
