/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.xml.catalog;

import java.awt.*;
import java.beans.*;

import javax.swing.*;
import javax.swing.event.*;

/**
 * Panel for selecting catalog providers showing customizer for selected one.
 *
 * @author  Petr Kuzel
 */
final class CatalogMounterPanel extends javax.swing.JPanel implements ChangeListener {

    /** Serial Version UID */
    private static final long serialVersionUID =-1208422697106159058L;    

    private CatalogMounterModel model;
    
    /** Creates new form CatalogMounterPanel */
    public CatalogMounterPanel(CatalogMounterModel model) {
        this.model = model;
        initComponents();
        initAccessibility();
        this.catalogLabel.setDisplayedMnemonic(Util.THIS.getChar("CatalogMounterPanel.catalogLabel.mne")); // NOI18N
                
        catalogComboBox.setModel(model.getCatalogComboBoxModel());
        updateCatalogPanel();
        
        model.addChangeListener(this);
    }

    /**
     * Compute preffered dimension for combo with
     * particulal number of columns
     */
    private Dimension comboSize(int columns) {
        JTextField template = new JTextField();
        template.setColumns(columns);
        return template.getPreferredSize();
    }
    
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        java.awt.GridBagConstraints gridBagConstraints;

        catalogLabel = new javax.swing.JLabel();
        catalogComboBox = new javax.swing.JComboBox();
        parentPanel = new javax.swing.JPanel();

        setLayout(new java.awt.GridBagLayout());

        setBorder(new javax.swing.border.EmptyBorder(new java.awt.Insets(4, 4, 4, 4)));
        setMinimumSize(new java.awt.Dimension(380, 100));
        catalogLabel.setText(Util.THIS.getString ("CatalogMounterPanel.catalogLabel.text"));
        catalogLabel.setLabelFor(catalogComboBox);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(12, 12, 0, 0);
        add(catalogLabel, gridBagConstraints);

        catalogComboBox.setPreferredSize(comboSize(40));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(12, 12, 0, 11);
        add(catalogComboBox, gridBagConstraints);

        parentPanel.setLayout(new java.awt.BorderLayout());

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.gridheight = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(12, 12, 0, 11);
        add(parentPanel, gridBagConstraints);

    }//GEN-END:initComponents

    private void updateCatalogPanel() {
        Customizer cust = model.getCatalogCustomizer();
        cust.setObject(model.getCatalog());
        invalidate();
        parentPanel.removeAll();
        Component catalogPanel = (Component) cust;
        parentPanel.add(catalogPanel, BorderLayout.CENTER);
        validate();
    }
    
    public void stateChanged(ChangeEvent e) {
        updateCatalogPanel();
    }

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JComboBox catalogComboBox;
    private javax.swing.JLabel catalogLabel;
    private javax.swing.JPanel parentPanel;
    // End of variables declaration//GEN-END:variables

    private void initAccessibility(){
        catalogComboBox.getAccessibleContext().setAccessibleDescription(Util.THIS.getString("ACSD_catalogComboBox"));
        this.getAccessibleContext().setAccessibleName(Util.THIS.getString("ACSN_CatalogMounterPanel"));
        this.getAccessibleContext().setAccessibleDescription(Util.THIS.getString("ACSD_CatalogMounterPanel"));
        
    }
    
}
