/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.xml.api.cookies;

import javax.swing.DefaultComboBoxModel;
import org.openide.filesystems.FileObject;
import org.openide.nodes.Node;

/**
 * A cookie for objects which want to support scenarios
 *
 * @author  asgeir@dimonsoftware.com
 * @deprecated Experimantal SPI
 */
public interface ScenarioCookie extends Node.Cookie {
    
    /**
     * Displays the Customize scenarios dialog
     * @return true if the Customize dialog was pressed with the OK button,
     *         but false if it was closed with the Cancel button.
     */
    public boolean customizeScenarios();
    
    /**
     * Returns the ComboBoxModel that represents the a list of scenarios.
     * The active scenario is the selected item in that ComboBoxModel
     * @return The ComboBoxModel that represents the a list of scenarios.
     *         The active scenario is the selected item in that ComboBoxModel. 
     */
    public DefaultComboBoxModel getModel();
    
    /**
     * Executes an object using the active scenario.
     * If no scenario is active, the Customize scenarios dialog is displayed
     * before execution.
     */
    public void executeActiveScenario();
}
