/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.xml.api.scenario;

import javax.swing.event.ChangeListener;
import java.beans.PropertyChangeListener;
import org.openide.loaders.DataObject;

/**
 * <p>
 * All scenarios should implement this interface.
 * A scenario implementation is created by a ScenarioFactory.
 * </p>
 * <p><b>NOTE:</b></p>
 * <ul>
 * <li>All implementations are required to be serializable.</li>
 * <li>The toString() method of an implementation should return the name property
 *     of this scenario</li>
 * </ul>
 *
 * @author  asgeir@dimonsoftware.com
 * @deprecated Experimantal SPI
 */
public interface Scenario {
    
    public static final String PROP_SCENARIO_MODIFIED = "SCENARIO_MODIFIED";
    
    /**
     * Registers PropertyChangeListener to receive events.
     * @param listener The listener to register.
     */
    public void addPropertyChangeListener(PropertyChangeListener listener);
    
    /**
     * Removes PropertyChangeListener from the list of listeners.
     * @param listener The listener to remove.
     */
    public void removePropertyChangeListener(PropertyChangeListener listener);
    
    /**
     * This method returns the a UI component which can be used to
     * customize this scenario.  To update changes done in the UI panel,
     * the saveChanges() method can be called.
     * A new or initialized instance of Component should be returned every
     * time this method is called.
     * @param dataObject The DataObject which owns this scenario
     * @param activatePropertyChange a flag that determines if PropertyChangeEvents are fired
     * @return A Component which can be used to customize this scenario
     */
    public java.awt.Component getCustomizer(DataObject dataObject, boolean activatePropertyChange);
    
    /**
     * Executes the DataObject using this scenario.
     * @param dataObject the DataObject to execute.
     */
    public void execute(DataObject dataObject);
    
    /**
     * Get the name of this scenario
     * @return The name of this scenario
     */
    public String getName();
    
    /**
     * Set the name of this scenario
     * @param name The name of this scenario
     */
    public void setName(String name);
    
    /**
     * Update this scenario with changes done by the last UI
     * component returned by the getUIComponent() method.
     */
    public void saveChanges();
    
}
