/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.xml.core;

import org.openide.filesystems.*;
import org.openide.loaders.*;
import org.openide.cookies.*;
import org.openide.actions.*;
import org.openide.util.*;
import org.openide.util.actions.*;
import org.openide.nodes.*;
import org.openide.windows.CloneableOpenSupport;

import org.netbeans.modules.xml.core.text.TextEditorSupport;
import org.netbeans.modules.xml.core.sync.*;
import org.netbeans.modules.xml.core.cookies.*;

import org.xml.sax.*;

import org.netbeans.spi.xml.cookies.*;
import org.xml.sax.InputSource;

/** 
 * Implementation that provides main functionality for DTD data object.
 *
 * @author Libor Kramolis
 * @author Petr Kuzel
 */
public final class DTDDataObject extends MultiDataObject implements XMLDataObjectLook {

    /** generated Serialized Version UID */
    private static final long serialVersionUID = 2890472952957502631L;
        
    /** Default DTD MIME type. */
    public static final String MIME_TYPE = "application/xml-dtd"; // http://www.ietf.org/rfc/rfc3023.txt // NOI18N

    /** Delegate sync support */
    private final DTDSyncSupport sync;
    
    /** Cookie Manager */
    private final DataObjectCookieManager cookieManager;

    
    //
    // init
    //

    public DTDDataObject (final FileObject obj, final UniFileLoader loader) throws DataObjectExistsException {
        super (obj, loader);
                
//??? controller        getPrimaryFile().addFileChangeListener (new FileListener ());
        
        CookieSet set = getCookieSet();
        set.add (cookieManager = new DataObjectCookieManager (this, set));
        
        sync = new DTDSyncSupport(this);
        
        TextEditorSupport.TextEditorSupportFactory editorFactory =
            TextEditorSupport.findEditorSupportFactory (this, MIME_TYPE);
        editorFactory.registerCookies (set);

        InputSource in = DataObjectAdapters.inputSource(this);
        set.add(new CheckXMLSupport(in, CheckXMLSupport.CHECK_PARAMETER_ENTITY_MODE));

        //??? This strange line registers updater of mu cookie set
        new CookieManager (this, set, DTDCookieFactoryCreator.class);
    }

//     // from XMLDataObjectLook
//     public void updateTextDocument () {
//         EditorCookie es = (EditorCookie)getCookie (EditorCookie.class);
//         if (es != null) {
//             es.close();
//         }
//     }


    /**
     */
    protected Node createNodeDelegate () {
        if ( Util.THIS.isLoggable() ) /* then */ Util.THIS.debug ("--> DTDDataObject.createNodeDelegate: this = " + this);

        DataNodeCreator dataNodeCreator = (DataNodeCreator) Lookup.getDefault().lookup (DataNodeCreator.class);
        DataNode dataNode = null;

        if ( Util.THIS.isLoggable() ) /* then */ Util.THIS.debug ("-*- DTDD   O     .createNodeDelegate: dataNodeCreator = " + dataNodeCreator);

        if ( dataNodeCreator != null ) {
            dataNode = dataNodeCreator.createDataNode (this);
        } else {
            dataNode = new DTDDataNode (this);
        }

        if ( Util.THIS.isLoggable() ) /* then */ Util.THIS.debug ("<-- DTDDataObject.createNodeDelegate: dataNode = " + dataNode);

        return dataNode;
    }

    /** @return provider of sync interface.  */
    public Synchronizator getSyncInterface() {
        return sync;
    }

    // ~~~~~~~~~~~~~~~~~ COOKIES ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~`


    /** Synchronize and delegate to super. */
    public Node.Cookie getCookie(Class klass) {

        Node.Cookie cake = null;
        boolean change = false;

        // take lock to prevent deadlock on cookie set that can be called
        // from other thred during cookie removal
        synchronized (this) {
            cake = super.getCookie (klass);

            if ( ( cake == null ) &&
                 ( CloneableOpenSupport.class == klass ) ) { //!!! HACK -- backward compatibility
                cake = super.getCookie (OpenCookie.class);
            }
        }
                
        if ( Util.THIS.isLoggable() ) /* then */ Util.THIS.debug ("DTD cookie query " + klass + " => " + cake); // NOI18N

        return cake;
    }
    
    
    public DataObjectCookieManager getCookieManager () {
        return cookieManager;
    }
    

    public HelpCtx getHelpCtx() {
        //return new HelpCtx(DTDDataObject.class);
        return HelpCtx.DEFAULT_HELP;
    }
        

    //
    // class DTDDataNode
    //

    /**
     *
     */
    private static class DTDDataNode extends DataNode {

        /** Create new DTDDataNode. */
        public DTDDataNode (DTDDataObject obj) {
            super (obj, Children.LEAF);

            setDefaultAction (SystemAction.get (EditAction.class));
            setIconBase ("org/netbeans/modules/xml/core/resources/dtdObject"); // NOI18N
            setShortDescription (Util.THIS.getString ("PROP_DTDDataNode_description"));
        }

        public HelpCtx getHelpCtx() {
            //return new HelpCtx(DTDDataObject.class);
            return HelpCtx.DEFAULT_HELP;
        }
        
    } // end of class DTDDataNode



    //
    // interface DataNodeCreator
    //

    /**
     *
     */
    public static interface DataNodeCreator {

        /**
         */
        public DataNode createDataNode (DTDDataObject dtdDO);

    } // end of interface DataNodeCreator



    //
    // interface DTDCookieFactoryCreator
    //

    /**
     *
     */
    public static interface DTDCookieFactoryCreator extends CookieFactoryCreator {
        
    } // end: interface DTDCookieFactoryCreator

}
