/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.xml.core;

import java.io.IOException;

import org.openide.loaders.UniFileLoader;
import org.openide.loaders.MultiDataObject;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.ExtensionList;
import org.openide.filesystems.FileObject;
import org.openide.actions.*;
import org.openide.util.actions.SystemAction;

import org.netbeans.modules.xml.core.actions.CheckEntityAction;

/** Data loader which recognizes .ent files - XML Entity documents.
 * MIME Type - text/xml-external-parsed-entity
 *   (http://www.ietf.org/rfc/rfc3023.txt)
 *
 * @author  Libor Kramolis
 * @version 0.1
 */
public final class EntityDataLoader extends UniFileLoader {
    /** Serial Version UID */
    private static final long serialVersionUID = -5201160056633250635L;
    
    /** */
    private static final String ENT_EXT = "ent"; // NOI18N


    /** Creates new EntityDataLoader */
    public EntityDataLoader() {
        super ("org.netbeans.modules.xml.core.EntityDataObject"); // NOI18N
    }

    /** Does initialization. Initializes display name,
     * extension list and the actions. */
    protected void initialize () {
        super.initialize();
        
        ExtensionList ext = getExtensions();
        ext.addExtension (ENT_EXT);
        ext.addMimeType (EntityDataObject.MIME_TYPE);
        ext.addMimeType ("application/xml-external-parsed-entity"); // http://www.ietf.org/rfc/rfc3023.txt // NOI18N
        setExtensions (ext);
    }
    
    protected String actionsContext() {
        return "Loaders/text/xml-external-parsed-entity/Actions/";
    }
    
    /**
     * Lazy init name.
     */
    protected String defaultDisplayName () {
        return Util.THIS.getString ("PROP_EntityLoader_Name");
    }
    
    /** Creates the right primary entry for given primary file.
     *
     * @param primaryFile primary file recognized by this loader
     * @return primary entry for that file
     */
    protected MultiDataObject.Entry createPrimaryEntry (MultiDataObject obj, FileObject primaryFile) {
        return new XMLDataLoader.XMLFileEntry (obj, primaryFile);  //adds smart templating
    }

    /** Creates the right data object for given primary file.
     * It is guaranteed that the provided file is realy primary file
     * returned from the method findPrimaryFile.
     *
     * @param primaryFile the primary file
     * @return the data object for this file
     * @exception DataObjectExistsException if the primary file already has data object
     */
    protected MultiDataObject createMultiObject (FileObject primaryFile)
            throws DataObjectExistsException, java.io.IOException {
        return new EntityDataObject (primaryFile, this);
    }

}
