/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.xml.core.cookies;

import java.util.Map;
import java.util.HashMap;
import java.util.Collection;
import java.util.Iterator;

import org.openide.nodes.CookieSet;
import org.openide.loaders.DataObject;

import org.netbeans.modules.xml.core.lib.LookupManager;

/**
 * @author Libor Kramolis
 * @version 0.1
 */
public final class CookieManager extends LookupManager {
    /** */
    private final DataObject dataObject;
    /** */
    private final CookieSet cookieSet;
    /** */
    private final Map factoryMap;


    //
    // init
    //

    /**
     */
    public CookieManager (DataObject dataObject, CookieSet cookieSet, Class clazz) {        
        if ( CookieFactoryCreator.class.isAssignableFrom (clazz) == false ) {
            throw new IllegalArgumentException ("Parameter class must extend CookieFactoryCreator class.");
        }

        this.dataObject = dataObject;
        this.cookieSet  = cookieSet;
        this.factoryMap = new HashMap();

        register (clazz);

        addedToResult (getResult());
    }


    //
    // itself
    //

    /**
     */
    protected void removedFromResult (Collection removed) {
        Iterator it = removed.iterator();
        while ( it.hasNext() ) {
            CookieFactoryCreator creator = (CookieFactoryCreator) it.next();
            CookieFactory factory = (CookieFactory) this.factoryMap.remove (creator);
            if ( factory != null ) {
                factory.unregisterCookies (this.cookieSet);
            }
        }
    }

    /**
     */
    protected void addedToResult (Collection added) {
        //??? is getResult() meant here (rather than added)?

        Iterator it = getResult().iterator();
        while ( it.hasNext() ) {
            CookieFactoryCreator creator = (CookieFactoryCreator) it.next();
            CookieFactory factory = creator.createCookieFactory (this.dataObject);
            if ( factory != null ) {
                this.factoryMap.put (creator, factory);
                factory.registerCookies (this.cookieSet);
            }
        }
    }

}
