/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.xml.core.lib;

import java.io.*;
import java.util.*;

import org.openide.filesystems.*;
import org.openide.filesystems.FileSystem;

/**
 * This file object represents an InputStream.
 *
 * @author  Petr Kuzel
 * @version untested draft
 */
public class StreamFileObject extends FileObject {

    /** Serial Version UID */
    private static final long serialVersionUID =8966806836211837503L;


    private org.openide.filesystems.FileObject[] files; //kids
    
    private boolean isRoot; //does it represent folder (root);
    
    private InputStream peer; //wrapped input stream
    
    private FileSystem fs;
    
    
    //my filesystem
    
    /** Creates new StreamFileObject */
    public StreamFileObject(InputStream in) {
        this(in, false);
    }
    
    public StreamFileObject(InputStream in, boolean isRoot) {
        this.isRoot = isRoot;
        peer = in;
        if (isRoot) {
            files = new org.openide.filesystems.FileObject[] {
                new StreamFileObject(in)
            };
        } else {
            files = new org.openide.filesystems.FileObject[0];
        }
        fs = new StreamFileSystem(this);
    }

    public org.openide.filesystems.FileObject[] getChildren() {
        return files;
    }
    
    public void removeFileChangeListener(org.openide.filesystems.FileChangeListener fileChangeListener) {
    }
    
    public org.openide.filesystems.FileLock lock() throws java.io.IOException {
        return FileLock.NONE;
    }
    
    public java.lang.Object getAttribute(java.lang.String str) {
        return null;
    }
    
    public java.util.Date lastModified() {
        return new Date(0L);
    }
    
    public java.lang.String getExt() {
        return "InputStream"; // NOI18N
    }
    
    public boolean isReadOnly() {
        return true;
    }
    
    public org.openide.filesystems.FileObject createData(java.lang.String str, java.lang.String str1) throws java.io.IOException {
        return null;
    }
    
    public void delete(org.openide.filesystems.FileLock fileLock) throws java.io.IOException {
    }
    
    public org.openide.filesystems.FileObject createFolder(java.lang.String str) throws java.io.IOException {
        return null;
    }
    
    public void rename(org.openide.filesystems.FileLock fileLock, java.lang.String str, java.lang.String str2) throws java.io.IOException {        
    }
    
    public boolean isData() {
        return isRoot == false; 
    }
    
    public java.io.OutputStream getOutputStream(org.openide.filesystems.FileLock fileLock) throws java.io.IOException {
        throw new IOException("r/o"); // NOI18N
    }
    
    public java.io.InputStream getInputStream() throws java.io.FileNotFoundException {
        return peer;
    }
    
    public boolean isValid() {
        return true;
    }
    
    public java.util.Enumeration getAttributes() {
        return org.openide.util.Enumerations.empty();
    }
    
    public java.lang.String getName() {
        return "StreamFileObject"; // NOI18N
    }
    
    public void setImportant(boolean param) {
    }
    
    public boolean isFolder() {
        return isRoot;
    }
    
    public void setAttribute(java.lang.String str, java.lang.Object obj) throws java.io.IOException {
    }
    
    public void addFileChangeListener(org.openide.filesystems.FileChangeListener fileChangeListener) {
    }
    
    public long getSize() {
        return 766; //!!!
    }
    
    public org.openide.filesystems.FileObject getParent() {
        if (isRoot) return null;
        return fs.getRoot();
    }
    
    public boolean isRoot() {
        return isRoot;
    }
    
    public org.openide.filesystems.FileObject getFileObject(java.lang.String str, java.lang.String str1) {
        return null;
    }
    
    public org.openide.filesystems.FileSystem getFileSystem() throws org.openide.filesystems.FileStateInvalidException {
        return fs;
    }
    
}
