/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.xml.core.settings;

import java.io.Serializable;
import java.util.List;
import java.util.ArrayList;


import org.openide.ServiceType;
import org.openide.options.SystemOption;
import org.openide.util.SharedClassObject;
import org.openide.util.io.ReaderInputStream;
import org.openide.util.HelpCtx;
import org.openide.util.actions.SystemAction;

/** Settings for xml module
 *
 * @author  Libor Kramolis
 * @version 0.2
 */
public class CoreSettings extends SystemOption {
    /** Serial Version UID */
    private static final long serialVersionUID = 45650374856L;
    
    /** */
    private static CoreSettings defaultSettings = null;

    /** */
    public static final String PROP_AUTO_PARSING_DELAY = "autoParsingDelay"; // NOI18N
    /** auto parsing delay */
    private static int autoParsingDelay = 3000;

    /** Name of default action property. */
    public static final String PROP_DEFAULT_ACTION = "defaultAction";  // NOI18N
    
    /** Holds value of property defaultAction. */
    private static String defaultAction;

    public static final String PROP_PREFERED_SHORT_EMPTY_ELEMENT = "shortEmptyElement";  // NOI18N
    
    /** Holds value of property preferedShortEmptyElement. */
    private static boolean shortEmptyElement;
    
    //
    // init
    //
    
    /** */
    public static CoreSettings getDefault () {
        if (defaultSettings == null)
            defaultSettings = (CoreSettings) SharedClassObject.findObject (CoreSettings.class, true);
        return defaultSettings;
    }

    /** Create new CoreSettings. */
    protected CoreSettings () {
    }


    //
    // itself
    //

    /** If true then external execution is used */
    public String displayName () {
        String displayName = Util.THIS.getString ("CTL_XML_option");

        if ( Util.THIS.isLoggable() ) /* then */ Util.THIS.debug ("CoreSettings::displayName = " + displayName); // NOI18N

        return displayName;
    }
    

    public HelpCtx getHelpCtx() {
        //return new HelpCtx( CoreSettings.class);
        return HelpCtx.DEFAULT_HELP;
    }
    
    //
    // Auto parsing delay
    //

    /** Gets the delay time for the start of the parsing.
     * @return The time in milis
     */
    public int getAutoParsingDelay () {
        if ( Util.THIS.isLoggable() ) /* then */ Util.THIS.debug ("CoreSettings::getAutoParsingDelay: " + autoParsingDelay); // NOI18N

        return autoParsingDelay;
    }

    /** Sets the delay time for the start of the parsing.
     * @param delay The time in milis
     */
    public void setAutoParsingDelay (int delay) {
        if ( Util.THIS.isLoggable() ) /* then */ Util.THIS.debug ("CoreSettings::setAutoParsingDelay: " + delay); // NOI18N

        if (delay < 0)
            throw new IllegalArgumentException();

        int oldValue = autoParsingDelay;
        autoParsingDelay = delay;
        firePropertyChange (PROP_AUTO_PARSING_DELAY, new Integer (oldValue), new Integer (autoParsingDelay));
    }
    
    
    /** 
     * Getter for prefered default action class name. 
     * It should be used at all places tackling with default action for all XML 
     * flavours (XSLT, DTD, ...). Note: some more specifics mechanism can defined
     * for particular XML flavour.
     * @return Value of property default action class or <code>null</code>.
     */
    public String getDefaultAction() {
        return this.defaultAction;
    }
    
    /** Setter for property defaultAction.
     * @param defaultAction New value of property defaultAction.
     */
    public void setDefaultAction(String defaultAction) {
        String old = this.defaultAction;
        this.defaultAction = defaultAction;
        firePropertyChange(PROP_DEFAULT_ACTION, old, defaultAction);
    }

    /**
     * Utility method for determinig default action.
     * @param actions an array of actons that are available at client
     * @param systemDefault a fallback system defaul action
     */
    public SystemAction getDefaultAction(SystemAction actions[], SystemAction systemDefault) {
        String defaultAction = getDefaultAction();
        if (defaultAction == null) return systemDefault;
        if (actions == null) return systemDefault;
        
        // does it exist at client's action pool?
        for (int i=0; i<actions.length; i++) {
            SystemAction next = (SystemAction) actions[i];
            if (next == null) continue;
            Class klass = next.getClass();
            String name = klass.getName();
            if (name.equals(defaultAction)) {
                return next;
            }
        }

        return systemDefault;
    }
    
    /**
     * @return true if "&lt;empty/&gt;" is preffered over "&lt;empty&gt;&lt;/empty&gt;"
     */
    public boolean isPreferedShortEmptyElement() {
        return shortEmptyElement;
    }
    
    /**
     * @param true if "&lt;empty/&gt;" is preffered over "&lt;empty&gt;&lt;/empty&gt;"
     */
    public void setPreferedShortEmptyElement(boolean pref) {
        boolean old = shortEmptyElement;
        this.shortEmptyElement = pref;
        firePropertyChange(PROP_PREFERED_SHORT_EMPTY_ELEMENT, old, shortEmptyElement);
    }
    
    private void firePropertyChange(String name, boolean oldval, boolean newval) {
        firePropertyChange(
            name, 
            oldval == true ? Boolean.TRUE : Boolean.FALSE, 
            newval == true ? Boolean.TRUE : Boolean.FALSE
        );
    }
}
